<?php
namespace Moto\InputFilter; use Moto; use Website\Widgets; use Zend; class Factory { protected static $_inputFactory; protected static $_typeMap = array(); protected static function _getInputFactory() { if (static::$_inputFactory === null) { static::$_inputFactory = new Zend\InputFilter\Factory(); } return static::$_inputFactory; } public static function create($fields) { $inputFilter = new Moto\InputFilter\AbstractInputFilter(); if (!is_array($fields)) { return $inputFilter; } foreach ($fields as $field) { $input = static::createInput($field); if ($input) { $inputFilter->add($input, $input->getName()); } else { } } return $inputFilter; } public static function createInput($field) { $input = null; $factory = static::_getInputFactory(); $widget = Moto\Util::getValue($field, 'widget'); if ($widget instanceof Widgets\FormElements\AbstractFormInputWidget) { $input = $widget->createInputFilter($factory); if ($input instanceof Zend\InputFilter\InputFilterInterface) { return $input; } if ($input instanceof Zend\InputFilter\InputInterface) { return $input; } } else { $widget = null; } $specification = array( 'name' => $field['name'], 'allow_empty' => true, ); $type = static::_sanitizeInputType(Moto\Util::getValue($field, 'type')); if (is_string($type) && $type !== '') { $specification['type'] = $type; } if (array_key_exists('fallback_value', $field)) { $specification['fallback_value'] = $field['fallback_value']; } if (array_key_exists('required', $field)) { $specification['required'] = $field['required']; $specification['allow_empty'] = false; } $filters = Moto\Util::getValue($field, 'filters'); if (is_array($filters)) { $filters = static::_sanitizeFilters($filters); } if ($widget) { $filters = $widget->sanitizeInputFilters($filters); } if (is_array($filters)) { $specification['filters'] = $filters; } $validators = Moto\Util::getValue($field, 'validators'); if (is_array($validators)) { if (in_array('required', $validators)) { $specification['required'] = true; $specification['allow_empty'] = false; } $validators = static::_sanitizeValidators($validators); } if ($widget) { $validators = $widget->sanitizeInputValidators($validators); } if (is_array($validators)) { $specification['validators'] = $validators; } try { $input = $factory->createInput($specification); } catch (\Exception $e) { if (Moto\System::isDevelopmentStage()) { Moto\System\Log::alert(__CLASS__ . ' :: Cant create input by Exception'); Moto\System\Log::alert("\tException", array( 'code' => $e->getCode(), 'message' => $e->getMessage(), )); Moto\System\Log::alert("\tField : " . print_r($field, true)); Moto\System\Log::alert("\tSpecification : " . print_r($specification, true)); } return null; } return $input; } protected static function _sanitizeInputType($type) { return Moto\Util::getValue(static::$_typeMap, $type); } protected static function _sanitizeFilters($items = array()) { $result = array(); if (!is_array($items) || !count($items)) { return $result; } foreach ($items as $item) { if (is_array($item)) { $result[] = $item; continue; } $filter = null; if (is_string($item)) { $temp = explode(':', $item, 2); $filterName = strtolower($temp[0]); $options = null; if (count($temp) > 1) { $options = $temp[1]; } switch ($filterName) { case 'trim': $filter = array( 'name' => 'StringTrim', ); break; } } if (is_array($filter)) { $result[] = $filter; } } return $result; } protected static function _sanitizeValidators($items = array()) { $result = array(); if (!is_array($items) || !count($items)) { return $result; } foreach ($items as $item) { if (is_array($item)) { $result[] = $item; continue; } $validator = null; if (is_string($item)) { $temp = explode(':', $item, 2); $filterName = strtolower($temp[0]); $options = null; if (count($temp) > 1) { $options = $temp[1]; } switch ($filterName) { case 'length': $values = explode(',', $options); $validator = array( 'name' => 'StringLength', 'options' => array( 'encoding' => 'UTF-8', 'min' => $values[0], 'max' => empty($values[1]) ? null : $values[1], ), ); break; case 'between': $values = explode(',', $options); $validator = array( 'name' => 'Between', 'options' => array( 'min' => $values[0], 'max' => empty($values[1]) ? PHP_INT_MAX : $values[1], ), ); break; case 'in': $validator = array( 'name' => 'InArray', 'options' => array( 'haystack' => explode(',', $options) ) ); break; case 'email': $validator = array( 'name' => 'EmailAddress', 'options' => array( 'useMxCheck' => false, 'useDeepMxCheck' => false, 'useDomainCheck' => false, ), 'break_chain_on_failure' => true, ); break; case 'recaptcha': $validator = array( 'name' => 'Moto\\Validator\\ReCaptcha', 'break_chain_on_failure' => true, ); break; } } if (is_array($validator)) { $result[] = $validator; } } return $result; } }