<?php
namespace Moto\Json\Server; use Moto; use Zend; use Zend\Json\Server\Request as JsonRequest; use Zend\Json; class Request extends JsonRequest { protected $_isBatch = false; protected $_queue = array(); protected $_serviceName; protected $_serviceMethod; protected $_files = array(); public function __construct($json = null) { if (empty($json)) { $json = $this->_loadConstructData($json); } if (!empty($json)) { $this->loadJson($json); } } protected function _loadConstructData($input = null) { if (!$this->isUpload()) { return file_get_contents('php://input'); } $request = new Zend\Http\PhpEnvironment\Request(); $data = array( 'jsonrpc' => '2.0', 'id' => null, 'method' => null, 'params' => array(), ); if (null === $input) { $input = $request->getPost()->toArray(); } foreach ($data as $key => $value) { if (array_key_exists($key, $input)) { $data[$key] = $input[$key]; } } if (is_string($data['params'])) { if (get_magic_quotes_gpc() && strpos($data['params'], '\\"') !== false) { $data['params'] = stripslashes($data['params']); } $data['params'] = json_decode($data['params'], true); if (!is_array($data['params'])) { $data['params'] = array($data['params']); } } try { $files = $request->getFiles()->toArray(); $this->_files = Moto\Util::getValue($files, 'params', array()); } catch (\Exception $e) { if (Moto\System::isDevelopmentStage()) { Moto\System\Log::error(__CLASS__ . '::' . __FUNCTION__ . ' Exception [ ' . $e->getCode() . ' ] ' . $e->getMessage()); } } return $data; } public function hasFiles() { return !empty($this->_files); } public function getFilesByParam($prefix = '') { return (array) Moto\Util::getValue($this->_files, $prefix, array()); } public function isUpload() { return (!empty($_SERVER['CONTENT_TYPE']) && preg_match('/(multipart|form-data)/i', $_SERVER['CONTENT_TYPE'])); } public function loadJson($json) { try { if (is_string($json)) { $options = Json\Json::decode($json, Json\Json::TYPE_ARRAY); } else { $options = $json; } $this->_isBatch = (is_array($options) && array_key_exists(0, $options) && !array_key_exists('method', $options)); if ($this->_isBatch) { for ($i = 0, $count = count($options); $i < $count; $i++) { $request = new Request($options[$i]); $this->_queue[] = $request; } } else { $this->setOptions($options); } } catch (\Exception $e) { $this->isParseError = true; } } public function isBatch() { return $this->_isBatch; } public function getQueue() { return $this->_queue; } public function setMethod($name) { parent::setMethod($name); if (!$this->isMethodError) { if (preg_match('/^(.*)\.([^\.]+)$/', $this->method, $match)) { $this->_serviceName = $match[1]; $this->_serviceMethod = $match[2]; } } return $this; } public function getServiceName() { return $this->_serviceName; } public function getServiceMethod() { return $this->_serviceMethod; } public function getParam($index, $default = null) { if (array_key_exists($index, $this->params)) { return $this->params[$index]; } return $default; } public function issetParam($index) { return (array_key_exists($index, $this->params)); } } 