<?php
 namespace Moto\Module\Blog; use Moto; use Moto\System\ContentSection\HasContentProviderInterface; use Website; use Zend; class BlogApplication extends Moto\Website\Application implements HasContentProviderInterface { const PAGE__INDEX = 'index'; const PAGE__POST = 'post'; const PAGE__TAG = 'tag'; const PAGE__CATEGORY = 'category'; const ROUTE__TAXONOMY = 'taxonomy'; const TAXONOMY_TAG_CLASS = Moto\Database\Models\ContentTaxonomyTag::class; const TAXONOMY_CATEGORY_CLASS = Moto\Database\Models\ContentTaxonomyCategory::class; protected $_contentSection = 'blog'; protected $_initialized = false; protected $_rawGlobalRoutes = array( '/{prefix}/*' ); protected $_globalRoutes; protected $_router; public function getTaxonomyClass($entity) { $method = 'getTaxonomy' . Moto\Util::toStudlyCase($entity) . 'Class'; if (method_exists($this, $method)) { return $this->{$method}(); } return static::TAXONOMY_TAG_CLASS; } protected function getTaxonomyCategoryClass() { return static::TAXONOMY_CATEGORY_CLASS; } protected function getTaxonomyQuery($type) { $class = $this->getTaxonomyClass($type); $model = new $class(); $query = $model->newQuery(); $query->where('type', $this->_contentSection . '.' . $type); return $query; } public function onFillingBreadcrumbs($event, Moto\System\PriorityCollection $collection) { $category = $collection->first(function ($item) { return $item['type'] === $this->_contentSection . '.' . static::PAGE__CATEGORY; }); if ($category) { return; } foreach ($collection as $item) { if ($item['type'] !== $this->_contentSection . '.' . static::PAGE__POST) { continue; } $target = $item->getTarget(); if ($target instanceof Moto\Application\Pages\PageModel) { $category = $target->getCategoryModel(); } elseif ($target instanceof Moto\Database\Models\Page) { $category = $target->category; } if (!$category) { break; } if ($collection->isTargetExists($category)) { break; } $item->insertBefore($category); } return $collection; } public function getGlobalRoutes() { if ($this->_globalRoutes) { return $this->_globalRoutes; } $this->_globalRoutes = array(); $prefixUri = $this->getRouteUri(); foreach ($this->_rawGlobalRoutes as $index => $uri) { $this->_globalRoutes[$index] = str_replace('{prefix}', $prefixUri, $uri); } return $this->_globalRoutes; } public function getRouteUri() { $page = $this->getMainPage(); if (!$page) { return $this->_contentSection; } return $page->url; } public function getMainPage() { $page = $this->getContentProvider()->getMainPage(); if ($page) { return $page; } Moto\System\Log::critical('[ Blog Application ] : cant find a main page'); return null; } public function getContentProvider() { return Moto\System::app(Moto\System\ContentSection\ContentSectionManager::class) ->getProvider($this->_contentSection); } public function isMainPage($page) { if ($page instanceof Moto\Application\Pages\PageModel || $page instanceof Moto\Website\ContentPage) { return ($page->type === $this->_contentSection . '.' . static::PAGE__INDEX); } return null; } protected function _getInnerRouter() { if (!$this->_router) { $this->_router = new Moto\System\Router($this->getRouteUri()); $this->_router->addPath('/', [ 'type' => static::PAGE__INDEX, ]); $provider = $this->getContentProvider(); $taxonomies = $provider->getTaxonomyDefinitions(); foreach ($taxonomies as $name => $taxonomy) { $uri = Moto\Util::getValue($taxonomy, 'uri'); if (empty($uri)) { $uri = $name; } $this->_router->addPath('/' . $uri . '/*', [ 'name' => $name, 'uri' => $uri, 'type' => static::ROUTE__TAXONOMY, ]); } $this->_router->addPath('/*', [ 'type' => static::PAGE__POST, ]); } return $this->_router; } public function findPageByUrl($relativeUrl) { $page = null; if ($relativeUrl === '/') { $route = [ 'type' => static::PAGE__INDEX, ]; } else { $router = $this->_getInnerRouter(); $route = $router->findOne($relativeUrl); } switch (Moto\Util::getValue($route, 'type', (is_string($route) ? $route : null))) { case static::PAGE__INDEX: $page = $this->getMainPage(); if ($page) { $page = $this->getContentProvider()->wrapByContentPage($page); } break; case static::ROUTE__TAXONOMY: $target = null; $pattern = '/\/' . str_replace('/', '\/', $route['uri']) . '\/(?<slug>[^\/]*)/'; if (preg_match($pattern, $relativeUrl, $match)) { $target = $this->getTaxonomyQuery($route['name']) ->where('slug', '=', $match['slug']) ->first(); } if (!$target) { break; } $page = $this->getContentProvider()->wrapByContentPage($target); break; } if (!$page) { $page = parent::findPageByUrl($relativeUrl); if ($page) { $page = $this->getContentProvider()->wrapByContentPage($page); } } return $page; } public function getInnerUrl($resource = null, $type = null) { if ($resource === null) { return $this->getRouteUri(); } $url = null; if (!empty($type) && Moto\System::isDevelopmentStage()) { try { throw new \Exception('sss'); } catch (\Exception $e) { } Moto\System\Log::emergency('###!!!!### ' . __METHOD__ . ' => ' . var_export([ '$resource' => $resource, '$type' => $type, 'trace' => $e->getTraceAsString(), ], true)); } if (!is_object($resource) && !empty($type)) { switch ($type) { case static::PAGE__POST: $resource = Moto\Website\Pages::find($resource); break; default: $resource = $this->getTaxonomyQuery($type)->find($resource); break; } } $prefixUri = $this->getRouteUri(); if ($resource instanceof Moto\Database\Models\ContentTaxonomy) { $innerType = $resource->getInnerType(); $uri = $this->getContentProvider()->getTaxonomyDefinition($innerType, 'uri'); if (empty($uri)) { $uri = $innerType; } $url = $uri . '/' . $resource->slug; } elseif ($resource instanceof Moto\Application\Pages\PageModel) { $url = $resource->getInnerUrl(); } elseif ($resource instanceof Moto\Database\Models\Page) { if (method_exists($resource, 'getInnerUrl')) { $url = $resource->getInnerUrl(); } else { return Moto\Website\Pages::getInnerUrl($resource->id); } } return $prefixUri . '/' . $url; } public function getAbsoluteUrl($resource = null, $type = null) { $url = $this->getInnerUrl($resource, $type); if (is_string($url)) { $url = Moto\ClickAction\Page::buildUrl($url); $url = Moto\System::getAbsoluteUrl($url); } return $url; } public function getRelativeUrl($resource = null, $type = null) { $url = $this->getInnerUrl($resource, $type); if (is_string($url)) { $url = Moto\ClickAction\Page::buildUrl($url); $url = Moto\System::getRelativeUrl($url); } return $url; } public function bootAsHomePage() { if ('' === 'disabled') { Moto\System::getSystemRouter()->addPath('/', $this->_contentSection); } return true; } } 