<?php
 namespace Moto\Module\Inner; use Illuminate; use Illuminate\Http\Request; use Illuminate\Routing\Router; use Illuminate\Support\Facades\Event; use Moto; use Moto\Module\Inner\Middleware; use Moto\Module\Inner\Http\Controllers; class InnerApplication { protected $app; protected $config; protected $router; public function __construct(Moto\System\Application $app) { $this->app = $app; $this->config = $app->make('config'); $this->bootstrap(); } protected function bootstrap() { if (!$this->app->bound('translator')) { $this->app->singleton('translator', function () { return new Translator(); }); } } public function getRouter() { if ($this->router) { return $this->router; } $this->router = $this->app->make('router'); $this->router->prefix('_') ->middleware([ Middleware\NotCachedResponse::class, ]) ->group(function (Router $router) { $router->get('/jump/page/{id}', [Controllers\JumpToPageController::class, 'jump']) ->where('id', '[0-9]+'); Event::dispatch(new Events\InnerRouterCreated($router)); }); $routes = $this->router->getRoutes(); $routes->refreshNameLookups(); $routes->refreshActionLookups(); return $this->router; } public function handle() { try { $kernel = new Illuminate\Foundation\Http\Kernel($this->app, $this->getRouter()); $response = $kernel->handle( $request = Request::capture() )->send(); $kernel->terminate($request, $response); } catch (\Exception $e) { echo "Exception : {$e->getCode()} {$e->getMessage()}\n"; echo $e->getTraceAsString(); exit; } } } 