<?php
 namespace Moto\Platform; use Illuminate\Support\Arr; use Illuminate\Support\Facades\Event; use Moto; use Moto\Platform\Responses\ApiResponse; use Moto\System\Traits\OptionsTrait; class BaseApiClient { const DEFAULT_AUTH_TOKEN_NAME = 'api'; use OptionsTrait; protected $_options = [ 'baseUrl' => '', ]; protected $actions = []; protected $accessTokens = []; protected $tokenResolver; public function setTokenResolver($callback) { if ($callback === null || is_callable($callback)) { $this->tokenResolver = $callback; return $this; } throw new \InvalidArgumentException('Invalid token resolver type'); } public function setAccessToken($token, string $name = null) { if (is_array($token)) { if (empty($name)) { $name = Arr::get($token, 'name'); } $token = Arr::get($token, 'token'); } if (empty($name)) { $name = static::DEFAULT_AUTH_TOKEN_NAME; } $this->accessTokens[$name] = $token; return $this; } protected function getAccessToken($name, array $action = [], array $params = []) { if ($this->tokenResolver) { return call_user_func($this->tokenResolver, $name, $action, $params); } if ($name === null || is_bool($name)) { $name = static::DEFAULT_AUTH_TOKEN_NAME; } return Arr::get($this->accessTokens, $name); } protected function requireAccessToken($name, array $action = [], array $params = []) { $token = $this->getAccessToken($name, $action, $params); if (empty($token)) { throw new \RuntimeException('Access token ' . var_export($name, true) . ' is empty'); } return $token; } protected function getDefaultHeaders() { $headers = (array) $this->getOption('defaultHeaders', []); $headers['X-Moto-Api-Environment'] = $this->getEnvironment(); return $headers; } protected function getBaseUrl() { return $this->getOption('baseUrl'); } protected function requireBaseUrl() { return $this->requireOption('baseUrl'); } public function getFrontendUrl() { return $this->getOption('frontendUrl', $this->requireBaseUrl()); } public function getBackendUrl() { return $this->getOption('backendUrl', $this->requireBaseUrl()); } public function getRequestUrl(string $name, array $parameters = []) { if (!array_key_exists($name, $this->actions)) { throw new \InvalidArgumentException('Unknown action : ' . var_export($name, true)); } $action = $this->actions[$name]; return $this->createRequestUri($action['path'], $parameters, Arr::get($action, 'type')); } protected function createRequestUri($path, array $parameters = [], $type = 'backend') { if (preg_match('/^http[s]?:/i', $path)) { $url = $path; } else { if ($type === 'frontend') { $base = $this->getFrontendUrl(); } elseif ($type === 'backend') { $base = $this->getBackendUrl(); } else { $base = $this->getBaseUrl(); } $url = rtrim($base, '/') . '/' . ltrim($path, '/'); } if (empty($parameters)) { return $url; } return $url . (str_contains($url, '?') ? '&' : '?') . http_build_query($parameters, '', '&', PHP_QUERY_RFC3986); } protected function makeCall(string $action, array $params = [], $expect = null) { $client = $this->prepareHttpClient($action, $params); $result = new ApiResponse(); if ($expect) { $result->setResponseType($expect); } Event::dispatch(new Events\ApiRequestEvent($action, $params, $client)); $content = $client->send(); $result->setRequest($client->getRequest()); $result->setResponse($content); $adapter = $client->getAdapter(); $handle = $adapter->getHandle(); if (is_resource($handle) || $handle instanceof \CurlHandle) { $result->setCurlHandle($handle); } $adapter->close(); Event::dispatch(new Events\ApiResponseEvent($action, $params, $result)); return $result; } protected function prepareHttpClient($name, array $params) { if (!array_key_exists($name, $this->actions)) { throw new \InvalidArgumentException('Unknown api action : ' . var_export($name, true)); } $params = array_merge([ 'body' => null, 'parameters' => [], ], $params); $action = $this->actions[$name]; $params['parameters'] = array_merge((array) Arr::get($action, 'parameters', []), $params['parameters']); $client = new Moto\Http\Client(); $url = $this->createRequestUri($action['path'], $params['parameters']); $client->setUri($url); $httpMethod = strtoupper(Arr::get($action, 'method', 'GET')); $client->setMethod($httpMethod); $headers = (array) $this->getDefaultHeaders(); $headers = array_merge($headers, (array) Arr::get($action, 'headers', [])); $authorize = Arr::get($action, 'authorize', false); if (array_key_exists('authorize', $params)) { $authorize = $params['authorize']; } if ($authorize) { $headers = array_merge($headers, [ 'Authorization' => 'Bearer ' . $this->requireAccessToken($authorize, $action, $params), ]); } if (Arr::get($action, 'accept', 'json') === 'json') { $headers = array_merge($headers, [ 'Accept' => 'application/json', ]); } if (in_array($httpMethod, ['POST', 'PUT', 'PATCH'], true)) { $body = $params['body']; if (is_object($body)) { $body = Moto\Util::toArray($body); } if (is_array(Arr::get($action, 'body'))) { if (!is_array($body)) { throw new \RuntimeException('Body is required as array'); } $body = array_merge($action['body'], $body); } if (Arr::get($action, 'request', 'json') === 'form') { $client->setParameterPost($body); } else { if (is_array($body)) { $headers = array_merge($headers, [ 'Content-Type' => 'application/json', ]); $body = json_encode($body); } $client->setRawBody($body); } } $client->getRequest()->getHeaders()->addHeaders($headers); return $client; } public function getEnvironment() { $env = [ 'engine' => [ 'type' => Moto\System\Settings::getEngine()->getType(), 'build' => Moto\Version::getCurrentBuild(), 'version' => Moto\Version::getCurrentVersion(), 'brand' => Moto\System\Brand::getInstance()->getName(), 'url' => Moto\System::getAbsoluteUrl(), ], ]; $env['server'] = Arr::only($_SERVER, [ 'SERVER_NAME', 'HTTP_HOST', ]); $env['server'] = array_values($env['server']); $env['server'] = array_unique($env['server']); $env['server'] = implode('|', $env['server']); return base64_encode(json_encode($env)); } public function toSimpleResponse(ApiResponse $response) { if ($response->isSuccessful()) { return Responses\SuccessResponse::createFromApiResponse($response); } return Responses\FailResponse::createFromApiResponse($response); } } 