<?php
 namespace Moto\Platform; use Firebase\JWT\JWT; use Illuminate\Support\Arr; use Illuminate\Support\Carbon; use Illuminate\Support\Collection; use Moto; use Moto\Platform\Responses; use Moto\System\Traits\OptionsTrait; use Ramsey\Uuid\Uuid; class BaseManager { use OptionsTrait; protected $_defaultOptions = [ 'enabled' => false, ]; protected $_options = [ 'enabled' => false, 'signature' => '_NO_', ]; protected $app; protected $apiClient; protected $storage; protected $rpcService; public function __construct($app, array $options = []) { $this->app = $app; $this->setDefaultsOptions($this->_defaultOptions); $this->autoDetectOptions(); $this->setOptions($options); } protected function autoDetectOptions() { if (Moto\System::env('MOTO_ENV_PLATFORM_ENABLED') === true) { $this->setOption('enabled', true); } if (!empty($value = Moto\System::env('MOTO_ENV_PLATFORM_BASE_URL'))) { $this->setOption('baseUrl', $value); } if (!empty($value = Moto\System::env('MOTO_ENV_PLATFORM_BACKEND_URL'))) { $this->setOption('backendUrl', $value); } if (!empty($value = Moto\System::env('MOTO_ENV_PLATFORM_FRONTEND_URL'))) { $this->setOption('frontendUrl', $value); } if (!empty($value = Moto\System::env('MOTO_ENV_PLATFORM_SIGNATURE'))) { $this->setOption('signature', $value); } } protected function setDefaultsOptions($options) { $this->_options = array_merge($this->_options, $options); } public function getApiClient() { if (!$this->apiClient) { $this->apiClient = $this->createApiClient(); } return $this->apiClient; } public function setApiClient(BaseApiClient $client) { $this->apiClient = $client; return $this; } protected function setSignatureOption($value) { if (!is_string($value)) { $value = '_INVALID_'; } elseif (empty($value = trim($value))) { $value = '_EMPTY_'; } $this->setOptionRawValue('signature', $value); } protected function createApiClient() { $client = $this->app->make($this->requireOption('ApiClientClass')); $client->setOptions(array_filter([ 'baseUrl' => $this->requireOption('baseUrl'), 'frontendUrl' => $this->getOption('frontendUrl'), 'backendUrl' => $this->getOption('backendUrl'), 'defaultHeaders' => [ 'X-Moto-Platform-Version' => 'First', 'X-Moto-Platform-Signature' => (string) $this->getOption('signature'), ], ])); $client->setAccessToken($this->getAccessToken()); return $client; } protected function requireStorageKey() { $host = parse_url($this->requireOption('baseUrl'), PHP_URL_HOST); return 'platform::' . strtolower(str_replace('.', '_', $host)); } protected function loadStorage() { $data = Moto\System\Settings::get($this->requireStorageKey()); if (!empty($data)) { $data = Moto\System\Encryption::decrypt($data, Moto\System\Encryption::METHOD_JSON); } if (!is_array($data)) { $data = []; } $data = array_merge([ 'access_token' => null, ], $data); return $data; } public function saveStorage() { $data = Moto\System\Encryption::encrypt($this->getStorage()->toArray(), Moto\System\Encryption::METHOD_JSON); Moto\System\Settings::add($this->requireStorageKey(), $data); return $this; } public function getStorage() { if ($this->storage) { return $this->storage; } $this->storage = new Collection($this->loadStorage()); return $this->storage; } public function getAccessToken() { return (array) $this ->getStorage() ->get('access_token'); } protected function setAccessToken(array $token) { if (empty($token['created_at'])) { $token['created_at'] = Carbon::now('UTC')->getTimestamp(); } $this->getStorage()->put('access_token', $token); return $this; } public function getStorageValue($name, $default = null) { if (in_array($name, ['access_token'])) { throw new \Exception('This key can be retrieve'); } return $this->getStorage()->get($name, $default); } public function hasStorageValue($name) { return $this->getStorage()->has($name); } public function setStorageValue($name, $value = null) { if (is_array($name)) { foreach ($name as $property => $value) { $this->setStorageValue($property, $value); } return $this; } if (in_array($name, ['access_token'])) { throw new \Exception('This key can be update'); } $this->getStorage()->put($name, $value); return $this; } public function isEnabled() { return ((boolean) $this->getOption('enabled')) && !empty($this->getOption('baseUrl')); } public function isConnected() { return !empty(Arr::get($this->getAccessToken(), 'token')); } public function connectProductIfNeed() { if ($this->isConnected()) { return true; } return $this->connectProduct() ->isSuccessful(); } public function connectProduct(array $data = []) { if (!$this->isEnabled()) { return Responses\FailResponse::create('Platform not enabled'); } $stamp = Moto\System\ProductInformation::getProductStamp(); if (!$stamp) { return Responses\FailResponse::create('Cant generate product stamp'); } $sign = Moto\System\ProductInformation::get('request_sign'); if (empty($sign)) { return Responses\FailResponse::create('Bad ProductInformation'); } $now = Carbon::now('UTC'); $product = Moto\System\ProductInformation::getProductId(); $payload = [ 'iat' => $now->timestamp, 'exp' => null, 'iss' => 'MotoEngine:' . $product, 'sub' => 'Platform:ProductRegistration', 'jti' => Uuid::uuid4()->toString(), 'request' => $stamp, 'user' => null, 'data' => $data, 'access_token' => $this->getAccessToken(), ]; $ttl = (int) $this->getOption('tokenTtl'); if ($ttl > 0) { $payload['exp'] = $now->addMinutes($ttl)->timestamp; } else { unset($payload['exp']); } $user = Moto\System::getUser(); if ($user) { $payload['user'] = [ 'id' => $user->id, 'name' => $user->name, 'email' => $user->email, 'language_code' => $user->language_code ]; } $token = JWT::encode($payload, $sign, 'HS256'); $api = $this->getApiClient(); $response = $api->productRegistration($product, $token); if (!$response->isSuccessful()) { return Responses\FailResponse::createFromApiResponse($response); } $this->setAccessToken(Arr::get($response->getResponse(), 'access_token')); $this->saveStorage(); return Responses\SuccessResponse::createFromApiResponse($response); } public function pingPong() { if (!$this->isEnabled()) { return Responses\FailResponse::create('Platform not enabled'); } $api = $this->getApiClient(); $response = $api->pingPong([ 'stamp' => Moto\System\ProductInformation::getProductStamp() ]); return $api->toSimpleResponse($response); } public function productWasUpgraded() { if (!$this->isEnabled()) { return Responses\FailResponse::create('Platform not enabled'); } if (!$this->isConnected()) { return $this->connectProduct(); } $api = $this->getApiClient(); $response = $api->productWasUpgraded(Moto\System\ProductInformation::getProductStamp()); if (!$response->isSuccessful()) { return Responses\FailResponse::createFromApiResponse($response); } $token = Arr::get($response->getResponse(), 'access_token'); if (!empty($token)) { $this->setAccessToken($token); $this->saveStorage(); } return Responses\SuccessResponse::createFromApiResponse($response); } public function getJsonRpcService() { if (!$this->rpcService) { $this->rpcService = $this->app->make($this->requireOption('JsonRpcServiceClass')); $this->rpcService->setManager($this); } return $this->rpcService; } public function getGoogleAccountConnector() { return $this->app->make(Google\GoogleAccountConnector::class, ['platform' => $this]); } } 