<?php
 namespace Moto\Platform\Google; use Google; use Moto; use Moto\Platform; class GoogleAccountConnector { protected $platform; protected $tokens = []; public function __construct(Platform\BaseManager $platform) { $this->platform = $platform; } public function generateConnectionUrlForService(string $service, array $options = []) { $client = $this->platform->getApiClient(); $user = Moto\System::getUser(); $parameters = []; $parameters['product'] = Moto\System\ProductInformation::getProductId(); $parameters['client'] = 'MotoEngine:' . Moto\Version::getCurrentVersion(); $parameters['environment'] = $client->getEnvironment(); $parameters['response']['target'] = 'base64:' . base64_encode(Moto\System::getPersistentUrl('/platform/google-connection/callback')); $parameters['state'] = [ 'version' => 1, 'user_id' => $user->id, 'product' => $parameters['product'], 'created' => time(), 'service' => $service, ]; if (!empty($options['callback'])) { $parameters['state']['callback'] = $options['callback']; } if (!empty($options['login'])) { $parameters['login_hint'] = trim($options['login']); $parameters['state']['required_login'] = $parameters['login_hint']; } $parameters['state'] = array_filter($parameters['state']); $parameters['state'] = Moto\System::encrypt($parameters['state']); $parameters = array_filter($parameters); return $client->getRequestUrl('google-account/connection', $parameters); } protected function getTokenName(string $service = 'default') { return 'google::' . $service; } public function getUserToken(string $service) { if (array_key_exists($service, $this->tokens)) { return $this->tokens[$service]; } $token = new Platform\Token\UserToken(); $token->setConnector($this); $token->setNamespace($this->getTokenName($service)); $token->loadData(); $this->tokens[$service] = $token; return $token; } public function fetchAccessTokenInfo(string $token) { $oauth = new Google\Service\Oauth2(); $tokenInfo = $oauth->tokeninfo([ 'access_token' => $token, ]); return [ 'user_id' => $tokenInfo->userId, 'email' => $tokenInfo->email, ]; } } 