<?php
 namespace Moto\Platform\Http\Controllers; use Illuminate; use Illuminate\Http\Request; use Illuminate\Support\Arr; use Moto; use Moto\Platform; class GoogleAccountController { protected function log($message, array $extra = []) { } public function callback(Request $request) { $error = $request->get('error'); if (!empty($error)) { $this->log('[' . __METHOD__ . '] fail connected by "error" params => ' . var_export($error, true)); return $this->showError('Please provide full permissions to your account. Please start account connection again. This window can be closed'); } $state = Moto\System::decrypt($request->get('state')); if (!is_array($state)) { throw new \InvalidArgumentException('Invalid request state'); } $user = Moto\System::getUser(); if (!$user) { throw new \RuntimeException('No authenticated user'); } if ($user->id !== Moto\Util::getValue($state, 'user_id')) { throw new \InvalidArgumentException('Authenticated user not equal with requested user'); } if (Moto\System\ProductInformation::getProductId() !== Moto\Util::getValue($state, 'product')) { throw new \InvalidArgumentException('Product not equal with requested product'); } $service = Arr::get($state, 'service'); if (empty($service)) { return $this->showError('Service is not defined'); } $code = $request->get('code'); if (empty($code)) { throw new \InvalidArgumentException('Empty response code'); } $app = app(); $manager = $app->make('System.Platform'); $client = $manager->getApiClient(); $package = $client->retrievePackage($code); if (!$package->isSuccessful()) { $this->log('[Platform.RetrievePackage] : code ' . var_export($code, true) . ' package => ' . json_encode($package, JSON_PRETTY_PRINT)); return $this->showError('Error while connecting your account. Please refresh this page.'); } $token = $package->getAttribute('body'); try { $method = 'onConnect' . Moto\Util::toStudlyCase($service) . 'Service'; if (method_exists($this, $method)) { $result = $this->{$method}($token, $state); if ($result !== true) { return $result; } } $connector = $manager->getGoogleAccountConnector(); $userToken = $connector->getUserToken($state['service']); $userToken->fillFromApiResponse($token); if (!empty($state['required_login']) && ($state['required_login'] !== $userToken->getAttribute('email'))) { return $this->showError('Incorrect Google account was selected. You need to connect to the following email: ' . $state['required_login'] . '.<br> This window can be closed.'); } if (!$userToken->save()) { return $this->showError('Cant save data. Please start account connection again. This window can be closed'); } } catch (\Exception $e) { return $this->reportException($e); } try { $callback = Arr::get($state, 'callback'); if (!empty($callback)) { } } catch (\Exception $e) { } return view('platform.callback.success', [ 'token' => [ 'service' => $service, ], ]); } protected function onConnectCalendarService($token, $state) { $this->log('[Platform.CheckToken] : service "calendar", token => ' . json_encode(array_merge($token, [ 'access_token' => (empty($token['access_token']) ? null : 'size : ' . strlen($token['access_token'])), 'refresh_token' => (empty($token['refresh_token']) ? null : 'size : ' . strlen($token['refresh_token'])), ]), JSON_PRETTY_PRINT)); $scope = Moto\Util::getValue($token, 'scope'); if (!is_array($scope)) { $scope = explode(' ', (string) $scope); } $diff = array_diff([ 'https://www.googleapis.com/auth/calendar', 'https://www.googleapis.com/auth/calendar.events', ], $scope); if (!empty($diff)) { $this->log('[' . __METHOD__ . '] fail scope validation => ' . var_export([ 'scope' => $scope, 'diff' => $diff, ], true)); return $this->showError('Please provide full permissions to your account. Please start account connection again. This window can be closed'); } return true; } protected function showError($message, $code = 500) { return view('errors.show', [ 'message' => $message, ]); } protected function reportException(\Exception $exception) { return view('errors.show', [ 'message' => $exception->getMessage(), ]); } } 