<?php
 namespace Moto\Platform; use Moto; class PlatformApiClient extends BaseApiClient { protected $actions = [ 'product/registration' => [ 'authorize' => false, 'method' => 'POST', 'request' => 'json', 'parameters' => [], 'body' => [], 'path' => 'api/v1/product/registration', ], 'product/ping' => [ 'authorize' => true, 'method' => 'POST', 'path' => 'api/v1/product/ping', 'type' => 'backend', ], 'product/on-upgraded' => [ 'authorize' => true, 'method' => 'POST', 'path' => 'api/v1/product/on-upgraded', 'type' => 'backend', ], 'create/generate-text' => [ 'method' => 'POST', 'path' => 'api/v1/services/generate-text', ], 'postbox/get-package' => [ 'authorize' => true, 'method' => 'POST', 'path' => 'api/v1/postbox/get-package', 'type' => 'backend', ], 'google-account/connection' => [ 'path' => 'external/google/require-token', 'type' => 'frontend', ], 'google-account/refresh-token' => [ 'authorize' => true, 'method' => 'POST', 'path' => 'api/v1/google-account/refresh-token', 'type' => 'backend', ], ]; public function productRegistration($product, string $token) { return $this->makeCall('product/registration', [ 'body' => [ 'product' => $product, 'token' => $token, ], ]); } public function createTextGenerationChat(array $settings = []) { return $this->makeCall('create/generate-text', [ 'body' => [ 'settings' => $settings, ], ]); } public function retrievePackage(string $code) { $response = $this->makeCall( 'postbox/get-package', [ 'body' => [ 'code' => $code, ], ], Responses\PostBoxPackage::class ); if ($response->isSuccessful()) { return $response->getResponse(); } return Responses\FailResponse::createFromApiResponse($response); } public function refreshGoogleAccessToken(string $token) { $response = $this->makeCall( 'google-account/refresh-token', [ 'body' => [ 'token' => $token, ], ], ); if ($response->isSuccessful()) { return $response; } return Responses\FailResponse::createFromApiResponse($response); } public function pingPong(array $data = []) { return $this->makeCall('product/ping'); } public function productWasUpgraded(array $stamp = []) { return $this->makeCall('product/on-upgraded', [ 'body' => $stamp ]); } } 