<?php
 namespace Moto\Platform\Responses; use Exception; use Illuminate\Support\Arr; use Moto; class ApiResponse extends Moto\System\SimpleModel { protected $fillable = []; protected $attributes = [ 'status' => true, 'code' => 0, 'message' => '', 'description' => '', 'body' => null, 'response' => null, 'headers' => [], ]; protected $httpRequest; protected $httpResponse; protected $responseType = 'array'; protected $error; public function setResponseType($type) { if (!is_callable($type) && !in_array($type, [ 'string', 'array', 'object', ]) && !class_exists($type)) { throw new \InvalidArgumentException('Unsupported response type : ' . var_export($type, true)); } $this->responseType = $type; return $this; } public function setRequest($request) { if (!$request instanceof \Zend\Http\Request) { throw new \InvalidArgumentException('Unknown request type'); } $this->httpRequest = $request; return $this; } public function getRequest() { return $this->httpRequest; } public function setResponse($response) { if ($response instanceof Exception) { return $this->setException($response); } if (!$response instanceof \Zend\Http\Response) { throw new \InvalidArgumentException('Unknown response type'); } $this->httpResponse = $response; $this->setCode($response->getStatusCode()); $this->setMessage($response->getReasonPhrase()); $body = $response->getBody(); $this->attributes['body'] = $body; $this->attributes['headers'] = $response->getHeaders()->toArray(); if ($this->isSuccessful()) { $this->attributes['response'] = $this->castResponseType($body); } else { $this->tryDetectErrors(); } } protected function tryDetectErrors() { $body = $this->getBody(); if (str_contains($body, 'Composer detected')) { $this->setMessage('Platform not ready for using, check Platform server configuration'); return; } $body = $this->getJson(); } public function getErrors() { return $this->attributes['errors']; } protected function castResponseType($content) { $type = $this->responseType; if (is_callable($type)) { return call_user_func($type, $content); } if (empty($type) || $type === 'string') { return $content; } if ($type === 'array') { return json_decode($content, true); } if ($type === 'object') { return json_decode($content); } $response = new $type(); $response->setRawContent($content); return $response; } public function getBody() { return $this->attributes['body']; } public function getResponse() { return $this->attributes['response']; } public function getJson() { return json_decode($this->getBody(), true); } public function setException(Exception $exception) { $this->attributes['status'] = false; $this->setCode($exception->getCode()); $this->setMessage($exception->getMessage()); return $this; } public function setCode($code) { $this->attributes['code'] = (int) $code; return $this; } public function getCode() { return $this->attributes['code']; } public function setMessage($message) { $this->attributes['message'] = (string) $message; return $this; } public function getMessage() { return $this->attributes['message']; } public function isOk() { return $this->attributes['status'] && ($this->getCode() === 200); } public function isSuccessful() { $code = $this->getCode(); return $this->attributes['status'] && ($code >= 200 && $code < 300); } public function setCurlHandle($handle) { $info = curl_getinfo($handle); if ($this->getCode() === 0) { $this->setCode(Arr::get($info, 'http_code')); } if ($this->getCode() === 0) { $this->setCode(curl_errno($handle)); } if (empty($this->getMessage())) { $this->setMessage(curl_error($handle)); } return $this; } public static function create($message, $code = 400) { $response = new static(); $response->setException(new \Exception($message, $code)); return $response; } } 