<?php
 namespace Moto\Platform\Token; use Exception; use Google; use Illuminate\Support\Arr; use Illuminate\Support\Carbon; use InvalidArgumentException; use Moto; use Moto\Platform\Google\GoogleAccountConnector; use Moto\System\SimpleModel; class UserToken extends SimpleModel { use Moto\Platform\Concerns\UsePlatformTrait; protected $fillable = [ 'access_token', 'token_type', 'expires_in', 'refresh_token', 'scope', 'id_token', 'created', 'user_id', 'email', ]; protected $attributes = [ ]; protected $connector; protected $namespace; public function setNamespace(string $value) { $this->namespace = $value; return $this; } public function loadData() { if (empty($this->namespace)) { throw new \RuntimeException('Namespace is empty'); } $data = Moto\System\Settings::get('platform_token_' . $this->namespace); if (!empty($data)) { $data = Moto\System\Encryption::decrypt($data, Moto\System\Encryption::METHOD_JSON); } if (!is_array($data)) { $data = []; } $this->forceFill($data); return $this; } public function save() { if (empty($this->namespace)) { return false; } $data = Moto\System\Encryption::encrypt(Moto\Util::toArray($this->attributes), Moto\System\Encryption::METHOD_JSON); Moto\System\Settings::add('platform_token_' . $this->namespace, $data); $this->syncOriginal(); return true; } public function delete() { if (empty($this->namespace)) { return false; } Moto\System\Settings::delete('platform_token_' . $this->namespace); $this->attributes = []; $this->syncOriginal(); return true; } public function setConnector(GoogleAccountConnector $connector) { $this->connector = $connector; return $this; } protected function getConnector() { if (!$this->connector) { $this->connector = Moto\System::app('System.Platform')->getGoogleAccountConnector(); } return $this->connector; } public function getNow() { return Carbon::now('UTC')->getTimestamp(); } public function getAccessToken() { return (string) $this->getAttribute('access_token'); } public function getExpiresAt() { return (int) $this->getAttribute('created') + (int) $this->getAttribute('expires_in'); } public function getExpiresAfter() { return $this->getExpiresAt() - $this->getNow(); } public function isAccessTokenExpired() { return ($this->getExpiresAt() - 30 < $this->getNow()); } public function getRefreshToken() { return (string) $this->getAttribute('refresh_token'); } public function hasRefreshToken() { return !empty($this->getRefreshToken()); } public function getScopes() { $scope = $this->getAttribute('scope'); if (empty($scope)) { return []; } if (is_string($scope)) { $scope = explode(' ', $scope); } sort($scope); return $scope; } public function get($attribute, $default = null) { return $this->getAttribute($attribute); } public function fillFromApiResponse(array $token, $reset = false) { if (empty($token['access_token'])) { throw new InvalidArgumentException('"access_token" is empty'); } $userInfo = []; if (array_key_exists('id_token_payload', $token)) { $userInfo = [ 'user_id' => Arr::get($token['id_token_payload'], 'sub'), 'email' => Arr::get($token['id_token_payload'], 'email'), ]; } if (empty($userInfo) || empty($userInfo['email'])) { try { $tokenInfo = $this->getConnector()->fetchAccessTokenInfo($token['access_token']); $userInfo = [ 'user_id' => $tokenInfo->userId, 'email' => $tokenInfo->email, ]; } catch (Exception $e) { } } if ($reset) { $this->attributes = []; } $this->fill(Arr::except($token, ['id_token_payload'])); if (!empty($userInfo)) { $this->fill($userInfo); } return $this; } public function updateAccessToken(Google\Client $client = null) { $apiClient = $this->getPlatform()->getApiClient(); $response = $apiClient->refreshGoogleAccessToken($this->getRefreshToken()); if (!$response->isSuccessful()) { Moto\System\Log::warning('[UserToken] : failed to update access token => ' . var_export($response, true)); return false; } $response = $response->getResponse(); if (!$this->fillFromApiResponse($response)) { Moto\System\Log::emergency('[UserToken] : Cant update token by api response' . (Moto\System::isDevelopmentStage() ? var_export($response, true) : '')); return false; } $this->save(); if ($client && $access = $this->getAccessToken()) { $client->setAccessToken([ 'access_token' => $access, 'expires_in' => $this->get('expires_in'), 'created' => $this->get('created'), ]); } return true; } } 