<?php
 namespace Moto\Service; use Exception; use Moto; use Zend; class AbstractService { protected $_request; protected $_resourceName = null; protected $_resourceNameAutoGenerate = false; protected $_resourcePrivilegesMap = array(); protected $_options = []; public function __construct($options = null) { if ($this->_resourceNameAutoGenerate && null === $this->_resourceName) { if (preg_match('/\\\([a-zA-Z0-9\_]+)\\\Service/', get_class($this), $match)) { $this->_resourceName = strtolower($match[1]); } } $this->_setOptions($options); $this->init(); } protected function _setOptions($options) { if (!is_array($options)) { return false; } $this->_options = $options; return true; } protected function _getOption($name, $default = null) { return Moto\Util::getValue($this->_options, $name, $default); } protected function _setOption($name, $value = null) { $this->_options[$name] = $value; } public function init() { } public function setRequest($request) { $this->_request = $request; } public function getRequest() { if (null === $this->_request) { $this->setRequest(new Zend\Json\Server\Request()); } return $this->_request; } public function getResourceName() { return $this->_resourceName; } public function getResourcePrivilege($privilege) { if (isset($this->_resourcePrivilegesMap[$privilege])) { $privilege = $this->_resourcePrivilegesMap[$privilege]; } return $privilege; } public function isAllowed($privilege) { $acl = Moto\Application\Acl\Adapter::getInstance(); $user = Moto\Authentication\Service::getUser(); $userRole = (null === $user ? 'guest' : strtolower($user->role_name)); return $acl->isAllowed($userRole, $this->_resourceName, $privilege); } public function decorateExceptionResponse(Exception $exception, $message, $code, $errors = []) { return null; } } 