<?php
namespace Moto\System; use Moto; use Composer; class AutoloadManager { protected static $_instance; protected $_loader = null; protected $_autoloadFiles = []; protected $_debug = false; public static function getInstance() { if (!static::$_instance) { static::$_instance = new static(); } return static::$_instance; } protected function __construct() { $this->init(); } protected function init() { $vendorPaths = Moto\System::getAbsolutePath('@phpLibrary/vendor/'); $includingFile = $vendorPaths . '/autoload.php'; if (!is_file($includingFile)) { throw new Moto\Exception('Required file "mt-includes/library/vendor/autoload.php" is missing'); } $loader = require $includingFile; if (!($loader instanceof Composer\Autoload\ClassLoader)) { throw new Moto\Exception('Cant retrieve Composer autoloader'); } $this->_loader = $loader; $includingFile = $vendorPaths . '/composer/autoload_files.php'; if (is_file($includingFile)) { $files = include $includingFile; if (is_array($files)) { foreach ($files as $name => $path) { $path = realpath($path); $path = Moto\Util::sanitizePath($path); $relativePath = Moto\Util::getRelativePath($path, $vendorPaths); $this->_autoloadFiles[$relativePath] = [ 'name' => $name, 'path' => $path, ]; } } } } protected function debug($message = null) { if ($message === null) { return $this->_debug; } if (!$this->_debug) { return true; } Moto\System\Log::debug($message); } public function getLoader() { if (!$this->_loader) { throw new Moto\Exception('Cant retrieve Composer autoloader'); } return $this->_loader; } protected function getLoaderProperty($loader, $property = null) { if (is_string($loader)) { $property = $loader; $loader = null; } if (!$loader) { $loader = $this->getLoader(); } $closure = \Closure::bind(function ($property) { return $this->{$property}; }, $loader, Composer\Autoload\ClassLoader::class); return $closure($property); } protected function setLoaderProperty($loader, $property, $value = null) { if (is_string($loader)) { $value = $property; $property = $loader; $loader = null; } if ($value === null) { return false; } if (!$loader) { $loader = $this->getLoader(); } $closure = \Closure::bind(function ($property, $value) { if (!property_exists($this, $property)) { return false; } $this->{$property} = $value; return true; }, $loader, Composer\Autoload\ClassLoader::class); return $closure($property, $value); } public function extendLoaderNamespacesPsr0($namespaces, $diff = true, $prepend = false) { $debug = $this->debug(); if (!is_array($namespaces)) { $debug && $this->debug(__FUNCTION__ . ' : "namespaces" is not array => return false'); return false; } if (count($namespaces) < 1) { $debug && $this->debug(__FUNCTION__ . ' : "namespaces" is empty => return true'); return true; } $loader = $this->getLoader(); $prefixes = $loader->getPrefixes(); if ($debug) { $this->debug(__FUNCTION__ . ' : namespaces was [' . count($prefixes) . '] ' . print_r(array_slice(array_keys($prefixes), 0, 10), true)); $this->debug(__FUNCTION__ . ' : namespaces income [' . count($namespaces) . '] ' . print_r(array_slice(array_keys($namespaces), 0, 10), true)); } if ($diff) { if ($debug) { $ignored = array_diff_key($namespaces, array_diff_key($namespaces, $prefixes)); $this->debug(__FUNCTION__ . ' : namespaces ignored [' . count($ignored) . '] ' . print_r(array_slice(array_keys($ignored), 0, 10), true)); } $namespaces = array_diff_key($namespaces, $prefixes); $debug && $this->debug(__FUNCTION__ . ' : namespaces diff [' . count($namespaces) . '] ' . print_r(array_slice(array_keys($namespaces), 0, 10), true)); } foreach ($namespaces as $namespace => $path) { $loader->add($namespace, $path, $prepend); } if ($debug) { $prefixes = $loader->getPrefixes(); $this->debug(__FUNCTION__ . ' : namespaces now [' . count($prefixes) . '] ' . print_r(array_slice(array_keys($prefixes), 0, 10), true) . "\n"); } return true; } public function extendLoaderPsr4($namespaces, $diff = true, $prepend = false) { $debug = $this->debug(); if (!is_array($namespaces)) { $debug && $this->debug(__FUNCTION__ . ' : "namespaces" is not array => return false'); return false; } if (count($namespaces) < 1) { $debug && $this->debug(__FUNCTION__ . ' : "namespaces" is empty => return true'); return true; } $loader = $this->getLoader(); $prefixes = $loader->getPrefixesPsr4(); if ($debug) { $this->debug(__FUNCTION__ . ' : namespaces was [' . count($prefixes) . '] ' . print_r(array_slice(array_keys($prefixes), 0, 10), true)); $this->debug(__FUNCTION__ . ' : namespaces income [' . count($namespaces) . '] ' . print_r(array_slice(array_keys($namespaces), 0, 10), true)); } if ($diff) { if ($debug) { $ignored = array_diff_key($namespaces, array_diff_key($namespaces, $prefixes)); $this->debug(__FUNCTION__ . ' : namespaces ignored [' . count($ignored) . '] ' . print_r(array_slice(array_keys($ignored), 0, 10), true)); } $namespaces = array_diff_key($namespaces, $prefixes); $debug && $this->debug(__FUNCTION__ . ' : namespaces diff [' . count($namespaces) . '] ' . print_r(array_slice(array_keys($namespaces), 0, 10), true)); } foreach ($namespaces as $namespace => $path) { $loader->addPsr4($namespace, $path, $prepend); } if ($debug) { $prefixes = $loader->getPrefixesPsr4(); $this->debug(__FUNCTION__ . ' : namespaces now [' . count($prefixes) . '] ' . print_r(array_slice(array_keys($prefixes), 0, 10), true) . "\n"); } return true; } public function extendLoaderClassMap($namespaces, $diff = true) { $debug = $this->debug(); if (!is_array($namespaces)) { $debug && $this->debug(__FUNCTION__ . ' : "classMap" is not array => return false'); return false; } if (count($namespaces) < 1) { $debug && $this->debug(__FUNCTION__ . ' : "classMap" is empty => return true'); return true; } $loader = $this->getLoader(); $prefixes = $loader->getClassMap(); if ($debug) { $this->debug(__FUNCTION__ . ' : namespaces was [' . count($prefixes) . '] ' . print_r(array_slice(array_keys($prefixes), 0, 10), true)); $this->debug(__FUNCTION__ . ' : namespaces income [' . count($namespaces) . '] ' . print_r(array_slice(array_keys($namespaces), 0, 10), true)); } if ($diff) { if ($debug) { $ignored = array_diff_key($namespaces, array_diff_key($namespaces, $prefixes)); $this->debug(__FUNCTION__ . ' : namespaces ignored [' . count($ignored) . '] ' . print_r(array_slice(array_keys($ignored), 0, 10), true)); } $namespaces = array_diff_key($namespaces, $prefixes); $debug && $this->debug(__FUNCTION__ . ' : namespaces diff [' . count($namespaces) . '] ' . print_r(array_slice(array_keys($namespaces), 0, 10), true)); } if (count($namespaces) !== 0) { $loader->addClassMap($namespaces); } if ($debug) { $prefixes = $loader->getClassMap(); $this->debug(__FUNCTION__ . ' : namespaces now [' . count($prefixes) . '] ' . print_r(array_slice(array_keys($prefixes), 0, 10), true) . "\n"); } return true; } public function extendLoaderAutoloadFiles($files, $vendorsPath) { $debug = $this->debug(); if (!is_string($vendorsPath)) { $debug && $this->debug(__FUNCTION__ . ' : "vendorsPath" is not string => return false'); return false; } $vendorsPath = trim($vendorsPath); $vendorsPath = realpath($vendorsPath); $vendorsPath = Moto\Util::sanitizePath($vendorsPath); if (!is_dir($vendorsPath)) { $debug && $this->debug(__FUNCTION__ . ' : "vendorsPath" [' . Moto\Util::getRelativePath($vendorsPath) . '] is not exists => return false'); return false; } if (!is_array($files)) { $debug && $this->debug(__FUNCTION__ . ' : "files" is not array => return false'); return false; } if (count($files) < 1) { $debug && $this->debug(__FUNCTION__ . ' : "files" is empty => return true'); return true; } $debug && $this->debug(__FUNCTION__ . ' : income "files" ' . count($files)); $added = 0; $ignored = 0; foreach ($files as $name => $absolutePath) { $absolutePath = realpath($absolutePath); $absolutePath = Moto\Util::sanitizePath($absolutePath); if ($this->includeAutoloadFile($absolutePath, $name, $vendorsPath)) { $added++; } elseif ($debug) { $relativePath = Moto\Util::getRelativePath($absolutePath, $vendorsPath); $this->debug("\tignore : $relativePath"); $ignored++; } } $debug && $this->debug(__FUNCTION__ . ' : included files added : ' . $added . ' ignored : ' . $ignored . "\n"); return true; } protected function includeAutoloadFile($absolutePath, $name, $vendorsPath) { $debug = $this->debug(); $relativePath = Moto\Util::getRelativePath($absolutePath, $vendorsPath); if (!is_file($absolutePath)) { $debug && $this->debug(__FUNCTION__ . ' : file "' . $relativePath . '" [' . $name . '] not exists => return false'); return false; } if (array_key_exists($relativePath, $this->_autoloadFiles)) { $debug && $this->debug(__FUNCTION__ . ' : file "' . $relativePath . '" [' . $name . '] already in "_autoloadFiles" => return false'); return false; } if (!empty($GLOBALS['__composer_autoload_files'][$name])) { $debug && $this->debug(__FUNCTION__ . ' : file "' . $relativePath . '" [' . $name . '] already in "__composer_autoload_files" => return false'); $this->_autoloadFiles[$relativePath] = [ 'name' => $name, 'path' => $absolutePath, ]; return false; } try { $debug && $this->debug(__FUNCTION__ . ' : including file "' . $relativePath . '" [' . $name . ']'); require_once $absolutePath; $GLOBALS['__composer_autoload_files'][$name] = true; $this->_autoloadFiles[$relativePath] = [ 'name' => $name, 'path' => $absolutePath, ]; } catch (\Exception $e) { $debug && $this->debug(__FUNCTION__ . ' : file "' . $relativePath . '" [' . $name . '] including failed'); throw new Moto\Exception('Cant include file "' . Moto\Util::getRelativePath($absolutePath) . '"', 500, [ 'name' => $name, 'file' => Moto\Util::getRelativePath($absolutePath), 'exception' => [ 'code' => $e->getCode(), 'message' => $e->getMessage(), ], ], $e); } return true; } public function safeExtendAutoload($vendorsPath) { if (!is_string($vendorsPath)) { return false; } if (is_dir($vendorsPath . '/composer')) { $this->debug(__FUNCTION__ . ' :: ' . __LINE__ . " $vendorsPath"); try { return $this->extendAutoload($vendorsPath); } catch (\Exception $e) { Moto\System\Log::error('[' . __CLASS__ . ':' . __FUNCTION__ . '] : Exception : [' . $e->getCode() . '] ' . $e->getMessage()); if ($e instanceof Moto\Exception) { Moto\System\Log::error(' => Errors : ', $e->getErrors()); } return false; } } $this->debug(__FUNCTION__ . ' :: ' . __LINE__ . " $vendorsPath"); return true; } public function extendAutoload($vendorsPath) { $this->debug(__CLASS__ . ':' . __FUNCTION__ . ' :: ' . __LINE__); $composerPath = $vendorsPath . '/composer'; if (!is_dir($composerPath)) { throw new Moto\Exception('Composer folder is not exists', 500, [ 'vendorsPath' => Moto\Util::getRelativePath($vendorsPath), ]); } $this->debug(__CLASS__ . ':' . __FUNCTION__ . ' :: ' . __LINE__); $errors = []; $includingFile = $composerPath . '/autoload_namespaces.php'; if (is_file($includingFile)) { $items = require $includingFile; if (is_array($items) && !$this->extendLoaderNamespacesPsr0($items)) { $errors[] = 'autoload_namespaces'; } } $includingFile = $composerPath . '/autoload_psr4.php'; if (is_file($includingFile)) { $items = require $includingFile; if (is_array($items) && !$this->extendLoaderPsr4($items)) { $errors[] = 'autoload_psr4'; } } $includingFile = $composerPath . '/autoload_classmap.php'; if (is_file($includingFile)) { $items = require $includingFile; if (is_array($items) && !$this->extendLoaderClassMap($items)) { $errors[] = 'autoload_classmap'; } } $includingFile = $composerPath . '/autoload_files.php'; if (is_file($includingFile)) { $items = require $includingFile; if (is_array($items) && !$this->extendLoaderAutoloadFiles($items, $vendorsPath)) { $errors[] = 'autoload_files'; } } if (count($errors) > 0) { throw new Moto\Exception('Failed extending autoload', 500, [ 'vendorsPath' => Moto\Util::getRelativePath($vendorsPath), 'errors' => $errors, ]); } return true; } } 