<?php
namespace Moto\System\Backup; use Moto; use Carbon\Carbon; class BackupFile extends Moto\System\Backup\AbstractModel { protected $_attributes = [ 'type' => 'full', ]; protected $_hidden = [ 'host', 'absolutePath', ]; protected $_visible = []; public static function createFromPath($path) { $absolutePath = Moto\System::getAbsolutePath($path); if (!file_exists($absolutePath)) { return null; } $attributes = Moto\System\Backup\Util::parseFileName($path); if (!$attributes) { return null; } $attributes['path'] = $path; $attributes['absolutePath'] = $absolutePath; $attributes['file_size'] = filesize($absolutePath); if (!$attributes['created']) { $attributes['created'] = Carbon::createFromTimestamp(filectime($absolutePath)); } return new static($attributes); } public function getEngineBuildAttribute($value) { return $this->mutateEngineBuildAttribute($value); } public function mutateEngineBuildAttribute($value) { return (int) $value; } public function mutateCreatedAttribute($value) { if ($value instanceof Carbon) { return $value->__toString(); } return $value; } public function delete() { return unlink($this->absolutePath); } } 