<?php
namespace Moto\System\Backup; use Moto; use Carbon\Carbon; class BackupItem extends Moto\System\Backup\AbstractModel { const STORAGE_TYPE__VIRTUAL = 'virtual'; const STORAGE_TYPE__DISK = 'disk'; const STORAGE_TYPE__ARCHIVE = 'archive'; protected $_attributes = [ 'uid' => null, 'type' => 'full', 'tempPath' => null, 'archivePath' => null, 'currentStorage' => 'virtual', 'storageType' => 'array', 'metaSteps' => null, 'flushing' => [ 'disk' => [ 'maxItems' => 0, 'maxTime' => 15, ], 'archive' => [ 'maxItems' => 400, 'maxTime' => 1, ], ], ]; protected $_hidden = []; protected $_visible = []; protected $_storages = []; public function loadVirtualStorage() { if ($this->isExistsStorageByType(static::STORAGE_TYPE__VIRTUAL)) { return false; } $storage = $this->getVirtualStorage(); if (!$storage) { return false; } return $storage->load(); } public function save() { return $this->saveVirtualStorage(); } protected function saveVirtualStorage() { $this->getVirtualStorage()->save(); } protected function createNewStorage($type) { $class = null; switch ($type) { case static::STORAGE_TYPE__VIRTUAL: $class = Moto\System\Backup\Storage\VirtualStorage::class; break; case static::STORAGE_TYPE__DISK: $class = Moto\System\Backup\Storage\DiskStorage::class; break; case static::STORAGE_TYPE__ARCHIVE: $class = Moto\System\Backup\Storage\ArchiveStorage::class; break; default: return null; } return new $class($this); } public function setTypeAttribute($value) { if (!is_string($value) || $this->_attributes['type']) { return false; } $value = trim($value); if ($value === '') { return false; } $this->_attributes['type'] = $value; return true; } public function setTempPathAttribute($value) { if (!is_string($value) || $this->_attributes['tempPath']) { return false; } $value = trim($value); if ($value === '') { return false; } $this->_attributes['tempPath'] = $value; return true; } public function setArchivePathAttribute($value) { if (!is_string($value) || $this->_attributes['archivePath']) { return false; } $value = trim($value); if ($value === '') { return false; } $this->_attributes['archivePath'] = $value; return true; } public function moveArchiveFile($destination) { $source = Moto\System::getAbsolutePath($this->archivePath); if (!file_exists($source)) { return false; } if ($source === Moto\System::getAbsolutePath($destination)) { return false; } Moto\System\Log::debug('[BackupItem] : moveArchiveFile "' . $source . '" to "' . Moto\System::getAbsolutePath($destination) . '"'); if (!Moto\Util::moveFile($source, Moto\System::getAbsolutePath($destination))) { return false; } $this->_attributes['archivePath'] = $destination; return true; } public function getAbsoluteTempPath() { if (!$this->tempPath) { throw new Moto\Exception('Temp path is empty'); } return Moto\System::getAbsolutePath($this->tempPath); } public function addEmptyDir($path, $mode = null) { return $this->getCurrentStorage()->addEmptyDir($path, $mode); } public function addFile($source, $destination = '') { return $this->getCurrentStorage()->addFile($source, $destination); } public function addFromString($destination, $content) { return $this->getCurrentStorage()->addFromString($destination, $content); } public function getCurrentStorage() { return $this->getStorageByType($this->getAttribute('currentStorage')); } protected function isExistsStorageByType($type) { return array_key_exists($type, $this->_storages); } protected function getStorageByType($type) { if (array_key_exists($type, $this->_storages)) { return $this->_storages[$type]; } $this->_storages[$type] = static::createNewStorage($type); return $this->_storages[$type]; } public function getDiskStorage() { return $this->getStorageByType(static::STORAGE_TYPE__DISK); } public function getVirtualStorage() { return $this->getStorageByType(static::STORAGE_TYPE__VIRTUAL); } public function attachDiskStorage() { $current = $this->getAttribute('currentStorage'); if ($current === static::STORAGE_TYPE__DISK) { return $this->getCurrentStorage(); } if ($current !== static::STORAGE_TYPE__VIRTUAL) { throw new Moto\Exception('Cant use disk storage by current is not "virtual"'); } $this->setAttribute('currentStorage', static::STORAGE_TYPE__DISK); return $this->getCurrentStorage(); } public function attachArchiveStorage() { $current = $this->getAttribute('currentStorage'); if ($current === static::STORAGE_TYPE__ARCHIVE) { return $this->getCurrentStorage(); } if ($current !== static::STORAGE_TYPE__DISK) { throw new Moto\Exception('Cant use disk storage by current is not "disk"'); } $this->setAttribute('currentStorage', static::STORAGE_TYPE__ARCHIVE); return $this->getCurrentStorage(); } public function flush() { $current = $this->getCurrentStorage(); if ($current instanceof Moto\System\Backup\Storage\DiskStorage) { $previous = $this->getStorageByType(static::STORAGE_TYPE__VIRTUAL); if ($previous->isFlushed()) { return true; } $flushing = $this->getAttribute('flushing'); $flushing = Moto\Util::getValue($flushing, 'disk', [ 'maxItems' => 0, 'maxTime' => 15, ]); return $current->addContentFromStorage($previous, $flushing); } if ($current instanceof Moto\System\Backup\Storage\ArchiveStorage) { $previous = $this->getStorageByType(static::STORAGE_TYPE__DISK); if ($previous->isFlushed()) { return true; } $flushing = $this->getAttribute('flushing'); $flushing = Moto\Util::getValue($flushing, 'archive', [ 'maxItems' => 400, 'maxTime' => 1, ]); return $current->addContentFromStorage($previous, $flushing); } return true; } public function setMetaStepsAttribute($value) { if ($this->_attributes['metaSteps'] !== null) { return false; } $this->_attributes['metaSteps'] = $value; return true; } public function registerStepMetaInformation(Moto\System\Backup\Step\AbstractStep $step) { $meta = $step->getBackupMetaInformation(); if (!is_array($meta) || empty($meta)) { return; } $meta = json_encode($meta); $meta = json_decode($meta, true); $this->_attributes['metaSteps'][$step->name] = $meta; } } 