<?php
namespace Moto\System\Backup; use Moto; use Carbon\Carbon; use Exception; class BackupTask extends Moto\System\Backup\AbstractModel { const STORAGE_FILE_NAME = '.task.json'; protected $_attributes = [ 'uid' => null, 'created_at' => null, 'updated_at' => null, 'type' => 'full', 'current' => null, 'next' => null, 'completed' => false, 'running' => false, 'failed' => false, 'errors' => null, 'steps' => null, 'tempDirPath' => null, ]; protected $_hidden = [ ]; protected $_visible = [ 'uid', 'created_at', 'updated_at', 'next', 'current', 'errors', 'steps', 'type', 'completed', 'failed', ]; protected $_stepsInstance = []; protected $_backup; public static function createNew($type) { $manager = BackupManager::getInstance(); $steps = $manager->generateStepList($type); $user = Moto\System::getUser(); $attributes = [ 'engine' => [ 'build' => Moto\Version::getCurrentBuild(), 'version' => Moto\Version::getCurrentVersion(), ], 'created_at' => Carbon::createFromTimestamp(time()), 'updated_at' => Carbon::createFromTimestamp(time()), 'steps' => $steps, ]; if ($user) { $attributes['created_by'] = Moto\Util::arrayOnly($user->toArray(), ['id', 'role_id', 'enabled']); } $uid = trim((string) $manager->getConfig('persistentUid')); if ($uid !== '') { $attributes['uid'] = $uid; } $task = new static($attributes); $task->setAttribute('next', 'init'); $tempPath = $manager->getConfig('tempPath'); if (empty($tempPath)) { throw new Moto\Exception('TempPath is empty'); } $tempDirPath = $tempPath . '/' . $task->uid; $task->setAttribute('tempDirPath', $tempDirPath); $archiveFilePath = $tempDirPath . '/.backup.zip'; $options = [ 'uid' => $task->uid, 'tempPath' => $tempDirPath, 'archivePath' => $archiveFilePath, ]; $flushing = $manager->getConfig('flushing'); if (is_array($flushing)) { $options['flushing'] = $flushing; } $backup = static::createBackupItem($options); $task->setAttribute('backup', $backup); $task->execute(); return $task; } protected static function createBackupItem(array $options = []) { $item = new Moto\System\Backup\BackupItem($options); $item->loadVirtualStorage(); return $item; } public function getTempDirPathAttribute($value = null) { if ($value === null) { $manager = BackupManager::getInstance(); $tempPath = $manager->getConfig('tempPath'); if (!empty($tempPath)) { $value = $tempPath . '/' . $this->uid; } } return $value; } public function getCreatedAtAttribute($value = null) { if (is_int($value)) { $value = Carbon::createFromTimestamp($value); } return $value; } public function getUpdatedAtAttribute($value = null) { if ($value === null) { $value = $this->created_at; } if (is_int($value)) { $value = Carbon::createFromTimestamp($value); } return $value; } public function getBackupAttribute($value = null) { if (is_array($this->_backup)) { $this->_backup = static::createBackupItem($this->_backup); } return $this->_backup; } public function setBackupAttribute($value) { if ($this->_backup) { return false; } if (is_array($value) || $value instanceof Moto\System\Backup\BackupItem) { $this->_backup = $value; return true; } return false; } public function getUidAttribute($value = null) { if (!$this->_attributes['uid']) { $user = Moto\System::getUser(); $uid = ''; if ($user) { $uid .= $user->id . '_'; } $microtime = (string) microtime(true); $microtime = str_replace('.', '', $microtime); $uid .= base_convert($microtime, 10, 32) . '_' . mt_rand(10000000, 99999999); $this->_attributes['uid'] = $uid; } return $this->_attributes['uid']; } protected function getStepByName($name) { $steps = $this->getAttribute('steps'); if (!array_key_exists($name, $steps)) { return null; } if (array_key_exists($name, $this->_stepsInstance)) { return $this->_stepsInstance[$name]; } $step = $steps[$name]; $class = Moto\Util::getValue($step, 'class'); $step = new $class($step); $this->_stepsInstance[$name] = $step; return $step; } protected function updateStepInformation($stepName, $properties, $value = null) { $steps = $this->getAttribute('steps'); if (is_array($properties)) { foreach ($properties as $property => $value) { $steps[$stepName][$property] = $value; } } else { $steps[$stepName][$properties] = $value; } return $this->setAttribute('steps', $steps); } protected function completeStepByName($name) { $currentStep = $this->getStepByName($name); if (!$currentStep) { return false; } $currentStep->completed = true; $currentStep->completed_at = time(); $this->updateStepInformation($currentStep->name, [ 'completed' => true, 'running' => false, ]); $this->setAttribute('current', $currentStep->name); $this->setAttribute('next', null); if ($currentStep->next) { $nextStep = $this->getStepByName($currentStep->next); $this->setAttribute('next', $nextStep->name); } else { $this->completed = true; } return $this; } public function mutateCreatedAtAttribute($value = null) { if ($value instanceof Carbon) { return (string) $value; } return date('Y-m-d H:i:s', $value); } public function mutateUpdatedAtAttribute($value = null) { if ($value === null) { $value = $this->created_at; } if ($value instanceof Carbon) { return (string) $value; } return date('Y-m-d H:i:s', $value); } public function mutateStepsAttribute($collection = null) { if ($collection instanceof Moto\System\BaseCollection) { $collection = $collection->all(); } if (!is_array($collection)) { return null; } $result = []; foreach ($collection as $item) { if ($item instanceof Moto\System\Backup\Step\AbstractStep) { $item = $item->toArray(); } if (is_object($item)) { $item = (array) $item; } if (is_array($item)) { $result[] = Moto\Util::arrayOnly($item, ['name', 'label', 'index', 'next', 'running', 'completed', 'failed', 'meta',]); } } return $result; } public function mutateNextAttribute($value) { $value = $this->getStepByName($value); if ($value instanceof Moto\System\Backup\Step\AbstractStep) { $value = $value->toArray(); } if (is_object($value)) { $value = (array) $value; } if (is_array($value)) { $value = Moto\Util::arrayOnly($value, ['name', 'label', 'index', 'next']); } return $value; } public function mutateCurrentAttribute($value) { $value = $this->getStepByName($value); if ($value instanceof Moto\System\Backup\Step\AbstractStep) { $value = $value->toArray(); } if (is_object($value)) { $value = (array) $value; } if (is_array($value)) { $value = Moto\Util::arrayOnly($value, ['name', 'label', 'next', 'executing', 'completed', 'failed', 'meta',]); } return $value; } public static function find($uid) { if (!static::isValidUid($uid)) { return null; } $filePath = static::_getFilePath($uid); if (!is_file($filePath)) { return null; } $content = file_get_contents($filePath); if (!$content) { return null; } $content = json_decode($content, true); if (!is_array($content)) { return null; } $payload = Moto\Util::getValue($content, 'payload'); $payload = Moto\System::decrypt($payload); $version = Moto\Util::getValue($payload, 'version'); $attributes = Moto\Util::getValue($payload, 'attributes'); if (!is_array($attributes)) { return null; } $backup = Moto\Util::getValue($payload, 'backup'); if (!is_array($backup)) { return null; } $attributes['backup'] = $backup; return new static($attributes); } protected function getPayload($raw = false) { $attributes = $this->_attributes; $payload = [ 'version' => 1, 'time' => time(), 'attributes' => $attributes, ]; if ($this->backup) { $payload['backup'] = $this->backup->toArray(); } if ($raw) { return $payload; } return Moto\System::encrypt($payload); } protected static function _getFilePath($uid) { $manager = Moto\System\Backup\BackupManager::getInstance(); $tempFolder = $manager->getConfig('tempPath'); $absolutePath = Moto\System::getAbsolutePath($tempFolder); return $absolutePath . '/' . $uid . '/' . static::STORAGE_FILE_NAME; } public function save() { if ($this->isReadOnly()) { throw new Moto\Exception('Blocked by readonly mode'); } $this->updated_at = Carbon::createFromTimestamp(time()); if ($this->completed) { return $this; } $filePath = static::_getFilePath($this->getAttribute('uid')); $content = [ 'meta' => $this->toArray(), 'payload' => $this->getPayload(), ]; $content = json_encode($content, JSON_PRETTY_PRINT); $this->backup->save(); if (!Moto\Util::filePutContents($filePath, $content)) { throw new Moto\Exception('Can not save'); } return $this; } public static function isValidUid($uid) { if (!is_string($uid)) { return false; } $uid = trim($uid); if ($uid === '') { return false; } return (boolean) preg_match('/^[a-z0-9\_\-]{3,64}$/', $uid); } protected function getFirstNotCompletedStep() { $steps = $this->getAttribute('steps'); foreach ($steps as $step) { if (!Moto\Util::getValue($step, 'completed')) { return $step; } } return null; } public function execute() { if ($this->running) { throw new Moto\Exception('Task already running'); } if ($this->isReadOnly()) { throw new Moto\Exception('Blocked by readonly mode'); } if ($this->completed) { throw new Moto\Exception('Task already completed'); } if ($this->failed) { throw new Moto\Exception('Cant execute by failed task'); } $step = $this->getStepByName($this->getAttribute('next')); if (!$step) { throw new Moto\Exception('Cant find next step'); } if ($step->completed) { throw new Moto\Exception('Step already completed'); } $this->setAttribute('current', $step->name); $this->running = true; $result = null; try { Moto\System\Log::debug('[BackupTask] : run step "' . $step->name . '"'); $this->updateStepInformation($step->name, 'running', true); $step->setPreviousResult($this->getAttribute('repeatData')); $this->unsetAttribute('repeatData'); $this->enableReadOnly(); $result = $step->execute($this->backup); $this->disableReadOnly(); if ($result instanceof Moto\System\Backup\BackupStepResult) { if ($result->isError()) { $this->addError($result->getError()); $this->failed = true; Moto\Website\MaintenanceMode::turnOff(); } elseif ($result->isNeedRepeat()) { $data = $result->getData(); $this->setAttribute('repeatData', $data); } elseif ($result->isCompleted()) { $this->backup->registerStepMetaInformation($step); $this->completeStepByName($step->name); } } else { throw new Moto\Exception('Invalid step result'); } } catch (Exception $e) { $this->disableReadOnly(); $this->failed = true; Moto\Website\MaintenanceMode::turnOff(); Moto\System\Log::debug('[BackupTask] : Exception "' . get_class($e) . '" [ ' . $e->getCode() . ' ] ' . $e->getMessage()); $this->addError([ 'type' => 'Exception', 'step' => $step->name, 'code' => $e->getCode(), 'message' => $e->getMessage(), ]); } $this->running = false; Moto\System\Log::debug('[BackupTask] : step done => ' . json_encode([ 'result' => [ 'type' => gettype($result), 'class' => is_object($result) ? get_class($result) : null, 'completed' => is_object($result) ? $result->isCompleted() : null, 'repeat' => is_object($result) ? $result->isNeedRepeat() : null, 'error' => is_object($result) ? $result->isError() : null, 'data' => is_object($result) ? gettype($result->getData()) : null, ], 'task' => [ 'failed' => $this->failed, 'completed' => $this->completed, ], 'step' => Moto\Util::arrayOnly($step->toArray(), ['name', 'label', 'executing']), ], JSON_PRETTY_PRINT)); return $this; } protected function addError($error) { $errors = (array) $this->getAttribute('errors'); $errors[] = $error; $this->setAttribute('errors', $errors); } public function delete() { $tempDirPath = $this->tempDirPath; $absoluteTempDirPath = Moto\System::getAbsolutePath($tempDirPath); if (!is_dir($absoluteTempDirPath) || !is_file($absoluteTempDirPath . '/' . static::STORAGE_FILE_NAME)) { return true; } $files = Moto\Util::scanDir($absoluteTempDirPath, '', [ 'maxLevel' => 0, 'addDir' => true, ]); foreach ($files as $file) { if ($file === static::STORAGE_FILE_NAME) { continue; } if (is_dir($absoluteTempDirPath . '/' . $file)) { Moto\Util::deleteDir($absoluteTempDirPath . '/' . $file); } else { @unlink($absoluteTempDirPath . '/' . $file); } } Moto\Util::deleteDir($absoluteTempDirPath); return true; } } 