<?php
namespace Moto\System\Backup\Step; use Moto; use Serializable; abstract class AbstractStep extends Moto\System\Backup\AbstractModel implements Serializable { const NAME = null; protected $_attributes = [ 'name' => null, 'label' => null, 'index' => null, 'next' => null, 'running' => false, 'executing' => null, 'completed' => false, 'failed' => false, 'completed_at' => null, 'meta' => [], ]; protected $_hidden = []; protected $_visible = [ 'name', 'label', 'completed', 'executing', 'meta', ]; protected $_previousData = null; public function setPreviousResult($data) { $this->_previousData = $data; } public function getPreviousResult($name = null, $default = null) { if ($name === null) { return $this->_previousData; } return Moto\Util::getValue($this->_previousData, $name, $default); } final protected function returnCompleted() { return new Moto\System\Backup\BackupStepResult([ 'completed' => true, 'needRepeat' => false, 'isError' => false, ]); } final protected function returnNeedRepeat($data) { return new Moto\System\Backup\BackupStepResult([ 'completed' => false, 'needRepeat' => true, 'isError' => false, 'data' => $data, ]); } final protected function returnError($error) { return new Moto\System\Backup\BackupStepResult([ 'completed' => false, 'needRepeat' => false, 'isError' => true, 'error' => $error, ]); } final public function serialize() { throw new Moto\Exception('Serializing is blocked'); } final public function unserialize($data) { throw new Moto\Exception('Serializing is blocked'); } public function mutateLabelAttribute($value = null) { if (!$value) { return strtoupper($this->name); } return $value; } public function getNameAttribute() { if (static::NAME) { return (string) static::NAME; } return $this->_attributes['name']; } final public function execute(Moto\System\Backup\BackupItem $backup) { $started = microtime(1); $memory = memory_get_peak_usage(); $result = null; try { $this->running = true; $result = $this->handle($backup); $this->running = false; } catch (\Exception $e) { $this->executing = [ 'time' => abs(microtime(1) - $started), 'memory_peak' => memory_get_peak_usage(), 'memory_peak_delta' => abs(memory_get_peak_usage() - $memory), ]; $this->failed = true; $this->running = false; throw $e; } $this->executing = [ 'time' => abs(microtime(1) - $started), 'memory_peak' => memory_get_peak_usage(), 'memory_peak_delta' => abs(memory_get_peak_usage() - $memory), ]; return $result; } public function getBackupMetaInformation() { return null; } public static function prepareStepAttributes($attributes, $plugins) { return $attributes; } abstract public function handle($backup); } 