<?php
namespace Moto\System\Backup\Step; use Moto; class CreateArchiveStep extends Moto\System\Backup\Step\AbstractStep { const NAME = 'archiving'; public function handle($backup) { $meta = (array) $this->getAttribute('meta'); $storage = $backup->getDiskStorage(); $runs = (int) $this->getPreviousResult('runs'); $runs++; $meta['runs'] = $runs; $this->setAttribute('meta', $meta); Moto\System\Log::debug("\tattach archive storage"); $backup->attachArchiveStorage(); if (!$this->isStorageFlushed($storage)) { Moto\System\Log::debug("\tattached => flushing [$runs]"); $backup->flush(); } $this->setAttribute('meta', $meta); if ($this->isStorageFlushed($storage)) { Moto\System\Log::debug("\tflushed"); return $this->returnCompleted(); } Moto\System\Log::debug("\tneed to repeat archiving"); return $this->returnNeedRepeat([ 'runs' => $runs, ]); } protected function isStorageFlushed($storage) { $flushed = $storage->isFlushed(); if ($flushed === null) { Moto\System\Log::error('isFlushed is NULL', [ 'storage' => get_class($storage) ]); throw new Moto\Exception('Cant detect is storage flushed'); } return $flushed; } } 