<?php
namespace Moto\System\Backup\Storage; use Moto; abstract class AbstractStorage { protected $_backup; protected $_content = [ 'queue' => [], ]; public function __construct(Moto\System\Backup\BackupItem $backup = null) { $this->_backup = $backup; $this->_init(); } protected function _init() { } final public function addEmptyDir($path, $mode = null) { if (!is_string($path)) { return false; } $path = trim($path); if ($path === '') { return false; } if (strpos($path, '../') !== false || strpos($path, '/..') !== false) { return false; } if ($path[0] === '@') { $path = Moto\System::getRelativePath($path); } return $this->_addEmptyDir($path, $mode); } final public function addFile($source, $destination = '') { if (!is_string($source) || !is_string($destination)) { return false; } $source = trim($source); $destination = trim($destination); if ($source === '') { return false; } if ($destination !== '' && (strpos($destination, '../') !== false || strpos($destination, '/..') !== false)) { return false; } return $this->_addFile($source, $destination); } final public function addFromString($destination, $content = '') { if (!is_string($destination) || !is_string($content)) { return false; } $destination = trim($destination); if ($destination !== '' && (strpos($destination, '../') !== false || strpos($destination, '/..') !== false)) { return false; } return $this->_addFromString($destination, $content); } public function save() { return true; } public function load() { return true; } public function importData($content) { if (!is_array($content)) { return false; } $this->_content = $content; return true; } public function exportData() { return $this->_content; } protected function resolveRelativePath($path) { if ($path[0] === '@') { $path = Moto\System::getRelativePath($path); } return $path; } public function deleteName($name) { if (!is_string($name)) { return false; } $name = trim($name); if ($name === '') { return false; } if ($name[0] === '/' || strpos($name, '../') !== false || strpos($name, '/..') !== false) { return false; } return $this->_deleteName($name); } public function isFlushed() { return false; } public function addContentFromStorage(Moto\System\Backup\Storage\AbstractStorage $storage, array $options = []) { return true; } public function hasName($name) { return null; } abstract protected function _addEmptyDir($path, $mode = null); abstract protected function _addFile($source, $destination); abstract protected function _addFromString($destination, $content = ''); abstract protected function _deleteName($name); } 