<?php
namespace Moto\System\Backup\Storage; use Moto; use RecursiveDirectoryIterator; use RecursiveIteratorIterator; use FilesystemIterator; use RecursiveCallbackFilterIterator; class DiskStorage extends AbstractStorage { protected $_tempPath; protected $_basePath; protected $_websitePath; protected function _init() { parent::_init(); $this->_tempPath = $this->_backup->getAbsoluteTempPath(); $this->_basePath = $this->_tempPath . '/backup'; $this->_websitePath = Moto\System::getAbsolutePath('@website'); } public function getTempPath() { return $this->_tempPath; } public function getBasePath() { return $this->_basePath; } protected function _addEmptyDir($path, $mode = null) { if ($path[0] === '@') { $path = Moto\System::getRelativePath($path); } return Moto\Util::createDir($this->getBasePath() . '/' . $path, $mode); } protected function resolveDestinationPath($path) { return $this->getBasePath() . '/' . $this->resolveRelativePath($path); } protected function _addFile($path, $destination = '') { if ($path[0] === '@') { $source = Moto\System::getAbsolutePath($path); } else { $source = $this->_websitePath . '/' . $path; } if ($destination === '') { $destination = $path; } $destination = $this->resolveDestinationPath($destination); return Moto\Util::copyFile($source, $destination); } protected function _addFromString($destination, $content = '') { $destination = $this->resolveDestinationPath($destination); return (boolean) Moto\Util::filePutContents($destination, $content); } public function getQueue() { return $this->createDirectoryIterator(); } public function createDirectoryIterator() { $path = $this->getBasePath(); if (!is_dir($path)) { return null; } $flags = FilesystemIterator::SKIP_DOTS | FilesystemIterator::CURRENT_AS_SELF | FilesystemIterator::UNIX_PATHS; $directoryIterator = new RecursiveDirectoryIterator($path, $flags); $recursiveIterator = new RecursiveIteratorIterator($directoryIterator, RecursiveIteratorIterator::SELF_FIRST); return $recursiveIterator; } public function addContentFromStorage(Moto\System\Backup\Storage\AbstractStorage $storage, array $options = []) { $maxItems = (int) Moto\Util::getValue($options, 'maxItems'); if ($maxItems < 0) { throw new Moto\Exception('Bad options "maxItems" value'); } $maxTime = (int) Moto\Util::getValue($options, 'maxTime'); if ($maxTime < 0) { throw new Moto\Exception('Bad options "maxTime" value'); } $passedItems = 0; $passedTime = null; $startedAt = microtime(true); $queue = $storage->getQueue(); if ($queue->count() < 1) { Moto\System\Log::debug('[' . __CLASS__ . '::' . __FUNCTION__ . '] : nothing to flushing', [ 'queueCount' => $queue->count(), ]); return true; } Moto\System\Log::debug('[' . __CLASS__ . '::' . __FUNCTION__ . '] : start flushing', [ 'items' => $queue->count(), 'maxItems' => $maxItems, 'maxTime' => $maxTime, ]); foreach ($queue as $index => $item) { $passedItems++; if ($item['type'] === 'dir') { $this->_addEmptyDir($item['source']); } elseif ($item['type'] === 'file') { $this->_addFile($item['source'], $item['dest']); } elseif ($item['type'] === 'string') { $this->addFromString($item['dest'], $item['source']); } $queue->offsetUnset($index); if ($maxItems > 0 && $passedItems >= $maxItems) { Moto\System\Log::debug('[' . __CLASS__ . '::' . __FUNCTION__ . '] : break flushing by maxItems', [ 'passedItems' => $passedItems, 'maxItems' => $maxItems, ]); break; } $passedTime = microtime(true) - $startedAt; if ($maxTime > 0 && $passedTime >= $maxTime) { Moto\System\Log::debug('[' . __CLASS__ . '::' . __FUNCTION__ . '] : break flushing by maxTime', [ 'passedTime' => $passedTime, 'maxTime' => $maxTime, ]); break; } } Moto\System\Log::debug('[' . __CLASS__ . '::' . __FUNCTION__ . '] : flushing report', [ 'passedTime' => $passedTime, 'passedItems' => $passedItems, ]); return true; } public function hasName($name) { if (!is_string($name)) { return null; } $name = trim($name); if ($name === '') { return null; } return file_exists($this->resolveDestinationPath($name)); } public function _deleteName($name) { $path = $this->resolveDestinationPath($name); if (!file_exists($path)) { return false; } if (is_dir($path)) { return Moto\Util::deleteDir($path); } return unlink($path); } public function dropQueue() { return Moto\Util::deleteDir($this->getBasePath()); } public function getItemsCount($name) { $count = 0; $path = $this->resolveDestinationPath($name); if (!file_exists($path)) { return $count; } if (!is_dir($path)) { return false; } $handle = opendir($path); if (!$handle) { return false; } while (false !== ($file = readdir($handle))) { if ($file === '.' || $file === '..') { continue; } $count++; } closedir($handle); return $count; } public function isEmptyDir($name) { $path = $this->resolveDestinationPath($name); if (!file_exists($path)) { return true; } if (!is_dir($path)) { return null; } $handle = opendir($path); if (!$handle) { return null; } $result = null; while (false !== ($file = readdir($handle))) { if ($file === '.' || $file === '..') { $result = true; continue; } $result = false; break; } closedir($handle); return $result; } public function isFlushed() { return $this->isEmptyDir('.'); } }