<?php
namespace Moto\System\Backup\Storage; use Moto; use Illuminate; class VirtualStorage extends AbstractStorage { protected $_queue; protected function getStorageFilePath() { return $this->_backup->getAbsoluteTempPath() . '/.virtual.json'; } public function load() { $filePath = $this->getStorageFilePath(); if (file_exists($filePath)) { $content = file_get_contents($filePath); $content = json_decode($content, true); $queue = $this->getQueue(); foreach($content['queue'] as $item) { $index = $item['dest']; if ($index === '') { $index = $item['source']; } $queue->offsetSet($index, $item); } } return true; } public function save() { $filePath = $this->getStorageFilePath(); $content = $this->exportData(); $queue = $this->getQueue(); $content['queue'] = array_values($queue->all()); $content = json_encode($content, JSON_PRETTY_PRINT); return Moto\Util::filePutContents($filePath, $content); } public function getQueue() { if (!$this->_queue) { $this->_queue = new Illuminate\Support\Collection($this->_content['queue']); } return $this->_queue; } public function dropQueue() { $this->_content['queue'] = []; $this->_queue = null; } public function isFlushed() { return $this->getQueue()->isEmpty(); } protected function _addItem($type, $source, $destination = '') { $source = $this->resolveRelativePath($source); $index = $source; if ($destination !== '') { $destination = $this->resolveRelativePath($destination); $index = $destination; } if ($source === $destination) { $destination = ''; } $this->getQueue()->offsetSet($index, [ 'type' => $type, 'source' => $source, 'dest' => $destination, ]); return true; } protected function _addEmptyDir($path, $mode = null) { return $this->_addItem('dir', rtrim($path, '/') . '/'); } protected function _addFile($source, $destination) { return $this->_addItem('file', $source, $destination); } protected function _addFromString($destination, $content = '') { return $this->_addItem('string', $content, $destination); } public function hasName($name) { $relativePath = $this->resolveRelativePath($name); if ($this->getQueue()->offsetExists($relativePath)) { return true; } $relativePath = rtrim($relativePath, '/') . '/'; return $this->getQueue()->offsetExists($relativePath); } public function _deleteName($name) { $this->getQueue()->offsetUnset($this->resolveRelativePath($name)); return true; } public function getDump() { return $this->_content; } } 