<?php
namespace Moto\System\Backup; use Moto; use Carbon\Carbon; class Util { public static function parseFileName($fileName) { if (!is_string($fileName)) { return null; } $fileName = trim($fileName); $match = []; $fileName = basename($fileName); if (!preg_match('/^((?<host>[a-z0-9\.\-]+)_)?mt-backup_(?<type>[a-z0-9\-]+)_(?<build>[0-9]+)_(?<version>.*)__(?<hash>.*)\.(zip)$/', $fileName, $match)) { return null; } $info = [ 'name' => $fileName, 'type' => $match['type'], 'host' => $match['host'], 'engine_build' => $match['build'], 'engine_version' => $match['version'], 'created' => static::getDateFromHash($match['hash']), ]; return $info; } public static function getDateFromHash($hash) { try { if (preg_match('/^(?<created>[0-9]{14})-(?<hash>.*)$/', $hash, $match)) { return Carbon::createFromFormat('YmdHis', $match['created']); } elseif (preg_match('/^(?<created>[a-z0-9]+)-(?<hash>.*)$/', $hash, $match)) { return Carbon::createFromTimestamp((int) base_convert($match['created'], 36, 10)); } } catch (\Exception $e) { Moto\System\Log::debug(__CLASS__ . '::' . __FUNCTION__ . ' : Catch Exception : ' . $e->getMessage()); } return null; } } 