<?php
 namespace Moto\System\Cache; use Illuminate; use Moto; class CacheManager extends Illuminate\Cache\CacheManager { protected $settings; protected function getSettings() { if ($this->settings) { return $this->settings; } $this->settings = []; $settings = Moto\Website\Settings::get('cache_settings'); if (is_array($settings)) { $this->settings = $settings; } return $this->settings; } protected function getRepositoryOptions($namespace) { return Moto\Util::getValue($this->getSettings(), $namespace); } protected function createStringFileDriver(array $config) { $store = new Moto\System\Cache\FileStoreString($this->app['files'], $config['path']); return $this->createRepository($store, Moto\Util::getValue($config, 'repository')); } protected function createRepository($store, $name = null) { if (empty($name)) { return $this->repository($store); } if (!is_string($name)) { throw new \InvalidArgumentException('Repository name not a string'); } $name = trim($name); $method = 'create' . Moto\Util::toStudlyCase($name) . 'Repository'; if ($method === __FUNCTION__ || !method_exists($this, $method)) { throw new \InvalidArgumentException('Repository name not valid'); } $repository = $this->{$method}($store); $this->setEventDispatcher($repository); $options = $this->getRepositoryOptions($name); if (Moto\System::isDevelopmentStage() && !is_array($options)) { Moto\System\Log::error('[' . __METHOD__ . '] : options empty for repository ' . var_export($name, true)); } if (method_exists($repository, 'setOptions') && is_array($options)) { $repository->setOptions($options); } return $repository; } protected function createWebsitePageRepository($store) { return new Moto\System\Cache\WebsitePageRepository($store); } } 