<?php
 namespace Moto\System\Cache\Tasks\WebsitePage; use Illuminate\Support\Collection; use Moto; use Moto\System\AttributesBag; class GenerateCache extends Moto\System\Task\AbstractTask { const MAX_ATTEMPTS_PER_PAGE = 2; use Moto\System\Traits\OptionsTrait; protected $_options = [ 'maxItems' => 25, 'maxTime' => 10, ]; public function __construct(array $options = [], Moto\System\Task\Database\JobTaskState $state = null) { $this->setOptions($options); if (!$state) { return; } $this->setStateModel($state); } protected function log($message, $extra = []) { if (!Moto\Config::get('dev.task:GenerateCache.verbose')) { return; } echo $message . "\n"; } protected function error($message, $extra = []) { $this->log('<b>ERROR:</b> : ' . $message, $extra); } protected function localStorage() { $storage = parent::localStorage(); if ($storage->has('pages')) { return $storage; } $pages = new Collection($this->getOption('pages')); $storage->put('pages', $pages); $storage->put('current', null); $storage->put('passed', new Collection()); $storage->put('failed', new Collection()); $storage->put('working', 0); $storage->put('progress', new AttributesBag([ 'total' => $pages->count(), 'passed' => 0, 'remained' => $pages->count(), 'failed' => 0, ])); return $storage; } public function getProgress() { return $this->localStorage()->get('progress'); } public function executing() { $storage = $this->localStorage(); $this->log('Global storage : ' . get_class($this->getStateModel()->storage)); $this->log('Local storage : ' . get_class($storage)); if (!($storage['pages'] instanceof Collection)) { $this->error("ERROR : Pages is not Collection"); throw new Moto\Exception('Pages is not Collection'); } if (count($storage['pages']) < 1) { $this->log("No pages for generate caching"); return true; } if ($storage['current']) { $this->log('Detect previous current : ' . json_encode($storage['current'], JSON_PRETTY_PRINT)); if ($storage['current']['attempts'] < static::MAX_ATTEMPTS_PER_PAGE) { $this->log("Try current page => prepend to pages"); $storage['pages']->prepend($storage['current']['id']); } else { $this->log("Current page cant rendering => move to failed"); $storage['failed']->push($storage['current']['id']); $storage['current'] = null; $this->save(); } } if ($this->attempts() > 2 && ($storage['passed']->count() + $storage['failed']->count()) < 1) { } $count = 0; $startAt = microtime(true); $maxItems = $this->getOption('maxItems'); $maxTime = (int) $this->getOption('maxTime'); $current = $storage['current']; while (count($storage['pages'])) { $workingTime = (microtime(true) - $startAt); if ($maxTime > 0 && $workingTime >= $maxTime) { $this->log("\tMAX Time $workingTime => break"); break; } if ($maxItems > 0 && $count >= $maxItems) { $this->log("\tMAX $count => break"); break; } $count++; $id = $storage['pages']->shift(); if (!$current) { $current = new AttributesBag([ 'id' => $id, 'attempts' => 0, ]); } $current->increment('attempts'); $storage['current'] = $current; $storage->save(); $this->log("\t$count generateForPage($id)"); $time = microtime(true); try { $this->generateForPage($id); } catch (\Exception $e) { $storage['failed']->push($id); $this->getStateModel()->errors->push([ 'uuid' => $this->getUuid(), 'queue' => $this->getQueue(), 'name' => $this->getName(), 'type' => 'Exception', 'error' => [ 'class' => get_class($e), 'code' => $e->getCode(), 'message' => $e->getMessage(), ], ]); Moto\System\Log::warning('Cant generate cache for page => ' . var_export([ 'page_id' => $id, 'exception' => [ 'code' => $e->getCode(), 'message' => $e->getMessage(), 'trace' => Moto\System::isDevelopmentStage() ? $e->getTraceAsString() : null, ], ], true)); } $storage->put('working', $storage->get('working') + (microtime(true) - $time)); $storage['passed']->push($storage['current']['id']); $storage['progress']['remained'] = $storage['pages']->count(); $storage['progress']['passed'] = $storage['passed']->count(); $storage['progress']['failed'] = $storage['failed']->count(); $storage['current'] = null; $current = null; $storage->save(); } if (count($storage['pages'])) { $this->log("Need repeat task for pages : " . implode(', ', $storage['pages']->all())); $this->log("Passed pages : " . implode(', ', $storage['passed']->all())); return $this->returnNeedRepeat(); } return $this->returnCompleted(); } protected function getWebsitePageRepository() { return Moto\System::app('cache.website_page'); } protected function generateForPage($id) { if (Moto\Config::get('dev.task:GenerateCache.dry')) { return true; } $page = Moto\Application\Pages\Service::getById((int) $id); $cache = $this->getWebsitePageRepository(); if (!$cache->isCacheable($page)) { return false; } Moto\System\Request::setRequestUrl($page->getRelativeUrl()); $contentPage = new Moto\Website\ContentPage($page); $contentPage->getRenderedWebsiteContent(true); Moto\System\Request::setRequestUrl(''); } } 