<?php
 namespace Moto\System\Cache; use Illuminate\Contracts\Cache\Store; use Moto; use Illuminate; class WebsitePageRepository extends Moto\System\Cache\Repository { use Moto\System\Traits\OptionsTrait; protected $_options = [ 'enabled' => false, 'exclude' => [], 'ttl' => '+1day', 'duration' => 86400, ]; protected function getSeconds($duration) { if (!$this->isEnabled()) { return null; } return $this->getOption('duration'); } protected function getMinutes($duration) { if (!$this->isEnabled()) { return null; } return (int) ($this->getSeconds($duration) / 60); } public function isCompatible($target) { if ($target instanceof Moto\Application\Pages\PageModel) { return true; } if ($target instanceof Moto\Website\ContentPage) { return true; } return false; } public function isCacheable($target, $debug = false) { if ($debug) echo "\nisCacheable : target is " . gettype($target) . ' ' . (is_object($target) ? get_class($target) . " [# {$target->id}] " : '') . "\n"; if (!$this->isEnabled()) { if ($debug) echo "Not Enabled\n"; return false; } if (!$this->isCompatible($target)) { if ($debug) echo "Not Compatible class : " . get_class($target) . "\n"; return false; } $collection = new Illuminate\Support\Collection([$target]); $collection = $this->applyBaseFilter($collection); $isCacheable = (boolean) $collection->count(); if (!$isCacheable) { if ($debug) echo 'Cacheable by base filter? : ' . var_export($isCacheable, true) . "\n"; return false; } if ($target->isPublicationDateInFuture()) { if ($debug) echo "Is has 'isPublicationDateInFuture'\n"; return false; } if ($debug) echo "Cacheable\n"; return true; } protected function applyBaseFilter($queryOrCollection) { foreach ([ 'is_system' => false, 'type' => 'page', 'status' => Moto\Database\Models\Page::STATUS__PUBLISH, ] as $name => $value) { $queryOrCollection = $queryOrCollection->where($name, $value); } $queryOrCollection = $queryOrCollection->whereNotIn('id', (array) $this->getOption('exclude')); return $queryOrCollection; } public function getCachableItems($columns = ['*']) { $query = Moto\Database\Models\Page::query(); $query = $this->applyBaseFilter($query); return $query->get((array) $columns); } protected function isExcluded($id) { return in_array((int) $id, (array) $this->getOption('exclude'), true); } public function getKey($target) { if (!$this->isCompatible($target)) { return null; } $value = $target->id . '#' . $target->getAbsoluteUrl(); $value = sha1($value); return $value; } } 