<?php
 namespace Moto\System\ContentSection\Validator; use Moto; use Moto\Validator\AbstractValidator; class CreateTaxonomyUniqueProperty extends AbstractValidator { const INVALID_OPTIONS = 'invalidOption'; const PROPERTY_VALUE_NOT_UNIQUE = 'notUnique'; protected $messageTemplates = [ self::INVALID_OPTIONS => 'Bad action', self::PROPERTY_VALUE_NOT_UNIQUE => 'Property "%property%" value is not unique', ]; protected $messageVariables = [ 'property' => '_property', ]; protected $_property; public function isValid($value, array $context = array()) { $provider = $this->getOption('provider'); if (!$provider instanceof Moto\System\ContentSection\ContentProvider) { $this->error(self::INVALID_OPTIONS); return false; } $property = $this->getOption('property'); if (is_string($property)) { $property = trim($property); $this->_property = $property; } if (empty($property)) { $this->error(self::INVALID_OPTIONS); return false; } $definitions = $provider->getTaxonomyDefinitions(); foreach ($definitions as $definition) { if (Moto\Util::getValue($definition, $property) === $value) { $this->error(self::PROPERTY_VALUE_NOT_UNIQUE); return false; } } return true; } } 