<?php
 namespace Moto\System; use Moto; use Moto\System\ContentSection\TaxonomyDefinition; use Zend; abstract class ContentSectionHelper { protected static $_cache = array(); protected $_type; protected $_provider; protected $_sitemap = []; protected $_options = array( 'logging' => true, 'sitemapLabelTemplate' => 'MODULE.{{SECTION}}.SITEMAP.{{TYPE}}_LABEL', ); protected $_defaultSettings = array( 'build' => 1, 'enabled' => true, 'show_comments' => true, 'comments_language' => 'en', 'date_format' => 'd.m.Y', 'definitions' => [ 'index' => [ 'template' => null, ], 'post' => [ 'template' => null, ], ], 'taxonomies' => [ 'tag' => [ 'classification' => 'taxonomy', 'name' => 'tag', 'nameInPlural' => 'tags', 'isSystem' => true, 'type' => 'many', 'template' => null, 'uri' => 'tag', 'texts' => [ 'name' => 'Tag', 'pluralName' => 'Tags', ], ], 'category' => [ 'classification' => 'taxonomy', 'name' => 'category', 'nameInPlural' => 'categories', 'isSystem' => true, 'type' => 'one', 'template' => null, 'uri' => 'category', 'texts' => [ 'name' => 'Category', 'pluralName' => 'Categories', ], ], ], ); protected $_mainPage; protected $_defaultMainPageData = array( 'name' => '', 'url' => '@@SECTION_NAME@@', 'type' => '@@SECTION_NAME@@.index', 'parent_id' => 0, 'status' => Moto\Application\Pages\PageModel::STATUS_PUBLISH, 'visibility' => Moto\Application\Pages\PageModel::VISIBILITY_PUBLIC, 'is_system' => true, 'content' => '
<div class="moto-widget moto-widget-row row-fixed" data-widget="row">
    <div class="container-fluid">
        <div class="row">
            <div class="moto-cell col-sm-9" data-container="container">
                {{ widget("@@SECTION_NAME@@.post_list", {"spacing":{"top":"auto","right":"auto","bottom":"auto","left":"auto"},"item_count":3,"read_more_label":"Read More","preset":"default"}) }}
            </div>
            <div class="moto-cell col-sm-3" data-container="container">
                {{ widget("@@SECTION_NAME@@.recent_posts", {"spacing":{"top":"auto","right":"auto","bottom":"auto","left":"auto"},"item_count":5,"label":"Recent Posts","preset":"default"}) }}
            </div>
        </div>
    </div>
</div>
'); protected $_postTemplate; protected $_templates = []; protected $_defaultPostTemplateData = array( 'name' => 'Post Template', 'url' => 'moto-template-@@SECTION_NAME@@-post', 'type' => 'template.@@SECTION_NAME@@.post', 'parent_id' => 0, 'status' => Moto\Application\Pages\PageModel::STATUS_PUBLISH, 'visibility' => Moto\Application\Pages\PageModel::VISIBILITY_PUBLIC, 'is_system' => true, 'content' => '
<div class="moto-widget moto-widget-row row-fixed" data-widget="row">
    <div class="container-fluid">
        <div class="row">
            <div class="moto-cell col-sm-9" data-container="container">
                {{ widget("@@SECTION_NAME@@.post_name", {"spacing":{"top":"small","right":"auto","bottom":"small","left":"auto"},"preset":"default","text_style":"moto-text_system_7"}) }}
				<div class="moto-widget moto-widget-row" data-widget="row">
					<div class="container-fluid">
						<div class="row">
							<div class="moto-cell col-sm-2" data-container="container">
								{{ widget("@@SECTION_NAME@@.post_published_on", {"spacing":{"top":"auto","right":"auto","bottom":"small","left":"auto"},"preset":"default","font_style":"moto-text_normal"}) }}
							</div>
							<div class="moto-cell col-sm-2" data-container="container">
								{{ widget("@@SECTION_NAME@@.post_author", {"spacing":{"top":"auto","right":"auto","bottom":"small","left":"auto"},"preset":"default","font_style":"moto-text_normal"}) }}
							</div>
							<div class="moto-cell col-sm-8" data-container="container">
								{{ widget("@@SECTION_NAME@@.post_category", {"section":"@@SECTION_NAME@@","taxonomy":{"type":"one","name":"category"},"spacing":{"top":"auto","right":"auto","bottom":"small","left":"auto"},"preset":"default","font_style":"moto-text_normal"}) }}
							</div>
						</div>
					</div>
				</div>
				{{ widget("@@SECTION_NAME@@.post_content", {"spacing":{"top":"auto","right":"auto","bottom":"small","left":"auto"}}) }}
				{{ widget("@@SECTION_NAME@@.post_tags", {"section":"@@SECTION_NAME@@","taxonomy":{"type":"many","name":"tag"},"title":"Tags:","titleTextStyle":"moto-text_normal","spacing":{"top":"auto","right":"auto","bottom":"small","left":"auto"}}) }}
				{{ widget("@@SECTION_NAME@@.post_comments", {"spacing":{"top":"small","right":"auto","bottom":"small","left":"auto"}}) }}
			</div>
			<div class="moto-cell col-sm-3" data-container="container">
                {{ widget("@@SECTION_NAME@@.recent_posts", {"spacing":{"top":"auto","right":"auto","bottom":"auto","left":"auto"},"item_count":5,"label":"Recent Posts","preset":"default"}) }}
            </div>
        </div>
    </div>
</div>
'); protected $_defaultPostContent = array( 'name' => 'My first post', 'url' => '', 'type' => '@@SECTION_NAME@@.post', 'status' => Moto\Application\Pages\PageModel::STATUS_PUBLISH, 'visibility' => Moto\Application\Pages\PageModel::VISIBILITY_PUBLIC, 'short_description' => '<p class="moto-text_system_10">This is a short description for your post. You can easily change it under post properties using "Edit Short Description" button.</p>', 'content' => '
<div class="moto-widget moto-widget-row" data-widget="row">
    <div class="container-fluid">
        <div class="row">
            <div class="moto-cell col-sm-12" data-container="container">
                <div class="moto-widget moto-widget-text moto-preset-default moto-spacing-top-auto moto-spacing-right-auto moto-spacing-bottom-auto moto-spacing-left-auto" data-widget="text" data-preset="default" data-spacing="aaaa">
                    <div class="moto-widget-text-content moto-widget-text-editable"><p class="moto-text_system_10">This is a post content. Click here for editing</p></div>
                </div>
            </div>
        </div>
    </div>
</div>' ); protected $_defaultTaxonomyTemplateData = array( 'url' => 'moto-template-@@SECTION_NAME@@-@@TAXONOMY_NAME@@', 'parent_id' => 0, 'status' => Moto\Application\Pages\PageModel::STATUS_PUBLISH, 'visibility' => Moto\Application\Pages\PageModel::VISIBILITY_PUBLIC, 'is_system' => true, 'content' => '
<div class="moto-widget moto-widget-row moto-spacing-top-auto moto-spacing-right-auto moto-spacing-bottom-auto moto-spacing-left-auto row-fixed" data-grid-type="sm" data-widget="row" data-spacing="aaaa" style="" data-bg-position="left top">
    <div class="container-fluid">
        <div class="row" data-container="container">
            <div class="moto-widget moto-widget-row__column moto-cell col-sm-12 moto-spacing-top-auto moto-spacing-right-auto moto-spacing-bottom-auto moto-spacing-left-auto" style="" data-widget="row.column" data-container="container" data-spacing="aaaa" data-bg-position="left top">
                {{ widget( {"name":"@@SECTION_NAME@@.@@TAXONOMY_WIDGET_PREFIX@@_name","properties":{"section":"@@SECTION_NAME@@","taxonomy":{"type":"@@TAXONOMY_TYPE@@","name":"@@TAXONOMY_NAME@@"},"htmlTag":"h1","text_style":"moto-text_system_7","visible_on":"mobile-v","spacing":{"top":"small","right":"auto","bottom":"small","left":"auto"},"align":{"desktop":"left","tablet":"","mobile-v":"","mobile-h":""}}} ) }}
                {{ widget( {"name":"@@SECTION_NAME@@.@@TAXONOMY_WIDGET_PREFIX@@_description","properties":{"section":"@@SECTION_NAME@@","taxonomy":{"type":"@@TAXONOMY_TYPE@@","name":"@@TAXONOMY_NAME@@"},"source":"short_description","firstPageOnly":false,"visible_on":"mobile-v","spacing":{"top":"small","right":"auto","bottom":"small","left":"auto"}}} ) }}
                {{ widget( {"name":"@@SECTION_NAME@@.post_list","properties":{"spacing":{"top":"auto","right":"auto","bottom":"auto","left":"auto"},"item_count":5,"read_more_label":"Read More","style":{"title":{"font_style":"moto-text_system_7"},"meta":{"font_style":"moto-text_system_11"},"button":{"preset":"5","size":"small"},"feature_image":{"preset":"default"},"divider":{"preset":"default"}},"version":1}} ) }}
                {{ widget( {"name":"@@SECTION_NAME@@.@@TAXONOMY_WIDGET_PREFIX@@_description","properties":{"section":"@@SECTION_NAME@@","taxonomy":{"type":"@@TAXONOMY_TYPE@@","name":"@@TAXONOMY_NAME@@"},"source":"long_description","firstPageOnly":false,"visible_on":"mobile-v","spacing":{"top":"small","right":"auto","bottom":"small","left":"auto"}}} ) }}
            </div>
        </div>
    </div>
</div>
'); protected $_futureTemplate; protected $_defaultPostInFutureData = [ 'name' => 'Post in Future', 'url' => '@@SECTION_NAME@@-post-in-future', 'type' => '@@SECTION_NAME@@.future', 'parent_id' => 0, 'status' => Moto\Application\Pages\PageModel::STATUS_PUBLISH, 'visibility' => Moto\Application\Pages\PageModel::VISIBILITY_PUBLIC, 'is_system' => true, 'layout' => [ 'name' => 'default', 'sections' => [ 'header' => [ 'id' => 1, 'visible' => false, ], 'footer' => [ 'id' => 2, 'visible' => false, ], ], ], 'content' => '
<div class="moto-widget moto-widget-row row-fixed moto-spacing-top-large moto-spacing-right-auto moto-spacing-bottom-large moto-spacing-left-auto" data-grid-type="sm" data-widget="row" data-visible-on="-" data-spacing="lala" style="" data-bg-position="left top">
    <div class="container-fluid">
        <div class="row" data-container="container">
            <div class="moto-widget moto-widget-row__column moto-cell col-sm-12 moto-spacing-top-auto moto-spacing-right-auto moto-spacing-bottom-auto moto-spacing-left-auto" style="" data-enabled-side-spacing="false" data-widget="row.column" data-container="container" data-spacing="aaaa" data-bg-position="left top">{{ widget( {"name":"spacer","properties":{"preset":"default","height":"30px","spacing":{"top":"large","right":"auto","bottom":"large","left":"auto"},"visible_on":{"desktop":true,"tablet":true,"mobile-h":true,"mobile-v":true}}} ) }}
                <div class="moto-widget moto-widget-text moto-preset-default moto-spacing-top-auto moto-spacing-right-auto moto-spacing-bottom-medium moto-spacing-left-auto" data-widget="text" data-preset="default" data-spacing="aama" data-visible-on="-" data-animation=""><div class="moto-widget-text-content moto-widget-text-editable"><p class="moto-text_system_5">Sorry, you are a bit early</p><p class="moto-text_normal">This entity\'s details are not yet public. Please come back later.</p></div></div>{{ widget( {"name":"button","properties":{"link":{"action":"@@SECTION_NAME@@.index","properties":{"target":"_self","id":@@SECTION_HOME_PAGE_ID@@}},"label":"Back Home","align":{"desktop":"center","tablet":"","mobile-v":"","mobile-h":""},"size":"medium","preset":"default","animation":"","visible_on":{"desktop":true,"tablet":true,"mobile-h":true,"mobile-v":true},"spacing":{"top":"auto","right":"auto","bottom":"auto","left":"auto"}}} ) }}{{ widget( {"name":"spacer","properties":{"preset":"default","height":"30px","spacing":{"top":"large","right":"auto","bottom":"large","left":"auto"},"visible_on":{"desktop":true,"tablet":true,"mobile-h":true,"mobile-v":true}}} ) }}
            </div>
        </div>
    </div>
</div>
']; public function __construct($type = null) { if ($type) { $this->setType($type); } } public static function get($type) { $manager = Moto\System::app(ContentSection\ContentSectionManager::class); $provider = $manager->getProvider($type); $helper = $provider->getHelper(); return $helper; } public function getType() { return $this->_type; } public function setProvider($provider) { if ($this->_provider && $this->_provider !== $provider) { return false; } if (!$provider instanceof Moto\System\ContentSection\ContentProvider) { return false; } $this->_provider = $provider; return true; } abstract public function prepareHelper(); public function getProvider() { return $this->_provider; } public function setType($type) { if ($this->_type && $this->_type !== $type) { return false; } if (!is_string($type)) { return false; } $type = trim($type); if ($type === '') { return false; } $this->_type = $type; return true; } public function getPageType() { return Moto\Website\PageType::get($this->_type); } public function isConfigured() { $settings = $this->getCurrentSettings(); return !( !is_array($settings) || empty($settings['definitions']) || empty($settings['definitions']['index']) || empty($settings['definitions']['post']) || empty($settings['definitions']['index']['template']) || empty($settings['definitions']['post']['template']) ); } public function getCurrentSettings() { $result = $this->getProvider()->getProperties(); if (empty($result)) { $result = $this->getDefaultSettings(); } $result = Moto\Util::toArray($result); return $result; } public function setCurrentSettings($settings) { if (is_object($settings)) { $settings = Moto\Util::toArray($settings); } $this->getProvider()->setProperties($settings); return $this; } public function saveCurrentSettings() { $this->getProvider()->saveConfiguration(); return $this; } public function getDefaultSettings() { return $this->_defaultSettings; } public function updateDefaultSettings($settings) { if (!is_array($settings)) { $settings = Moto\Util::toArray($settings); } if (!is_array($settings)) { return false; } $settings = Moto\Update\Upgrade::migrateContentSectionSettings($settings); $this->_defaultSettings = Moto\Util::arrayMerge($this->_defaultSettings, $settings); return true; } public function getOption($name, $default = null) { return Moto\Util::getValue($this->_options, $name, $default); } public function setOption($name, $value) { Moto\Util::setToArrayDeep($this->_options, $name, $value); return $this; } public function info($str) { if ($this->getOption('logging', true)) { Moto\System\Log::info('@CONTENT_SECTION : ' . ucfirst($this->_type) . ' : ' . trim($str)); } } public function notice($str) { if ($this->getOption('logging', true)) { Moto\System\Log::notice('@CONTENT_SECTION : ' . ucfirst($this->_type) . ' : ' . trim($str)); } } public function critical($str) { Moto\System\Log::critical('@CONTENT_SECTION : ' . ucfirst($this->_type) . ' : ' . trim($str)); } public function exception($str, $e = null) { $errors = [ 'type' => $this->_type, 'helper' => get_class($this), ]; if ($e) { $errors['code'] = $e->getCode(); $errors['message'] = $e->getMessage(); $errors['class'] = get_class($e); if ($e instanceof Moto\Exception) { $errors['errors'] = $e->getErrors(); } if (Moto\System::isDevelopmentStage()) { $errors['point'] = $e->getLine() . ' ' . $e->getFile(); } } Moto\System\Log::emergency('@CONTENT_SECTION : ' . ucfirst($this->_type) . ' : ' . trim($str), $errors); if ($e instanceof \Exception) { throw $e; } else { throw new \Exception($str); } } public function getPostsCount() { $table = Moto\System::getDbTable('pages'); $items = $table->select(array( 'type' => $this->_type . '.post', )); return $items->count(); } public function createSamplePost($index = null) { $mainPage = $this->getOrCreateMainPage(); $postTemplate = $this->getOrCreatePostTemplate(); if ($index !== null && empty($this->_digitToWord[$index])) { $this->critical('Cant create sample post by "digitToWord"'); return false; } $table = new Moto\Application\Pages\PagesTable(); $table->useResultAsModel(true); if ($index === null) { $url = 'my-first-post'; } else { $url = 'post-' . $index; } $post = $table->getByUrl($mainPage->url . '/' . $url); if ($post) { $this->notice('Sample Post Exists [ url = ' . $url . ' ]'); } else { $this->info('Creating Sample Post [ url = ' . $url . ' ]'); $data = $this->_defaultPostContent; $data = json_encode($data); $data = str_replace('@@SECTION_NAME@@', $this->_type, $data); $data = str_replace('@@INDEX@@', $index, $data); if ($index !== null) { $data = str_replace('@@INDEX_NAME@@', $this->_digitToWord[$index], $data); } $data = json_decode($data, true); if ($index !== null && empty($data['name'])) { $data['name'] = $this->_digitToWord[$index] . ' Post'; } $data['parent_id'] = $mainPage->id; $data['url'] = $url; try { $post = Moto\Application\Pages\Service::save($data); } catch (\Exception $e) { $this->exception('Sample Post Not Saved', $e); } $post->type = $data['type']; $post->status = Moto\Application\Pages\PageModel::STATUS_DRAFT; $post->visibility = Moto\Application\Pages\PageModel::VISIBILITY_PUBLIC; $post->background_id = 0; $post->background = ''; if ($post->save()) { $this->info('Sample Post Created [ id = ' . $post->id . ' ]'); } else { $this->exception('Sample Post Created but Not Updated [ id = ' . $post->id . ' ]'); } } return $post; } protected function getMainPageTemplateData() { $data = $this->_defaultMainPageData; $data = json_encode($data); $data = str_replace('@@SECTION_NAME@@', $this->_type, $data); $data = json_decode($data, true); if (empty($data['name'])) { $data['name'] = ucfirst($this->_type); } $data['type'] = $this->_type . '.index'; return $data; } public function getOrCreateMainPage() { if ($this->_mainPage !== null) { return $this->_mainPage; } $table = new Moto\Application\Pages\PagesTable(); $table->useResultAsModel(true); $items = $table->select(array( 'type' => $this->_type . '.index', )); if ($items->count() === 0) { $this->info('Creating Main Page'); $data = $this->getMainPageTemplateData(); $url = $data['url']; for ($index = 1; $index < 1000; $index++) { $mainPage = $table->getByUrl($url); if (!$mainPage) { $data['url'] = $url; break; } $url = $data['url'] . '-' . ($index + 1); } $filter = new Moto\Application\Pages\InputFilter\NewPage(); $filter->setData($data); $values = $filter->getValues(); $mainPage = $table->create(); $mainPage->setFromArray($values); $mainPage->type = $data['type']; $mainPage->status = Moto\Util::getFromArrayDeep($data, 'status', Moto\Application\Pages\PageModel::STATUS_DRAFT); $mainPage->visibility = Moto\Util::getFromArrayDeep($data, 'visibility', Moto\Application\Pages\PageModel::VISIBILITY_PUBLIC); $mainPage->is_system = true; $mainPage->properties->meta->hideCanonical = true; try { if ($mainPage->save()) { $this->info('Main Page Saved [ id = ' . $mainPage->id . ' ]'); } else { $this->exception('Main Page Not Saved'); } } catch (\Exception $e) { $this->exception('Main Page Not Saved', $e); } } else { $mainPage = $items->current(); $this->notice('Main Page Exists [ id = ' . $mainPage->id . ' ]'); } $this->_mainPage = $mainPage; return $this->_mainPage; } protected function getPostTemplateData() { $data = $this->_defaultPostTemplateData; $data = json_encode($data); $data = str_replace('@@SECTION_NAME@@', $this->_type, $data); $data = json_decode($data, true); if (empty($data['name'])) { $data['name'] = ucfirst($this->_type); } $data['type'] = 'template.' . $this->_type . '.post'; return $data; } public function getOrCreatePostTemplate() { if ($this->_postTemplate !== null) { return $this->_postTemplate; } $mainPage = $this->getOrCreateMainPage(); $table = new Moto\Application\Pages\PagesTable(); $table->useResultAsModel(true); $items = $table->select(array( 'type' => 'template.' . $this->_type . '.post', )); if ($items->count() === 0) { $this->info('Creating Post Template'); $data = $this->getPostTemplateData(); $url = $data['url']; for ($index = 0; $index < 1000; $index++) { $postTemplate = $table->getByUrl($url); if (!$postTemplate) { $data['url'] = $url; break; } $url = $data['url'] . '-' . ($index + 1); } $filter = new Moto\Application\Pages\InputFilter\NewPage(); $filter->setData($data); $values = $filter->getValues(); $postTemplate = $table->create(); $postTemplate->setFromArray($values); $postTemplate->type = $data['type']; $postTemplate->status = Moto\Util::getFromArrayDeep($data, 'status', Moto\Application\Pages\PageModel::STATUS_PUBLISH); $postTemplate->visibility = Moto\Util::getFromArrayDeep($data, 'visibility', Moto\Application\Pages\PageModel::VISIBILITY_PUBLIC); $postTemplate->is_system = true; $postTemplate->properties->meta->hideCanonical = true; try { if ($postTemplate->save()) { $this->info('Post Template Saved [ id = ' . $postTemplate->id . ' ]'); } else { $this->exception('Post Template Not Saved'); } } catch (\Exception $e) { $this->exception('Post Template Not Created', $e); } } else { $postTemplate = $items->current(); $this->notice('Post Template Exists [ id = ' . $postTemplate->id . ' ]'); } $this->_postTemplate = $postTemplate; return $this->_postTemplate; } protected function getPostInFutureTemplateData() { $data = $this->_defaultPostInFutureData; $data = json_encode($data); $data = str_replace('@@SECTION_NAME@@', $this->_type, $data); $mainPage = $this->getOrCreateMainPage(); $data = str_replace('@@SECTION_HOME_PAGE_ID@@', $mainPage->id, $data); $data = json_decode($data, true); if (empty($data['name'])) { $data['name'] = ucfirst($this->_type); } $data['type'] = $this->_type . '.future'; return $data; } protected function getOrCreatePostInFutureTemplate() { if ($this->_futureTemplate !== null) { return $this->_futureTemplate; } $table = new Moto\Application\Pages\PagesTable(); $table->useResultAsModel(true); $items = $table->select(array( 'type' => $this->_type . '.future', )); if ($items->count() === 0) { $this->info('Creating PostInFuture Page'); $data = $this->getPostInFutureTemplateData(); $data['type'] = $this->_type . '.future'; $url = $data['url']; for ($index = 1; $index < 1000; $index++) { $template = $table->getByUrl($url); if (!$template) { $data['url'] = $url; break; } $url = $data['url'] . '-' . ($index + 1); } $filter = new Moto\Application\Pages\InputFilter\NewPage(); $filter->setData($data); $values = $filter->getValues(); $template = $table->create(); $template->setFromArray($values); $template->type = $data['type']; $template->status = Moto\Application\Pages\PageModel::STATUS_PUBLISH; $template->visibility = Moto\Application\Pages\PageModel::VISIBILITY_PUBLIC; $template->is_system = true; $template->properties->meta->noindex = true; $template->properties->meta->nofollow = true; $template->properties->meta->noodp = true; $template->properties->meta->noydir = true; $template->properties->meta->hideCanonical = true; try { if ($template->save()) { $this->info('PostInFuture Page Saved [ id = ' . $template->id . ' ]'); } else { $this->exception('PostInFuture Page Not Saved'); } } catch (\Exception $e) { $this->exception('PostInFuture Page Not Saved', $e); } } else { $template = $items->current(); $this->notice('PostInFuture Page Exists [ id = ' . $template->id . ' ]'); } $this->_futureTemplate = $template; return $template; } protected function getTaxonomyTemplateData(array $options, $taxonomy = null) { $section = $this->getType(); $content = $this->_defaultTaxonomyTemplateData; $content = json_encode($content); $content = str_replace('@@SECTION_NAME@@', $section, $content); $content = str_replace('@@TAXONOMY_NAME@@', $options['taxonomy']['name'], $content); $content = str_replace('@@TAXONOMY_TYPE@@', $options['taxonomy']['type'], $content); $content = str_replace('@@TAXONOMY_WIDGET_PREFIX@@', $options['taxonomy']['widget'], $content); $content = json_decode($content, true); if (empty($content['name'])) { $content['name'] = trim((string) Moto\Util::getValue($options, 'template.name', '')); } if (empty($content['name'])) { $content['name'] = $options['taxonomy']['label'] . ' Template'; } if (empty($content['url'])) { $content['url'] = 'moto-template-' . $section . '-' . $options['taxonomy']['name']; } return $content; } public function getOrCreateTaxonomyTemplate(TaxonomyDefinition $taxonomy) { $name = $taxonomy->name; if (array_key_exists($name, $this->_templates)) { return $this->_templates[$name]; } $mainPage = $this->getOrCreateMainPage(); $table = new Moto\Application\Pages\PagesTable(); $table->useResultAsModel(true); $templateType = 'template.' . $this->getType() . '.' . $name; $items = $table->select(array( 'type' => $templateType, )); $label = $taxonomy->getText('name'); if ($items->count() === 0) { $options = Moto\Util::toArray($taxonomy); if (empty($options['type'])) { $options['type'] = ($name === 'category' ? 'one' : 'many'); } if (empty($options['widget'])) { $options['widget'] = (in_array($name, ['category', 'tag']) ? $name : 'taxonomy'); } $this->info('Creating ' . $label . ' Template'); $data = $this->getTaxonomyTemplateData([ 'template' => [ 'name' => $taxonomy->getText('name') . ' Template', ], 'taxonomy' => [ 'name' => $name, 'label' => $label, 'type' => $options['type'], 'widget' => $options['widget'], ], ], $taxonomy); $data['type'] = $templateType; $url = $data['url']; for ($index = 0; $index < 1000; $index++) { $template = $table->getByUrl($url); if (!$template) { $data['url'] = $url; break; } $url = $data['url'] . '-' . ($index + 1); } $filter = new Moto\Application\Pages\InputFilter\NewPage(); $filter->setData($data); $values = $filter->getValues(); $template = $table->create(); $template->setFromArray($values); $template->type = $data['type']; $template->status = Moto\Util::getValue($data, 'status', Moto\Application\Pages\PageModel::STATUS_PUBLISH); $template->visibility = Moto\Util::getValue($data, 'visibility', Moto\Application\Pages\PageModel::VISIBILITY_PUBLIC); $template->is_system = true; $template->properties->meta->hideCanonical = true; try { if ($template->save()) { $this->info($label . ' Template Saved [ id = ' . $template->id . ' ]'); } else { $this->exception($label . ' Template Not Saved'); } } catch (\Exception $e) { $this->exception($label . ' Template Not Created', $e); } } else { $template = $items->current(); $this->notice($label . ' Template Exists [ id = ' . $template->id . ' ]'); } $this->_templates[$name] = $template; return $this->_templates[$name]; } protected function _beforeCheckOrInstall() { } protected function _afterCheckOrInstall() { } public function checkOrInstall() { $this->info('Check or Install'); Moto\Website\Settings::loadData(true); $this->_beforeCheckOrInstall(); $settings = $this->getCurrentSettings(); $isConfigured = $this->isConfigured(); if (!$isConfigured) { $this->setCurrentSettings($settings); } $this->createMainTemplates(); $this->createTaxonomiesTemplates(); $this->createSampleContent($isConfigured); $this->registerToSitemap($isConfigured); $this->_afterCheckOrInstall(); $this->saveCurrentSettings(); $this->info('Settings Saved'); $this->info('Done'); } protected function createMainTemplates() { $mainPage = $this->getOrCreateMainPage(); $postTemplate = $this->getOrCreatePostTemplate(); $provider = $this->getProvider(); $definitions = $provider->getDefinitions(); $definitions->get('index')->template = (int) $mainPage->id; $definitions->get('post')->template = (int) $postTemplate->id; if (is_array($this->_sitemap)) { $this->_sitemap['index'] = array_merge($this->_sitemap['index'], ['priority' => '0.8']); $this->_sitemap['post'] = array_merge($this->_sitemap['post'], ['priority' => '0.5']); } if ($provider->getOption('enablePostInFuture') && $definition = $definitions->get('future')) { $template = $this->getOrCreatePostInFutureTemplate(); $definition->template = (int) $template->id; } return $this; } protected function createTaxonomiesTemplates() { $definitions = $this->getProvider()->getTaxonomyDefinitions(); foreach ($definitions as $name => $taxonomy) { $template = $this->getOrCreateTaxonomyTemplate($taxonomy); $taxonomy->template = (int) $template->id; if (empty($taxonomy->uri)) { $taxonomy->uri = $name; } if (!is_array($this->_sitemap) || !in_array($name, ['tag', 'category'])) { continue; } if (!in_array($name, ['tag', 'category'])) { continue; } if (!array_key_exists($name, $this->_sitemap)) { $this->_sitemap[$name] = []; } $this->_sitemap[$name] = array_merge($this->_sitemap[$name], ['priority' => '0.5']); } return $this; } public function createSampleContent($isConfigured) { if (!$isConfigured && $this->getPostsCount() === 0) { $this->createSamplePost(); } } public function registerToSitemap($isConfigured) { if (!is_array($this->_sitemap)) { return; } $namespace = $this->getProvider()->getNamespace(); $section = strtoupper($namespace); $defaultLabel = $this->getOption('sitemapLabelTemplate', 'MODULE.{{SECTION}}.SITEMAP.{{TYPE}}_LABEL'); foreach ($this->_sitemap as $type => $options) { if (empty($options['label'])) { $options['label'] = str_replace([ '{{SECTION}}', '{{TYPE}}', ], [ $section, strtoupper($type), ], $defaultLabel); } if (empty($options['owner'])) { $options['owner'] = 'module:' . $namespace; } Moto\Website\SitemapService::addContentPreference($namespace . '.' . $type, $options); } } public function unInstallContent() { } } 