<?php
namespace Moto\System; use Moto; use InvalidArgumentException; use RuntimeException; class Encryption { const CURRENT_VERSION = 2; const V2_CIPHER_METHOD = 'AES-128-CBC'; const METHOD_JSON = 'JSON'; const METHOD_JSON_OBJECT = 'JSON_OBJECT'; const METHOD_SERIALIZE = 'SERIALIZE'; protected static $_defaultPassword = null; public static function setDefaultPassword($password) { if (!static::isValidPassword($password)) { return false; } static::$_defaultPassword = $password; return true; } public static function isValidPassword($password) { if (!is_string($password)) { return false; } return (strlen($password) > 0); } public static function encrypt($value, $method = true, $password = null) { if (is_string($password)) { if (!static::isValidPassword($password)) { throw new InvalidArgumentException('Invalid password'); } } else { $password = static::$_defaultPassword; } $iv = Moto\Util::generateRandomBytes(openssl_cipher_iv_length(static::V2_CIPHER_METHOD)); if ($method === static::METHOD_SERIALIZE || $method === true) { $value = serialize($value); } elseif ($method === static::METHOD_JSON || $method === static::METHOD_JSON_OBJECT) { $value = json_encode($value); } if (!is_numeric($value) && !is_string($value)) { throw new InvalidArgumentException('Value must be a string or use "method" argument'); } $value = (string) $value; $encryptedValue = \openssl_encrypt($value, static::V2_CIPHER_METHOD, $password, 1, $iv); if ($encryptedValue === false) { throw new RuntimeException('Can not encrypt value'); } $hash = static::_generateHash($iv, $encryptedValue, $password); $result = static::_packResponse(array( 'iv' => $iv, 'hash' => $hash, 'value' => $encryptedValue, )); return $result; } public static function decrypt($value, $method = true, $password = null) { if (!is_string($value)) { throw new InvalidArgumentException('Value must be a string'); } if (is_string($password)) { if (!static::isValidPassword($password)) { throw new InvalidArgumentException('Invalid password'); } } else { $password = static::$_defaultPassword; } $request = static::_unpackRequest($value); if ($request['version'] === 1) { return static::_decryptV1($request['value'], $password); } if ($request['version'] === 2) { return static::_decryptV2($request, $method, $password); } throw new RuntimeException('Unknown version of encrypted value'); } public static function encryptString($value) { if (!is_string($value)) { throw new InvalidArgumentException('Value must be a string'); } return static::encrypt($value, false); } public static function decryptString($value) { return static::decrypt($value, false); } public static function decryptLegacy($text, $pass) { if (!extension_loaded('mcrypt')) { throw new RuntimeException('Extension "mcrypt" not loaded'); } $level = error_reporting(); error_reporting(0); $result = trim(mcrypt_decrypt(MCRYPT_RIJNDAEL_256, $pass, base64_decode($text), MCRYPT_MODE_ECB, mcrypt_create_iv(mcrypt_get_iv_size(MCRYPT_RIJNDAEL_256, MCRYPT_MODE_ECB), MCRYPT_RAND))); error_reporting($level); if (Moto\System::isDevelopmentStage()) { Moto\System\Log::notice('@deprecated:' . __CLASS__ . '::' . __FUNCTION__); } return $result; } protected static function _packResponse($response) { $header = static::CURRENT_VERSION . '@'; $pack['h'] = $response['hash']; $pack['i'] = $response['iv']; $pack['v'] = $response['value']; $pack = array_map('base64_encode', $pack); return $header . base64_encode(json_encode($pack)); } protected static function _unpackRequest($request) { $result = array( 'version' => false ); if ($request[1] !== '@') { $result['value'] = $request; return $result; } $version = (int) $request[0]; $body = \mb_substr($request, 2, \mb_strlen($request, '8bit') - 2, '8bit'); $result['version'] = $version; $body = base64_decode($body); if ($version === 1) { $result['value'] = $body; } if ($version === 2) { $pack = json_decode($body, true); $result['hash'] = base64_decode($pack['h']); $result['iv'] = base64_decode($pack['i']); $result['value'] = base64_decode($pack['v']); } return $result; } protected static function _decryptV1($value, $key) { if (!extension_loaded('mcrypt')) { throw new RuntimeException('Extension "mcrypt" not loaded'); } $value = trim(mcrypt_decrypt(MCRYPT_RIJNDAEL_256, $key, $value, MCRYPT_MODE_ECB, mcrypt_create_iv(mcrypt_get_iv_size(MCRYPT_RIJNDAEL_256, MCRYPT_MODE_ECB), MCRYPT_RAND))); $value = json_decode($value, true); $value = trim(mcrypt_decrypt(MCRYPT_RIJNDAEL_256, $value['salt'], base64_decode($value['value']), MCRYPT_MODE_ECB, mcrypt_create_iv(mcrypt_get_iv_size(MCRYPT_RIJNDAEL_256, MCRYPT_MODE_ECB), MCRYPT_RAND))); $value = unserialize($value); return $value; } protected static function _decryptV2($request, $method, $key) { $iv = $request['iv']; $encryptedValue = $request['value']; $hash = static::_generateHash($iv, $encryptedValue, $key); if (function_exists('hash_equals')) { if (!hash_equals($request['hash'], $hash)) { if (Moto\System::isDevelopmentStage()) { Moto\System\Log::error('Hash not equals', array( 'request_hash' => base64_encode($request['hash']), 'hash' => base64_encode($hash), )); throw new RuntimeException('Hash not equal'); } } } $decryptedValue = \openssl_decrypt($encryptedValue, static::V2_CIPHER_METHOD, $key, 1, $iv); if ($method === static::METHOD_SERIALIZE || $method === true) { $decryptedValue = unserialize($decryptedValue); } elseif ($method === static::METHOD_JSON) { $decryptedValue = json_decode($decryptedValue, true); } elseif ($method === static::METHOD_JSON_OBJECT) { $decryptedValue = json_decode($decryptedValue); } return $decryptedValue; } protected static function _generateHash($iv, $encryptedValue, $password) { return hash_hmac('sha256', $iv . $encryptedValue, $password, true); } } 