<?php
 namespace Moto\System\Marketplace; use Moto; use Illuminate\Contracts\Support\Arrayable; use Illuminate\Contracts\Support\Jsonable; use ArrayAccess; use InvalidArgumentException; class MetaFile implements Arrayable, Jsonable, ArrayAccess { const ERROR_FILE_NOT_EXISTS = 'FILE_NOT_EXISTS'; const ERROR_CANT_DECODE = 'CANT_DECODE'; const ERROR_INVALID_CONTENT = 'INVALID_CONTENT'; const PRODUCT_TYPE = ''; const META_FILE_NAME = 'product_meta.json'; use Moto\System\Traits\AttributesTrait; protected $attributes = [ 'uid' => null, 'type' => null, 'options' => null, ]; protected $sourceFile = null; protected $sourceDir = null; protected $manager; public function __construct(array $attributes = []) { $this->fill($attributes); } public function setManager(Moto\System\MarketplaceManager $manager) { $this->manager = $manager; return $this; } public function getManager() { return $this->manager; } public function getProductType() { return (string) $this->getAttribute('type', static::PRODUCT_TYPE); } public function setTypeAttribute($value) { if (!is_string($value)) { throw new InvalidArgumentException('Invalid type'); } $value = trim($value); if ($value === '' || !empty(static::PRODUCT_TYPE) && static::PRODUCT_TYPE !== $value) { throw new InvalidArgumentException('Not compatible type : ' . var_export($value, true) . ' for ' . var_export(static::PRODUCT_TYPE, true)); } if ($this->attributes['type'] && $this->attributes['type'] !== $value) { throw new InvalidArgumentException('Not compatible type : ' . var_export($value, true) . ' for ' . var_export($this->attributes['type'], true)); } $this->attributes['type'] = $value; } public function loadFromSource($source) { if (is_dir($source)) { $source .= '/' . static::META_FILE_NAME; } $content = $this->getMetaFileContent($source); $this->setMetaFilePath($source); $this->fill($content); return $this; } protected function setOptionsAttribute($value = []) { if ($value instanceof MetaFileOptions) { $this->attributes['options'] = $value; } elseif (is_array($value)) { $this->options->fill($value); } else { throw new \InvalidArgumentException('Invalid attribute type "options"'); } } protected function getOptionsAttribute($value = []) { if (empty($this->attributes['options'])) { $class = $this->getManager()->resolveClass($this->getProductType(), 'MetaFileOptions'); $this->attributes['options'] = new $class(); } return $this->attributes['options']; } protected function setMetaFilePath($path) { $this->sourceFile = $path; $this->sourceDir = dirname($path); return $this; } public function getMetaFilePath() { return $this->sourceFile; } public function getSourceDir() { return $this->sourceDir; } public function requireSourceDir() { if (empty($this->sourceDir)) { throw new Moto\Exception('Source dir is required'); } return $this->sourceDir; } protected function getMetaFileContent($source) { if (!is_file($source)) { throw new Moto\Exception(static::ERROR_FILE_NOT_EXISTS); } $content = file_get_contents($source); $content = json_decode($content, true); if (!is_array($content)) { throw new Moto\Exception(static::ERROR_CANT_DECODE); } if (empty($content) || empty($content['uid']) || empty($content['type']) || empty($content['options']) || !is_array($content['options'])) { throw new Moto\Exception(static::ERROR_INVALID_CONTENT); } return $content; } protected function getRequiredFiles() { return (array) Moto\Util::getValue($this->options, 'require.files', []); } public function checkRequiredFiles() { $errors = []; $files = $this->getRequiredFiles(); $dir = $this->getSourceDir(); foreach ($files as $file) { if (is_array($file)) { $path = $file['path']; } else { $path = $file; } $errors[$path] = []; if (!file_exists($dir . '/' . $path)) { $errors[$path][] = static::ERROR_FILE_NOT_EXISTS; continue; } if (!is_array($file)) { continue; } if (array_key_exists('size', $file) && filesize($dir . '/' . $path) !== $file['size']) { $errors[$path][] = 'INVALID_FILE_SIZE'; } if (array_key_exists('md5', $file) && md5_file($dir . '/' . $path) !== $file['md5']) { $errors[$path][] = 'INVALID_HASH_MD5'; } if (array_key_exists('sha1', $file) && sha1_file($dir . '/' . $path) !== $file['sha1']) { $errors[$path][] = 'INVALID_HASH_SHA1'; } } $errors = array_filter($errors); return $errors; } public function getValidationErrors() { $errors = []; if ($this->getAttribute('uid') !== $this->options->getAttribute('uid')) { $errors[] = 'UID_NOT_EQUAL'; } $errors['REQUIRED_FILES'] = $this->checkRequiredFiles($errors); return $errors; } public function isValid() { $errors = $this->getValidationErrors(); $errors = array_filter($errors); if (empty($errors)) { return true; } Moto\System\Log::error('[MarketPlace] : MetaFile is not valid. Errors => ' . print_r($errors, true)); return false; } } 