<?php
 namespace Moto\System\Marketplace\Product; use Moto; use Carbon\Carbon; use Exception; class BlockInstaller extends Moto\System\Marketplace\ProductInstaller { const PRODUCT_TYPE = 'block'; protected function getValidationErrors() { $errors = parent::getValidationErrors(); $meta = $this->getMetaFile(); $sourceDir = $meta->requireSourceDir(); $options = $meta->options; if (!file_exists($sourceDir . '/' . $options->requireAttribute('content'))) { $errors[] = 'CONTENT_FILE_NOT_EXISTS'; } if (!file_exists($sourceDir . '/' . $options->requireAttribute('preview'))) { $errors[] = 'PREVIEW_FILE_NOT_EXISTS'; } return $errors; } protected function isNeedConfirmation() { $collection = Moto\Application\Blocks\Service::getBlockCollection('website'); $meta = $this->getMetaFile(); return (boolean) $collection->getItemById($meta['options']['uid']); } protected function runInstall() { $collection = Moto\Application\Blocks\Service::getBlockCollection('website'); $meta = $this->getMetaFile(); $item = $collection->getItemById($meta['options']['uid']); if (!$item) { $item = $collection->createItem([ 'id' => $meta['options']['uid'], 'name' => 'block', 'provider' => 'website', 'category' => $meta['options']['category'], ]); } $contentFilePath = $this->getAbsoluteSourcePath() . '/' . $meta['options']['content']; if (!file_exists($contentFilePath)) { throw new Moto\Exception('Content file not exists'); } $content = file_get_contents($contentFilePath); $item->content = $content; $item->category = $meta['options']['category']; Moto\Util::copyFile( $this->getAbsoluteSourcePath() . '/' . $meta['options']['preview'], Moto\System::getAbsolutePath($item->previewUrl) ); $collection->addItem($item); $collection->save(); return [ 'uid' => $item->id, 'category' => $item->category, ]; } } 