<?php
 namespace Moto\System\Marketplace; use Moto; use Exception; use ZipArchive; class ProductInstaller { const PRODUCT_TYPE = ''; use Moto\System\Traits\OptionsTrait; protected $_options = [ 'tempPath' => '@marketplaceTempDir/', 'confirmed' => false, ]; use Moto\System\Traits\AttributesTrait; protected $attributes = [ 'uid' => null, 'download_url' => null, 'source_path' => null, ]; protected $fillable = [ 'uid', 'type', 'download_url', 'file_size', 'hash_file', 'file_md5', ]; protected $locked = false; protected $manager; protected $metaFile; public function __construct(array $options = []) { $this->setOptions($options); } public function setManager(Moto\System\MarketplaceManager $manager) { $this->manager = $manager; return $this; } public function getManager() { return $this->manager; } public function getProductType() { return (string) $this->getAttribute('type', static::PRODUCT_TYPE); } protected function setFileSizeAttribute($size) { $this->attributes['file_size'] = (int) $size; return true; } protected function setHashFileAttribute($hash) { if (!is_string($hash)) { return false; } $hash = trim($hash); $this->attributes['hash_file'] = $hash; return true; } protected function setUidAttribute($uid) { if (!is_string($uid)) { return false; } $uid = trim($uid); if (empty($uid)) { return false; } $this->attributes['uid'] = $uid; return true; } protected function setDownloadUrlAttribute($url) { if (!is_string($url)) { return false; } $url = trim($url); if (empty($url)) { return false; } $info = parse_url($url); if (empty($info['scheme']) || empty($info['host'])) { return false; } if (empty($info['path']) && empty($info['query'])) { return false; } $this->attributes['download_url'] = $url; return true; } protected function getAbsoluteSourcePath() { return Moto\System::getAbsolutePath($this->requireAttribute('source_path')); } protected function getSourcePathAttribute($value = null) { if (empty($value)) { $tempPath = $this->getOption('tempPath'); $uid = $this->requireAttribute('uid'); $this->attributes['source_path'] = rtrim($tempPath, '/') . '/' . $this->getProductType() . '_' . $uid; } return $this->attributes['source_path']; } protected function reset() { $this->attributes = []; } public function installFrom(array $item) { if ($this->locked) { throw new \RuntimeException('Installer is locked'); } $this->locked = true; $this->reset(); $this->fill($item); $this->downloadProduct(); $this->extractArchive(); $sourcePath = $this->getAbsoluteSourcePath(); $response = $this->installFromSource($sourcePath); $this->locked = false; $this->reset(); return $response; } protected function isFreshArchive($archiveFilePath) { if (!file_exists($archiveFilePath)) { return false; } $requiredSize = $this->getAttribute('file_size'); $requiredHash = (string) $this->getAttribute('hash_file'); if (!$requiredSize && !$requiredHash) { return false; } if ($requiredSize && filesize($archiveFilePath) !== $requiredSize) { return false; } if ($requiredHash) { switch (strlen($requiredHash)) { case 32: if (md5_file($archiveFilePath) !== $requiredHash) { return false; } break; case 40: if (sha1_file($archiveFilePath) !== $requiredHash) { return false; } break; default: return false; } } return true; } protected function getTempPath() { return $this->requireOption('tempPath'); } protected function getAbsoluteTempPath() { return Moto\System::getAbsolutePath($this->getTempPath()); } protected function getArchivePath() { return $this->getTempPath() . '/' . $this->getProductType() . '_' . $this->requireAttribute('uid') . '.zip'; } protected function getArchiveAbsolutePath() { return Moto\System::getAbsolutePath($this->getArchivePath()); } protected function debug($message, $extra = []) { $message = '[Marketplace] ' . $this->getProductType() . ':' . $message; if (!empty($extra)) { $message .= ' => ' . print_r($extra, true); } Moto\System\Log::debug($message); } protected function downloadProduct() { $archiveFilePath = $this->getArchiveAbsolutePath(); if ($this->isFreshArchive($archiveFilePath)) { $this->debug(__FUNCTION__ . ' : Archive is fresh'); return true; } if (file_exists($archiveFilePath)) { unlink($archiveFilePath); } $this->debug(__FUNCTION__ . ' : Start download product'); $sourceUrl = $this->requireAttribute('download_url'); $client = new Moto\Http\Client(null, [ 'streamtmpdir' => '@tempUploads', 'curloptions' => [ CURLOPT_FOLLOWLOCATION => true, ], ]); $client->setUri($sourceUrl); $result = $client->downloadToFile($archiveFilePath, [ 'partial' => false, ]); if ($result['error']) { Moto\System\Log::error('[' . __CLASS__ . '::' . __FUNCTION__ . '] : downloading failed', [ 'result' => Moto\Util::arrayOnly($result, ['http_code', 'connection_error',]), ]); if (file_exists($archiveFilePath)) { Moto\Util::copyFile($archiveFilePath, $archiveFilePath . '.failed'); unlink($archiveFilePath); } throw new Moto\System\Exception('CANT_DOWNLOAD_RESOURCE', $result['http_code'], [ 'item' => [ 'uid' => $this->getAttribute('uid'), 'type' => $this->getProductType(), 'url' => $this->getAttribute('download_url'), ], 'http' => $result['error'], ]); } if (!$this->isFreshArchive($archiveFilePath)) { $file = [ 'size' => 0, ]; if (file_exists($archiveFilePath)) { $file['size'] = filesize($archiveFilePath); unlink($archiveFilePath); } throw new Moto\System\Exception('INVALID_DOWNLOADED_RESOURCE', Moto\System\Exception::ERROR_FAILED_DEPENDENCY_CODE, [ 'item' => [ 'uid' => $this->getAttribute('uid'), 'type' => $this->getProductType(), 'url' => $this->getAttribute('download_url'), ], 'file' => $file, ]); } $this->debug(__FUNCTION__ . ' : Product downloaded'); return true; } protected function extractArchive() { $this->debug(__FUNCTION__ . ' : Start'); $archiveFilePath = $this->getArchiveAbsolutePath(); $sourcePath = $this->getAbsoluteSourcePath(); if (is_dir($sourcePath)) { Moto\Util::emptyDir($sourcePath); } else { Moto\Util::createDir($sourcePath); } $archive = new ZipArchive(); if (!$archive->open($archiveFilePath)) { Moto\System\Log::critical('[Marketplace] Cant open archive ' . print_r([ 'type' => $this->getProductType(), 'installer' => get_class($this), 'file' => $this->getArchivePath(), ], true)); throw new Moto\Exception('Cant open archive'); } $result = $archive->extractTo($sourcePath); $archive->close(); if (!$result) { Moto\System\Log::critical('[Marketplace] Cant extract archive ' . print_r([ 'type' => $this->getProductType(), 'installer' => get_class($this), 'file' => $this->getArchivePath(), ], true)); throw new Moto\Exception('Cant extract archive'); } $this->debug(__FUNCTION__ . ' : Done'); return true; } protected function getValidationErrors() { $meta = $this->getMetaFile(); $errors = []; if ($meta->getAttribute('uid') !== $meta->options->getAttribute('uid')) { $errors[] = 'UID_NOT_EQUAL'; } $errors['REQUIRED_FILES'] = $meta->checkRequiredFiles(); return $errors; } public function installFromSource($source) { $this->setAttribute('source_path', $source); $errors = $this->getValidationErrors(); $errors = array_filter($errors); if (!empty($errors)) { Moto\System\Log::error('[MarketPlace] : MetaFile is not valid. Errors => ' . print_r($errors, true)); throw new Moto\Exception('Invalid meta file', 0, $errors); } if (!$this->getOption('confirmed') && $this->isNeedConfirmation()) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_NEED_CONFIRMATION, Moto\System\Exception::ERROR_CONFLICT_CODE, [ 'item' => ['recordFound'], ]); } $response = $this->runInstall(); return [ 'uid' => $this->uid, 'type' => $this->getProductType(), 'item' => $response, ]; } public function getMetaFileClass() { return $this->getManager()->resolveClass($this->getProductType(), 'MetaFile'); } protected function getMetaFile() { if (!$this->metaFile) { $class = $this->getMetaFileClass(); $this->metaFile = new $class([ 'type' => $this->getProductType(), ]); $this->metaFile->setManager($this->getManager()); $this->metaFile->loadFromSource($this->getAbsoluteSourcePath()); } return $this->metaFile; } protected function runInstall() { Moto\System\Log::critical('Method ' . __CLASS__ . '::' . __FUNCTION__ . ' not implemented'); throw new Moto\System\Exception('INSTALLATION_METHOD_NOT_IMPLEMENTED'); } protected function isNeedConfirmation() { return false; } public function cleanup() { try { $archiveFilePath = $this->getArchiveAbsolutePath(); if (file_exists($archiveFilePath)) { @unlink($archiveFilePath); } $path = $this->getAbsoluteSourcePath(); $path = trim($path); if (empty($path) && is_dir($path)) { Moto\Util::deleteDir($path); } } catch (\Exception $e) { Moto\System\Log::debug('Exception  => ' . print_r([ 'message' => $e->getMessage(), 'class' => get_class($e), 'line' => $e->getLine(), 'file' => basename($e->getFile()), 'code' => $e->getCode(), ], true)); } return true; } } 