<?php
 namespace Moto\System\Plugins; use Exception; use Moto; class PluginManager { const API_VERSION = 1; const PRIORITY_DEFAULT = 50; use Moto\System\Traits\OptionsTrait; protected $_options = [ 'whiteList' => '*', 'blackList' => null, ]; protected $_websitePluginsDir = '@plugins'; protected $_pluginMetaFile = 'plugin.meta.php'; protected $_maxHeaderSize = 10240; protected $_nameDelimiter = '@'; protected $_connectors = array(); protected $_booted = false; protected $_bootedPlugins = array(); protected $_installedPlugins = array(); protected $_pluginsLoaded = false; public function __construct(array $options = []) { $this->setOptions($options); $this->loadSettings(true); } public function initPlugins($bootPlugins = false) { if (Moto\System::isUpdateEngine()) { return; } if (Moto\System::isInstallEngine()) { return; } if ($bootPlugins) { $this->bootActivatedPlugins(); } } protected function loadSettings($reload = false) { if (!Moto\System::isInstalled()) { return false; } if ($reload || $this->_pluginsLoaded === false) { Moto\Website\Settings::init(); $installedPlugins = Moto\Website\Settings::get('installed_plugins'); $this->_installedPlugins = $this->_sanitizeInstalledList($installedPlugins); $this->_pluginsLoaded = true; } return true; } public function isSettingsLoaded() { return $this->_pluginsLoaded; } protected function _sanitizeInstalledList($list) { if (is_string($list)) { $list = json_decode($list, true); } if (!is_array($list)) { return array(); } $result = array(); foreach ($list as $name => $item) { if (!is_array($item)) { continue; } if (!array_key_exists('name', $item)) { continue; } if (!array_key_exists('connector_class', $item)) { continue; } if (!array_key_exists('priority', $item)) { $item['priority'] = static::PRIORITY_DEFAULT; } $result[$item['name']] = $item; } return $result; } public function saveInstalledList() { if (!$this->_pluginsLoaded) { $this->loadSettings(true); } $list = array_values($this->_installedPlugins); usort($list, function ($a, $b) { if ($a['priority'] === $b['priority']) { return 0; } return ($a['priority'] < $b['priority']) ? -1 : 1; }); return Moto\Website\Settings::add('installed_plugins', $list, 'array'); } public function isFolderContainPlugin($folder) { return file_exists(Moto\System::getAbsolutePath($folder) . '/' . $this->_pluginMetaFile); } public function getUpdateList() { $plugins = $this->findLocalPlugins(); if (!$plugins) { return array(); } return $plugins->toArray(array('name', 'version', 'build')); } protected function _isValidMetaItem($name, $value) { if (!is_string($name)) { return false; } switch ($name) { case 'name': $isValid = preg_match('/^[a-z0-9\-\_\\' . $this->_nameDelimiter . ']{3,}$/', $value); break; case 'version': $isValid = preg_match('/^\d[\d\.a-z]*$/i', $value); break; case 'build': $isValid = preg_match('/^[\d]{1,8}$/', $value); break; case 'injector': case 'connector_file': $isValid = preg_match('/^[a-z][a-z0-9\/]{1,128}\.php$/i', $value); break; case 'connector_class': $isValid = preg_match('/^[a-z][a-z0-9\\\]{3,128}$/i', $value); break; default: $isValid = !preg_match('/[<>]/', $value); break; } return (boolean) $isValid; } protected function _sanitizeMetaItemValue($name, $value) { switch ($name) { case 'build': $value = (int) $value; break; } return $value; } public function getMetaInformation($absolutePath) { if (!is_string($absolutePath)) { return false; } if (is_dir($absolutePath)) { $absolutePath .= '/' . $this->_pluginMetaFile; } elseif (basename($absolutePath) !== $this->_pluginMetaFile) { return false; } if (!file_exists($absolutePath)) { return false; } $fileSize = filesize($absolutePath); $fileHandle = fopen($absolutePath, 'r'); $content = fread($fileHandle, min($fileSize, $this->_maxHeaderSize)); fclose($fileHandle); $content = str_replace("\r", "\n", $content); $content = explode("\n", $content); $header = false; $meta = array(); foreach ($content as $line) { $line = trim($line); if ($line === '') { continue; } if (strpos($line, '/*') === 0) { $header = true; continue; } if (strpos($line, '*/') === 0) { break; } if (!$header) { continue; } if (preg_match('/^[\s*@]*([a-z\s]{3,})\s*:(.*)$/i', $line, $match)) { $key = $match[1]; $key = trim($key); $key = strtolower($key); $key = preg_replace('/[\s]+/', '_', $key); $value = trim($match[2]); if ($this->_isValidMetaItem($key, $value) && !array_key_exists($key, $meta)) { $meta[$key] = $this->_sanitizeMetaItemValue($key, $value); } } } return $meta; } protected function _isValidMeta($meta, $folder) { if (!is_array($meta)) { return false; } if (empty($meta['name'])) { return false; } if (empty($meta['version'])) { return false; } if (empty($meta['build'])) { return false; } if (empty($meta['injector'])) { return false; } if (empty($meta['connector_class'])) { return false; } $nameToFolder = str_replace($this->_nameDelimiter, '/', $meta['name']); if ($folder !== $nameToFolder) { return false; } return true; } protected function _getPluginInformationFromFile($folder) { $path = $this->_websitePluginsDir . '/' . $folder; $absolutePath = Moto\System::getAbsolutePath($path); if (is_dir($absolutePath)) { $absolutePath .= '/' . $this->_pluginMetaFile; } else { if (basename($absolutePath) !== $this->_pluginMetaFile) { return false; } } if (!file_exists($absolutePath)) { return false; } $result = array(); $meta = $this->getMetaInformation($absolutePath); if (!$this->_isValidMeta($meta, $folder)) { return false; } $result['folder'] = $path; $result['meta'] = $meta; return new Moto\System\Plugins\PluginItem($result); } public function findLocalPlugins($filter = null) { $pluginsDir = Moto\System::getAbsolutePath($this->_websitePluginsDir); $plugins = array(); if (!is_callable($filter)) { $filter = function () { return true; }; } $options = array( 'addDir' => true, 'maxLevel' => 1, 'compareFunction' => function ($dir = '', $item = '', $root = '', $type = '') { if ((string) $type !== 'dir') { return false; } return $this->isFolderContainPlugin($root . '/' . $dir . '/' . $item); }, 'skipThisPathFunction' => function ($root = null, $dir = null) { return file_exists($root . '/' . $dir . '/' . $this->_pluginMetaFile); }, ); $list = Moto\Util::scanDir($pluginsDir, '', $options); foreach ($list as $item) { $plugin = $this->_getPluginInformationFromFile($item); if (!$plugin) { continue; } if (!$filter('plugin', $plugin)) { continue; } $plugins[] = $plugin; } $plugins = new Moto\System\Plugins\PluginCollection($plugins); return $plugins; } public function findLocalPluginByName($name) { if ($this->_isValidMetaItem($name, 'name')) { return $this->_getPluginInformationFromFile($this->getPluginFolderByName($name)); } return null; } public function isActivated($name) { return Moto\Util::getValue($this->_installedPlugins, $name . '.activated', false); } public function isInstalled($name) { return array_key_exists($name, $this->_installedPlugins); } protected function _isAllow($action, $plugin) { if (Moto\System::isInstallEngine()) { return true; } return (boolean) (Moto\System::getUser()); } protected function _isDeniedThrowError($action, $plugin) { if (!$this->_isAllow($action, $plugin)) { throw new Moto\System\Exception(Moto\System\Exception::ERROR_PERMISSION_DENIED_MESSAGE, Moto\System\Exception::ERROR_PERMISSION_DENIED_CODE, array( 'name' => $plugin, 'action' => 'plugin:' . $action, )); } } public function activate($name) { $name = (string) $name; $name = trim($name); $this->_isDeniedThrowError('activate', $name); if (!$this->isInstalled($name)) { throw new Moto\System\Exception('COMMON.ERROR.PLUGIN_NOT_INSTALLED', Moto\System\Exception::ERROR_CONFLICT_CODE, array( 'name' => $name, )); } $plugin = $this->findLocalPluginByName($name); if (!$plugin) { throw new Moto\System\Exception('COMMON.ERROR.PLUGIN_NOT_EXISTS', Moto\System\Exception::ERROR_NOT_FOUND_CODE, array( 'name' => $name, )); } if ($this->isActivated($name)) { throw new Moto\System\Exception('COMMON.ERROR.PLUGIN_ALREADY_ACTIVATED', Moto\System\Exception::ERROR_CONFLICT_CODE, array( 'name' => $name, )); } $connector = $this->_createConnector($name, $plugin); if (!$connector || $connector->getName() !== $name) { throw new Moto\System\Exception('COMMON.ERROR.PLUGIN_CONNECTOR_NOT_EXISTS', Moto\System\Exception::ERROR_NOT_FOUND_CODE, array( 'name' => $name, )); } $apiVersion = $connector->compatibleApiVersions(); if (!is_array($apiVersion) || !in_array(static::API_VERSION, $apiVersion)) { throw new Moto\System\Exception('COMMON.ERROR.PLUGIN_CONNECTOR_NOT_COMPATIBLE', Moto\System\Exception::ERROR_CONFLICT_MESSAGE, array( 'name' => $name, 'pluginApiVersion' => $apiVersion, 'currentApiVersion' => static::API_VERSION, )); } $errors = null; try { $errors = $connector->getRequirementsErrors(); } catch (\Exception $e) { if (method_exists($e, 'getErrors')) { $errors = $e->getErrors(); } else { $errors = array( 'exception' => array( 'code' => $e->getCode(), 'message' => $e->getMessage(), ) ); } } if ($errors !== null) { throw new Moto\System\Exception('COMMON.ERROR.PLUGIN_FAILED_DEPENDENCY', Moto\System\Exception::ERROR_FAILED_DEPENDENCY_CODE, $errors); } try { $connector->extendAutoload(); $connector->activate(); } catch (\Exception $e) { Moto\System\Log::error('Plugin [ ' . $name . ' ] cant activated because [ ' . $e->getCode() . ' ] ' . $e->getMessage()); $errors = []; if (method_exists($e, 'getErrors')) { $errors = (array) $e->getErrors(); if (count($errors) !== 0) { Moto\System\Log::error(' => Errors : ', $errors); } } $errors['exception'] = [ 'code' => $e->getCode(), 'message' => $e->getMessage(), ]; throw new Moto\System\Exception('COMMON.ERROR.PLUGIN_ACTIVATION_FAILED', Moto\System\Exception::ERROR_INSTALLATION_FAILED_CODE, $errors); } $this->_installedPlugins[$name]['activated'] = true; $this->saveInstalledList(); return true; } public function install($name) { if (!$this->_pluginsLoaded) { $this->loadSettings(true); } $name = (string) $name; $name = trim($name); $plugin = $this->findLocalPluginByName($name); if (!$plugin) { throw new Moto\System\Exception('COMMON.ERROR.PLUGIN_NOT_EXISTS', Moto\System\Exception::ERROR_NOT_FOUND_CODE, array( 'name' => $name, )); } $this->_isDeniedThrowError('install', $name); if ($this->isInstalled($name)) { throw new Moto\System\Exception('COMMON.ERROR.PLUGIN_ALREADY_INSTALLED', Moto\System\Exception::ERROR_CONFLICT_CODE, array( 'name' => $name, )); } $record = array( 'name' => $plugin->getName(), 'version' => $plugin->getVersion(), 'build' => $plugin->getBuild(), 'priority' => $plugin->metaGet('priority', static::PRIORITY_DEFAULT), 'activated' => false, 'connector_class' => $plugin->metaGet('connector_class'), 'created_at' => time(), ); if ($plugin->metaHas('connector_file')) { $record['connector_file'] = $plugin->metaGet('connector_file'); } $connector = $this->_createConnector($name, $plugin); if (!$connector || $connector->getName() !== $name) { throw new Moto\System\Exception('COMMON.ERROR.PLUGIN_CONNECTOR_NOT_EXISTS', Moto\System\Exception::ERROR_NOT_FOUND_CODE, array( 'name' => $name, )); } $apiVersion = $connector->compatibleApiVersions(); if (!is_array($apiVersion) || !in_array(static::API_VERSION, $apiVersion)) { throw new Moto\System\Exception('COMMON.ERROR.PLUGIN_CONNECTOR_NOT_COMPATIBLE', Moto\System\Exception::ERROR_CONFLICT_MESSAGE, array( 'name' => $name, 'pluginApiVersion' => $apiVersion, 'currentApiVersion' => static::API_VERSION, )); } $errors = null; try { $errors = $connector->getRequirementsErrors(); } catch (\Exception $e) { if (method_exists($e, 'getErrors')) { $errors = $e->getErrors(); } else { $errors = array( 'exception' => array( 'code' => $e->getCode(), 'message' => $e->getMessage(), ) ); } } if ($errors !== null) { throw new Moto\System\Exception('COMMON.ERROR.PLUGIN_FAILED_DEPENDENCY', Moto\System\Exception::ERROR_FAILED_DEPENDENCY_CODE, $errors); } try { $connector->extendAutoload(); $connector->install(); } catch (\Exception $e) { Moto\System\Log::error('Plugin [ ' . $name . ' ] cant installed because [ ' . $e->getCode() . ' ] ' . $e->getMessage()); $errors = []; if (method_exists($e, 'getErrors')) { $errors = (array) $e->getErrors(); if (count($errors) !== 0) { Moto\System\Log::error(' => Errors : ', $errors); } } $errors['exception'] = [ 'code' => $e->getCode(), 'message' => $e->getMessage(), ]; throw new Moto\System\Exception('COMMON.ERROR.PLUGIN_INSTALLATION_FAILED', Moto\System\Exception::ERROR_INSTALLATION_FAILED_CODE, $errors); } $this->_installedPlugins[$name] = $record; $this->saveInstalledList(); return true; } public function deactivate($name) { $this->_isDeniedThrowError('deactivate', $name); if (!$this->isActivated($name)) { throw new Moto\System\Exception('COMMON.ERROR.PLUGIN_NOT_ACTIVATED', Moto\System\Exception::ERROR_CONFLICT_CODE); } $plugin = $this->findLocalPluginByName($name); if ($plugin) { $pluginInjector = $plugin->getPath() . '/' . $plugin->metaGet('injector'); Moto\System::removeInjector($pluginInjector); } $this->_installedPlugins[$name]['activated'] = false; $this->saveInstalledList(); try { $connector = $this->getConnector($name); if ($connector) { $connector->deactivate(); } } catch (\Exception $e) { Moto\System\Log::error('Plugin [ ' . $name . ' ] throw exception on deactivating [ ' . $e->getCode() . ' ] ' . $e->getMessage()); if (method_exists($e, 'getErrors')) { $errors = (array) $e->getErrors(); if (count($errors) !== 0) { Moto\System\Log::error(' => Errors : ', $errors); } } } return true; } public function uninstall($name) { $this->_isDeniedThrowError('uninstall', $name); if (!$this->isInstalled($name)) { throw new Moto\System\Exception('COMMON.ERROR.PLUGIN_NOT_INSTALLED', Moto\System\Exception::ERROR_CONFLICT_CODE); } if ($this->isActivated($name)) { throw new Moto\System\Exception('COMMON.ERROR.PLUGIN_IS_ACTIVATED', Moto\System\Exception::ERROR_CONFLICT_CODE); } $plugin = $this->findLocalPluginByName($name); if ($plugin) { $pluginInjector = $plugin->getPath() . '/' . $plugin->metaGet('injector'); Moto\System::removeInjector($pluginInjector); } try { $connector = $this->getConnector($name); if (array_key_exists($name, $this->_installedPlugins)) { unset($this->_installedPlugins[$name]); } $this->saveInstalledList(); if ($connector) { $connector->extendAutoload(); $connector->uninstall(); } } catch (\Exception $e) { Moto\System\Log::error('Plugin [ ' . $name . ' ] throw exception on uninstalling [ ' . $e->getCode() . ' ] ' . $e->getMessage()); if (method_exists($e, 'getErrors')) { $errors = (array) $e->getErrors(); if (count($errors) !== 0) { Moto\System\Log::error(' => Errors : ', $errors); } } } return true; } public function getPluginFolderByName($name) { $name = (string) $name; $name = str_replace(array('.', '@'), '/', $name); return $name; } public function getPluginPathByName($name) { return $this->_websitePluginsDir . '/' . $this->getPluginFolderByName($name); } protected function _createConnector($name, $meta) { $name = (string) $name; $name = trim($name); if ($name === '') { return null; } if ($meta instanceof Moto\System\Plugins\PluginItem) { $meta = $meta->toArray(); } $class = Moto\Util::getValue($meta, 'connector_class'); if (empty($class)) { return null; } if (!class_exists($class, false)) { $file = Moto\Util::getValue($meta, 'connector_file'); if (!empty($file)) { $filePath = $this->getPluginPathByName($name) . '/' . $file; $absoluteFilePath = Moto\System::getAbsolutePath($filePath); if (file_exists($absoluteFilePath)) { include_once $absoluteFilePath; } else { return null; } } } if (!class_exists($class)) { return null; } try { $connector = new $class(); if ($connector instanceof Moto\System\PluginConnector) { return $connector; } } catch (\Exception $e) { Moto\System\Log::error('Exception on creating plugin connector : ' . $e->getMessage(), array( 'code' => $e->getCode(), 'message' => $e->getMessage(), )); } return null; } public function getConnector($name) { $name = (string) $name; $name = trim($name); if ($name === '') { return null; } if (array_key_exists($name, $this->_connectors)) { return $this->_connectors[$name]; } if (!$this->isInstalled($name)) { return null; } $plugin = $this->findLocalPluginByName($name); if (!$plugin) { return null; } $connector = $this->_createConnector($name, $plugin); $this->_connectors[$name] = $connector; return $connector; } public function isBooted() { return $this->_booted; } public function isBootedPlugin($name) { return array_key_exists($name, $this->_bootedPlugins); } protected function bootActivatedPlugins() { if ($this->isBooted()) { return false; } foreach ($this->_installedPlugins as $item) { if ($item['activated'] && $this->isBootable($item['name'])) { $this->bootPlugin($item['name']); } } $this->_booted = true; } protected function isBootable($name) { $blackList = (array) $this->getOption('blackList'); if (in_array('*', $blackList, true) || in_array($name, $blackList, true)) { return false; } $whiteList = (array) $this->getOption('whiteList'); if (empty($whiteList) || in_array('*', $whiteList, true) || in_array($name, $whiteList, true)) { return true; } return false; } public function bootPlugin($name) { if ($this->isBootedPlugin($name)) { return false; } $connector = $this->getConnector($name); if (!$connector) { Moto\System\Log::error('Plugin [ ' . $name . ' ] cant find PluginConnector'); return false; } try { $connector->extendAutoload(); $connector->bootstrap(); $this->_bootedPlugins[$name] = true; return true; } catch (\Exception $e) { Moto\System\Log::error('Plugin [ ' . $name . ' ] cant bootstrap because [ ' . $e->getCode() . ' ] ' . $e->getMessage()); if (method_exists($e, 'getErrors')) { $errors = (array) $e->getErrors(); if (count($errors) !== 0) { Moto\System\Log::error(' => Errors : ', $errors); } } } return false; } public function getUpdateSteps($name) { if ($this->isInstalled($name)) { $connector = $this->getConnector($name); if (!$connector) { throw new Moto\System\Exception('COMMON.ERROR.PLUGIN_CONNECTOR_NOT_EXISTS', Moto\System\Exception::ERROR_NOT_FOUND_CODE, array( 'name' => $name, )); } $activated = $this->isActivated($name); $steps = array( 'downloadArchive', 'extractArchive', 'checkFiles', ); if ($activated) { $steps[] = 'enableMaintenance'; } $steps = array_merge($steps, array( 'updateFiles', 'clearSystemCache', 'updateDatabase', )); if ($activated) { $steps = array_merge($steps, array( 'cleanCache', 'optimizeStyles', 'rebuildStyles', 'disableMaintenance', )); } $steps = array_merge($steps, array( 'finishUpdate', )); } else { $steps = array( 'downloadArchive', 'extractArchive', 'checkFiles', 'updateFiles', 'finishUpdate', ); } return $steps; } } 