<?php
namespace Moto\System; use Moto; use Traversable; use ArrayAccess; use InvalidArgumentException; class PriorityCollection extends Moto\System\BaseCollection { protected $_priorityNames = []; protected $_items = []; protected $_options = [ 'defaultPriority' => 0, 'autoSorting' => true, 'ascending' => true, ]; public function getPriorityFor($name) { return Moto\Util::getValue($this->_priorityNames, $name, $this->getDefaultPriority()); } public function setDefaultPriority($value) { $this->_options['defaultPriority'] = (int) $value; return $this; } public function getDefaultPriority() { return $this->_options['defaultPriority']; } public function enableAutoSorting() { $this->_options['autoSorting'] = true; return $this; } public function disableAutoSorting() { $this->_options['autoSorting'] = false; return $this; } public function isAutoSorting() { return $this->_options['autoSorting']; } public function enableAscendingSorting() { $this->_options['ascending'] = true; return $this; } public function disableAscendingSorting() { $this->_options['ascending'] = false; return $this; } public function isAscendingSorting() { return $this->_options['ascending']; } protected function _isAllowedItem($item) { return ($item instanceof PriorityItem); } protected function _wrapItemIsNeed($item, $priority = null) { if ($this->_isAllowedItem($item)) { return $item; } return new PriorityItem($item, $priority, $this); } protected function _sanitizeItems($items) { $items = parent::_sanitizeItems($items); if (count($items) < 1) { return $items; } $priority = $this->_resolvePriority(); $temp = []; foreach ($items as $index => $item) { if ($this->_isAllowedItem($item) && !$item->setCollection($this)) { continue; } $temp[] = $this->_wrapItemIsNeed($item, $priority); } return $temp; } protected function _resolvePriority($priority = null) { if (is_string($priority)) { return $this->getPriorityFor($priority); } if ($priority !== null && !is_int($priority)) { return false; } if ($priority === null) { $priority = $this->getDefaultPriority(); } return $priority; } public function insert($target, $priority = null) { $priority = $this->_resolvePriority($priority); if ($priority === false) { return false; } $target = $this->_wrapItemIsNeed($target, $priority); $this->offsetSet(null, $target); return $target; } protected function _insertToPosition($target, $position, $priority) { $priority = $this->_resolvePriority($priority); if ($priority === false) { return false; } $target = $this->_wrapItemIsNeed($target, $priority); array_splice($this->_items, $position, 0, [$target]); if ($this->isAutoSorting()) { $this->updateSorting(); } return $target; } public function insertBefore($target, $item) { if (!$this->_isAllowedItem($item)) { return false; } $position = array_search($item, $this->_items, true); return $this->_insertToPosition($target, $position, $item->getPriority()); } public function insertAfter($target, $item) { if (!$this->_isAllowedItem($item)) { return false; } $position = array_search($item, $this->_items, true) + 1; return $this->_insertToPosition($target, $position + 1, $item->getPriority()); } public function updateSorting() { $tempItems = []; foreach ($this->_items as $key => $item) { $tempItems[$key] = $item->getPriority(); } if ($this->isAscendingSorting()) { asort($tempItems, SORT_REGULAR); } else { arsort($tempItems, SORT_REGULAR); } foreach (array_keys($tempItems) as $key) { $tempItems[$key] = $this->_items[$key]; } $this->_items = array_values($tempItems); return $this; } public function targets() { $result = []; foreach ($this->_items as $item) { $result[] = $item->getTarget(); } return $result; } public function isTargetExists($target) { return (bool) $this->findItemByTarget($target); } public function findItemByTarget($target) { foreach ($this->_items as $item) { if ($this->_isEqualTargets($item->getTarget(), $target)) { return $item; } } return null; } protected function _isEqualTargets($a, $b) { return ($a === $b); } public function remove($item) { if (!$this->_isAllowedItem($item)) { return false; } $position = array_search($item, $this->_items, true); if ($position === false) { return false; } $this->offsetUnset($position); return true; } public function offsetSet($offset, $value) { if (!$this->_isAllowedItem($value)) { return false; } if (!$value->setCollection($this)) { return false; } parent::offsetSet($offset, $value); if ($this->isAutoSorting()) { $this->updateSorting(); } } } class PriorityItem implements ArrayAccess { protected $_target; protected $_priority; protected $_collection; public function __construct($target, $priority = 0, $collection = null) { if (!is_array($target) && !is_object($target)) { throw new InvalidArgumentException('Target must be array or object'); } $this->_target = $target; $this->setCollection($collection); $this->setPriority($priority); } public function getTarget() { return $this->_target; } public function getPriority() { return $this->_priority; } public function setPriority($priority) { if (is_int($priority)) { $this->_priority = $priority; } } public function increasePriority($delta = 1) { if (is_int($delta)) { $this->_priority += $delta; } } public function decreasePriority($delta = 1) { if (is_int($delta)) { $this->_priority -= $delta; } } public function getCollection() { return $this->_collection; } public function setCollection(PriorityCollection $collection = null) { if ($this->_collection === $collection) { return true; } if ($this->_collection) { return false; } $this->_collection = $collection; return true; } public function insertBefore($target) { if ($this->_collection) { return $this->_collection->insertBefore($target, $this); } return false; } public function insertAfter($target) { if ($this->_collection) { return $this->_collection->insertAfter($target, $this); } return false; } public function remove() { if ($this->_collection) { return $this->_collection->remove($this); } return false; } public function get($name, $default) { return Moto\Util::getValue($this->_target, $name, $default); } public function toArray() { $target = $this->_target; if (is_object($target) && method_exists($target, 'toArray')) { return $target->toArray(); } elseif ($target instanceof Traversable) { $target = iterator_to_array($target); } return $target; } public function offsetExists($offset) { if (!$this->_target) { return false; } if (is_array($this->_target)) { return isset($this->_target[$offset]); } return isset($this->_target->{$offset}); } public function offsetGet($offset) { if (!$this->_target) { return null; } if (is_array($this->_target)) { if (array_key_exists($offset, $this->_target)) { return $this->_target[$offset]; } return null; } if (isset($this->_target->{$offset})) { return $this->_target->{$offset}; } return null; } public function offsetSet($offset, $value) { return false; } public function offsetUnset($offset) { } public function __isset($name) { return $this->offsetExists($name); } public function __get($name) { return $this->offsetGet($name); } public function __set($name, $value) { return $this->offsetSet($name, $value); } public function __unset($name) { $this->offsetUnset($name); } } 