<?php
 namespace Moto\System; use Illuminate\Support\Arr; use Moto; class ProductInformation { const DELIMITER = '@'; const ERROR_REQUEST_SIGN_IS_EMPTY = 'ERROR_REQUEST_SIGN_IS_EMPTY'; const ERROR_CANT_ENCRYPT_MESSAGE = 'ERROR_CANT_ENCRYPT_MESSAGE'; protected static $_filePath = '@productInformationFile'; protected static $_data = null; protected static $_initialized = false; protected static $productStamp; public static function init() { if (static::$_initialized) { return; } static::$_initialized = true; static::loadData(); } public static function validate($data) { if (!is_array($data)) { return false; } $value = (string) Moto\Util::getValue($data, 'product_id'); if (!preg_match('/^[a-z0-9]{32,}$/i', $value)) { return false; } $value = (string) Moto\Util::getValue($data, 'request_sign'); if (!preg_match('/^[a-z0-9\/\+\=\:]{8,}$/i', $value)) { return false; } $value = (string) Moto\Util::getValue($data, 'token'); if (!preg_match('/^[a-z0-9\/\+\=\:\@\.]{48,}$/i', $value)) { return false; } $value = (string) Moto\Util::getValue($data, 'template'); if (!preg_match('/^[0-9]{5,}$/', $value)) { return false; } $value = (string) Moto\Util::getValue($data, 'synced_at'); if (!preg_match('/^[0-9]{5,}$/', $value)) { return false; } return true; } public static function update($information) { if (!static::validate($information)) { return false; } static::$_data = $information; static::_updateDatabase(); static::_updateFile(); return true; } protected static function _updateDatabase() { if (!Moto\System::isDatabaseConnected()) { return false; } try { if (Moto\System\Settings::isExists('product_information')) { Moto\System\Settings::set('product_information', static::$_data); } else { Moto\System\Settings::add('product_information', static::$_data, 'array'); } } catch (\Exception $e) { if (Moto\System::isDevelopmentStage()) { Moto\System\Log::warning('Can not update "product_information" file', array( 'code' => $e->getCode(), 'message' => $e->getMessage(), )); } return false; } return true; } protected static function _updateFile() { try { $filePath = Moto\System::getAbsolutePath(static::$_filePath); if (empty($filePath)) { throw new \Exception(static::$_filePath . ':FilePathNotFound'); } $data = Moto\Util::toArray(static::$_data); $content = '<?php return ' . var_export($data, true) . ';'; try { if (function_exists('date_default_timezone_get')) { $timezone = @date_default_timezone_get(); } if (empty($timezone)) { $timezone = @ini_get('date.timezone'); } $data['_environment_'] = [ 'engine' => [ 'type' => Moto\System\Settings::getEngine()->getType(), 'build' => Moto\Version::getCurrentBuild(), 'version' => Moto\Version::getCurrentVersion(), ], 'website' => [ 'address' => Moto\Website\Settings::get('address'), 'language_code' => Moto\Website\Settings::get('language_code'), 'theme' => Moto\Website\Settings::get('theme'), 'timezone' => Moto\Website\Settings::get('timezone'), ], 'php' => [ 'PHP_VERSION_ID' => defined('PHP_VERSION_ID') ? PHP_VERSION_ID : null, 'PHP_VERSION' => defined('PHP_VERSION') ? PHP_VERSION : null, 'PHP_OS' => defined('PHP_OS') ? PHP_OS : null, 'timezone' => $timezone, ], 'database' => Arr::only(Moto\Config::get('database'), [ 'hostname', 'database', 'prefix', ]), ]; $content .= "\n/**\n" . base64_encode(json_encode($data)) . "\n*/"; } catch (\Exception $e) { } Moto\Util::filePutContents($filePath, $content); } catch (\Exception $e) { if (Moto\System::isDevelopmentStage()) { Moto\System\Log::warning('Cant update "product_information" file', array( 'code' => $e->getCode(), 'message' => $e->getMessage(), )); } return false; } return true; } public static function getProductId() { return Moto\Util::getValue(static::$_data, 'product_id', ''); } public static function getToken() { return static::getProductId() . static::DELIMITER . Moto\Util::getValue(static::$_data, 'token', ''); } public static function get($name = null, $default = null) { if ($name === null) { return static::$_data; } return Moto\Util::getValue(static::$_data, $name, $default); } public static function isExists($name) { return (Moto\Util::getValue(static::$_data, $name, null) !== null); } public static function isReady() { return is_array(static::$_data) && !empty(static::$_data['product_id']) && !empty(static::$_data['request_sign']); } public static function loadData() { if (static::$_data) { return true; } $data = Moto\System\Settings::get('product_information'); if (is_array($data)) { static::$_data = $data; return true; } $data = static::getFromFile(); if (!static::validate($data)) { return false; } static::$_data = $data; static::_updateDatabase(); return true; } public static function getFromFile() { $filePath = Moto\System::getAbsolutePath(static::$_filePath); if (!file_exists($filePath)) { return null; } $lvl = error_reporting(); $data = null; try { $data = include $filePath; } catch (\Exception $e) { } error_reporting($lvl); if (!static::validate($data)) { return null; } return $data; } public static function encryptMessage($rawMessage, $method = Moto\System\Encryption::METHOD_JSON) { if ($method === null) { $method = Moto\System\Encryption::METHOD_JSON; } $sign = Moto\System\ProductInformation::get('request_sign'); if (empty($sign)) { throw new Moto\System\Exception(static::ERROR_REQUEST_SIGN_IS_EMPTY); } $message = Moto\System\Encryption::encrypt($rawMessage, $method, $sign); if (empty($message)) { throw new Moto\System\Exception(static::ERROR_CANT_ENCRYPT_MESSAGE); } return $message; } public static function getProductStamp() { if (static::$productStamp !== null) { return static::$productStamp; } if (!static::isReady() || !Moto\System::isInstalled()) { return false; } $dir = null; if (defined('WEBSITE_DIR')) { $dir = WEBSITE_DIR; } elseif (defined('WEBSITE_ADMIN_DIR')) { $dir = dirname(WEBSITE_ADMIN_DIR); } static::$productStamp = [ 'time' => time(), 'product_id' => static::getProductId(), 'product' => [ 'id' => static::getProductId(), 'brand' => Moto\System\Brand::getInstance()->getName(), 'template' => static::get('template'), 'token' => static::get('token'), ], 'engine' => [ 'type' => Moto\System\Settings::getEngine()->getType(), 'build' => Moto\Version::getCurrentBuild(), 'version' => Moto\Version::getCurrentVersion(), ], 'updater' => [ 'build' => Moto\Update\Upgrade::BUILD, 'version' => Moto\Update\Upgrade::VERSION, ], 'website' => [ 'dir' => $dir, 'address' => Moto\Website\Settings::get('address'), 'language_code' => Moto\Website\Settings::get('language_code'), 'theme' => Moto\Website\Settings::get('theme'), 'timezone' => Moto\Website\Settings::get('timezone'), ], ]; static::$productStamp = array_merge(static::$productStamp, static::getEnvironment()); return static::$productStamp; } public static function getEnvironment() { $timezone = null; if (function_exists('date_default_timezone_get')) { $timezone = @date_default_timezone_get(); } if (empty($timezone)) { $timezone = @ini_get('date.timezone'); } return [ 'php' => [ 'PHP_VERSION_ID' => defined('PHP_VERSION_ID') ? PHP_VERSION_ID : null, 'PHP_VERSION' => defined('PHP_VERSION') ? PHP_VERSION : null, 'PHP_OS' => defined('PHP_OS') ? PHP_OS : null, 'timezone' => $timezone, 'memory_limit' => @ini_get('memory_limit'), 'post_max_size' => @ini_get('post_max_size'), 'upload_max_filesize' => @ini_get('upload_max_filesize'), 'apc.enabled' => @ini_get('apc.enabled'), 'opcache.enable' => @ini_get('opcache.enable'), 'wincache.fcenabled' => @ini_get('wincache.fcenabled'), 'wincache.ucenabled' => @ini_get('wincache.ucenabled'), ], 'mysql' => Moto\Util::arrayOnly((array) Moto\System::getDatabaseInformation(), ['driverName', 'serverVersion', 'clientVersion']), 'server' => Arr::only($_SERVER, [ 'DOCUMENT_ROOT', 'HOME', 'HOSTNAME', 'HTTP_HOST', 'PHP_SELF', 'REQUEST_SCHEME', 'REQUEST_URI', 'SCRIPT_FILENAME', 'SERVER_ADDR', 'SERVER_NAME', 'SERVER_PROTOCOL', 'SERVER_SOFTWARE', ]), ]; } } 