<?php
namespace Moto\System; use Moto; class Response { protected $_statusCode = 200; protected $_content = ''; protected $_cookies = array(); protected $_headers = array( ); protected $_httpStatusCodes = array( 100 => 'Continue', 101 => 'Switching Protocols', 102 => 'Processing', 105 => 'Name Not Resolved', 200 => 'OK', 201 => 'Created', 202 => 'Accepted', 203 => 'Non-Authoritative Information', 204 => 'No Content', 205 => 'Reset Content', 206 => 'Partial Content', 207 => 'Multi-status', 208 => 'Already Reported', 226 => 'IM Used', 300 => 'Multiple Choices', 301 => 'Moved Permanently', 302 => 'Found', 303 => 'See Other', 304 => 'Not Modified', 305 => 'Use Proxy', 306 => 'Switch Proxy', 307 => 'Temporary Redirect', 308 => 'Permanent Redirect', 400 => 'Bad Request', 401 => 'Unauthorized', 402 => 'Payment Required', 403 => 'Forbidden', 404 => 'Not Found', 405 => 'Method Not Allowed', 406 => 'Not Acceptable', 407 => 'Proxy Authentication Required', 408 => 'Request Time-out', 409 => 'Conflict', 410 => 'Gone', 411 => 'Length Required', 412 => 'Precondition Failed', 413 => 'Request Entity Too Large', 414 => 'Request-URI Too Large', 415 => 'Unsupported Media Type', 416 => 'Requested Range Not Satisfiable', 417 => 'Expectation Failed', 418 => 'I\'m a teapot', 419 => 'Authentication Timeout', 422 => 'Unprocessable Entity', 423 => 'Locked', 424 => 'Failed Dependency', 425 => 'Unordered Collection', 426 => 'Upgrade Required', 428 => 'Precondition Required', 429 => 'Too Many Requests', 431 => 'Request Header Fields Too Large', 434 => 'Requested host unavailable', 440 => 'Login Timeout', 444 => 'No Response', 449 => 'Retry With', 450 => 'Blocked by Windows Parental Controls', 451 => 'Unavailable For Legal Reasons', 456 => 'Unrecoverable Error', 500 => 'Internal Server Error', 501 => 'Not Implemented', 502 => 'Bad Gateway', 503 => 'Service Unavailable', 504 => 'Gateway Time-out', 505 => 'HTTP Version not supported', 506 => 'Variant Also Negotiates', 507 => 'Insufficient Storage', 508 => 'Loop Detected', 509 => 'Bandwidth Limit Exceeded', 510 => 'Not Extended', 511 => 'Network Authentication Required', ); public function setStatusCode($code) { $this->_statusCode = (int)$code; return $this; } public function getStatusCode() { return $this->_statusCode; } public function httpCodeToString($code, $default = null) { return (array_key_exists($code, $this->_httpStatusCodes) ? $this->_httpStatusCodes[$code] : $default); } public function isNotFound() { return (404 === $this->getStatusCode()); } public function isRedirect() { $code = $this->getStatusCode(); return (300 <= $code && $code < 400); } public function isSuccess() { $code = $this->getStatusCode(); return (200 <= $code && $code < 300); } public function setHeader($name, $value) { $this->_headers[$name] = $value; return $this; } public function getHeader($name, $default = null) { return (array_key_exists($name, $this->_headers) ? $this->_headers[$name] : $default); } public function getHeaders() { return $this->_headers; } public function sendHeaders() { if (headers_sent()) { return; } $this->httpResponseCode($this->getStatusCode()); foreach ($this->_headers as $name => $value) { header($name . ':' . $value); } if (!empty($this->_cookies)) { foreach ($this->_cookies as $name => $cookie) { @setcookie($cookie['name'], $cookie['value'], $cookie['expire'], $cookie['path'], $cookie['domain'], $cookie['secure'], $cookie['httponly']); } } } public function httpResponseCode($code = null) { if (function_exists('http_response_code')) { return http_response_code((int)$code); } $code = (int)$code; if ($code < 0 || headers_sent()) { return $this->getStatusCode(); } $header = (isset($_SERVER['SERVER_PROTOCOL']) ? $_SERVER['SERVER_PROTOCOL'] : 'HTTP/1.0'); $header .= ' ' . $code; if (array_key_exists($code, $this->_httpStatusCodes)) { $header .= ' ' . $this->_httpStatusCodes[$code]; } header($header); return $code; } public function setContent($content) { $this->_content = $content; return $this; } public function getContent() { return $this->_content; } public function setCookie($name, $value = null, $expire = null, $path = null, $domain = null, $secure = null, $httponly = null) { $this->_cookies[$name] = array( 'name' => $name, 'value' => $value, 'expire' => $expire, 'path' => $path, 'domain' => $domain, 'secure' => $secure, 'http' => $httponly, ); return $this; } public function getCookie($name, $default = null) { return (array_key_exists($name, $this->_cookies) ? $this->_cookies[$name]['value'] : $default); } public function getCookies() { return $this->_cookies; } public function redirect($path, $code = 301) { $this->setStatusCode($code); $this->setHeader('Location', $path); return $this; } public function notFound() { $this->setStatusCode(404); return $this; } public function toString() { if (Moto\Version::getCurrentBuild() > 26) { Moto\Hook::trigger(Moto\Hook::SYSTEM_RESPONSE_RENDER, $this); } $this->sendHeaders(); $content = $this->getContent(); if (is_object($content) && method_exists($content, '__toString')) { $content = $content->__toString(); } return $content; } public function __toString() { return $this->toString(); } } 