<?php
 namespace Moto\System\Task; use Illuminate; use Illuminate\Contracts\Support\Arrayable; use Illuminate\Contracts\Support\Jsonable; use Illuminate\Database\Eloquent\JsonEncodingException; use JsonSerializable; use Moto; class ExecutingResult implements Arrayable, Jsonable, JsonSerializable { const TYPE__COMPLETED = 'completed'; const TYPE__NEED_REPEAT = 'repeating'; const TYPE__ERROR = 'error'; protected $attributes = [ 'type' => null, 'completed' => false, 'response' => null, 'needRepeat' => false, 'error' => null, ]; public function __construct(array $attributes = []) { $this->attributes = array_merge($this->attributes, $attributes); } public function getAttribute($name, $default = null) { if (array_key_exists($name, $this->attributes)) { return $this->attributes[$name]; } return $default; } public function setAttribute($name, $value) { if (!is_string($name) || $name === '') { throw new \InvalidArgumentException('Invalid name'); } $this->attributes[$name] = $value; return $this; } public function isCompleted() { return $this->getAttribute('completed'); } public function isNeedRepeat() { return $this->getAttribute('needRepeat'); } public function needRepeat($mode = true) { return $this->setAttribute('needRepeat', (boolean) $mode); } public function isError() { return (boolean) $this->getError(); } public function getError() { return $this->getAttribute('error'); } public function getResponse() { return $this->getAttribute('response'); } public function toArray() { return $this->attributes; } public function jsonSerialize() { return $this->toArray(); } public function toJson($options = 0) { $json = json_encode($this->jsonSerialize(), $options); if (JSON_ERROR_NONE !== json_last_error()) { throw new JsonEncodingException('Error encoding model [' . get_class($this) . '] to JSON: ' . json_last_error_msg()); } return $json; } } 