<?php
 namespace Moto\System\Task; use Moto; use Illuminate; use Closure; use Ramsey\Uuid\Uuid; class TaskManager extends Illuminate\Queue\QueueManager { const CONNECTION_NAME = 'task'; public function getConnectionName() { return static::CONNECTION_NAME; } public function getRetryAfterCooldown() { return $this->getConfig($this->getConnectionName())['retry_after']; } public function __construct($app) { parent::__construct($app); return; $this->before(function (Illuminate\Queue\Events\JobProcessing $event) { \Moto\System\Log::debug(__METHOD__ . " # " . __LINE__ . ' : ' . get_class($event)); return; echo "\n\n"; $eventJob = $event->job; echo '# Before $event => ' . get_class($event) . ' job ' . get_class($event->job) . "\n"; echo "\n\n"; }); $this->after(function (Illuminate\Queue\Events\JobProcessed $event) { \Moto\System\Log::debug(__METHOD__ . " # " . __LINE__ . ' : ' . get_class($event)); return; echo "\n\n"; echo '# After event => ' . get_class($event) . ' job ' . get_class($event->job) . "\n"; echo "\n\n"; }); $this->failing(function (Illuminate\Queue\Events\JobFailed $event) { \Moto\System\Log::debug(__METHOD__ . " # " . __LINE__ . ' : ' . get_class($event)); return; echo "\n\n"; echo '# Failed event => ' . get_class($event) . ' job ' . get_class($event->job) . "\n"; echo "\n\n"; }); } public function addTask($task) { if ($task instanceof Moto\System\Task\TaskWrapper) { $task = $task->getMainTask(); } if (!$task instanceof Moto\System\Task\AbstractTask) { throw new Moto\Exception('Task not compatible'); } if ($task->isPushed()) { throw new Moto\Exception('Task already pushed'); } $queue = $task->getQueue(); if (empty($queue)) { throw new Moto\Exception('Task not has queue name'); } $database = Moto\Database\Provider::getConnection(); $database->beginTransaction(); $id = $this->pushOn($queue, $task); if (empty($id)) { throw new Moto\Exception('Task is not pushed'); } $task->pushed($id); $database->commit(); return $task->getStateModel(); } } 