<?php
 namespace Moto\System\Task; use Moto; use Illuminate; use Closure; use Ramsey\Uuid\Uuid; class TaskStateRepository { protected $manager; protected $collection; public function __construct($manager) { $this->manager = $manager; } protected function getCollection() { if (!$this->collection) { $this->collection = new Illuminate\Support\Collection(); } return $this->collection; } public function getOrCreate(Moto\System\Task\AbstractTask $task) { $queue = $task->getQueue(); $collection = $this->getCollection(); $model = $collection->get($queue); if ($model) { return $model; } $query = Moto\System\Task\Database\JobTaskState::query(); $model = $query->firstOrCreate([ 'queue' => $queue, ]); if (!$model->exists) { $user = Moto\System::getUser(); $model->fill([ 'queue' => $task->getQueue(), 'build' => Moto\Version::getBuild(), 'created_by' => ($user ? $user->id : null), ]); } if ($model) { $collection->offsetSet($queue, $model); } return $model; } public function getByQueue($queue) { $collection = $this->getCollection(); $model = $collection->get($queue); if ($model) { return $model; } $query = Moto\System\Task\Database\JobTaskState::query(); $model = $query->where([ 'queue' => $queue, ])->first(); if ($model) { $collection->offsetSet($queue, $model); } return $model; } public function createNew($queue, array $attributes = []) { $model = $this->getByQueue($queue); if ($model) { return false; } try { $model = new Moto\System\Task\Database\JobTaskState([ 'queue' => $queue, ]); $model->fill($attributes); $this->getCollection()->offsetSet($queue, $model); return $model; } catch (\Exception $e) { Moto\System\Log::error('[TaskStateRepository] : Cant create task state => ' . print_r([ 'code' => $e->getCode(), 'message' => $e->getMessage(), 'trace' => (Moto\System::isDevelopmentStage() ? $e->getTrace() : null), ], true)); } return false; } } 