<?php
 namespace Moto\System\Traits; use Illuminate; use Illuminate\Support\Arr; use Illuminate\Support\Str; use Moto; trait OptionsTrait { public function getOptions($keys = null) { if ($keys === null) { return $this->_options; } return Arr::only($this->_options, $keys); } public function setOptions($options) { if (!is_array($options) && !is_object($options)) { throw new Moto\Exception('Invalid argument "options"'); } foreach ($options as $name => $value) { $this->setOption($name, $value); } } public function setOption($name, $value) { if (!is_string($name)) { throw new Moto\Exception('Invalid argument "name"'); } $method = 'set' . Str::studly($name) . 'Option'; if (method_exists($this, $method)) { $result = $this->{$method}($value); if ($result === false) { throw new Moto\Exception('Invalid option "' . $name . '"'); } return $result; } return $this->setOptionRawValue($name, $value); } protected function setOptionRawValue($name, $value) { if (!is_string($name)) { throw new Moto\Exception('Invalid argument "name"'); } Arr::set($this->_options, $name, $value); return $this; } public function hasOption($name) { if (!is_string($name)) { throw new Moto\Exception('Invalid argument "name"'); } return array_key_exists($name, $this->_options); } public function getOption($name, $default = null) { if (!is_string($name)) { throw new Moto\Exception('Invalid argument "name"'); } $method = 'get' . Str::studly($name) . 'Option'; if (method_exists($this, $method)) { return $this->{$method}($default); } return $this->getOptionRawValue($name, $default); } public function requireOption($name) { $value = $this->getOption($name); if (empty($value)) { throw new Moto\Exception('Option "' . $name . '" is required'); } return $value; } protected function getOptionRawValue($name, $default = null) { if (!is_string($name)) { throw new Moto\Exception('Invalid argument "name"'); } return Arr::get($this->_options, $name, $default); } } 