<?php
namespace Moto\System; use Moto; class UpdateManager { const ERROR_BAD_RESPONSE_MESSAGE = 'ERROR_BAD_RESPONSE_MESSAGE'; const ERROR_BAD_RESPONSE_CODE = 500; protected static $_releaseInfoFile = 'release.json'; protected static $_remoteUpdateRequest = array( 'httpMethod' => 'GET', 'postLikeJson' => false, 'checking' => null, ); public static function getPluginsUpdates($items) { if (!is_array($items)) { return false; } $response = static::_sendRequest(array(), $items); return Moto\Util::getValue($response, 'body.updates.plugins'); } public static function getPluginUpdates($target, $version = null, $build = null) { $result = null; if ($target instanceof Moto\System\Plugins\PluginItem) { $target = $target->toArray(); } if (is_array($target)) { $build = Moto\Util::getValue($target, 'build'); $version = Moto\Util::getValue($target, 'version'); $name = Moto\Util::getValue($target, 'name'); } else { $name = (string) $target; } if (empty($version)) { $plugin = Moto\System\PluginManager::findLocalPluginByName($name); $version = $plugin->getVersion(); $build = $plugin->getBuild(); } $updates = static::getPluginsUpdates(array( array( 'name' => $name, 'version' => $version, 'build' => $build, ) )); if (!is_array($updates)) { return $result; } $updates = (array) $updates; if (array_key_exists($name, $updates)) { $result = $updates[$name]; } else { foreach ($updates as $update) { if (Moto\Util::getValue($update, 'name') === $name) { $result = $update; break; } } } return $result; } public static function getPluginNextUpdate($name, $version = null, $build = null) { return Moto\Util::getValue(static::getPluginUpdates($name, $version, $build), 'next'); } public static function getPluginLastUpdate($name, $version = null, $build = null) { return Moto\Util::getValue(static::getPluginUpdates($name, $version, $build), 'last'); } public static function getThemesUpdates($items) { if (!is_array($items)) { return false; } $response = static::_sendRequest($items, array()); return Moto\Util::getValue($response, 'body.updates.themes'); } public static function getThemeUpdates($theme, $template = null, $version = null, $build = null) { $result = null; if (is_array($theme)) { $build = Moto\Util::getValue($theme, 'build'); $version = Moto\Util::getValue($theme, 'version'); $template = Moto\Util::getValue($theme, 'template_id'); $theme = Moto\Util::getValue($theme, 'name'); } if (!is_string($theme) || $theme === '') { return $result; } $updates = static::getThemesUpdates(array( array( 'theme' => $theme, 'template_id' => $template, 'version' => $version, 'build' => $build, ) )); if (!is_array($updates)) { return $result; } if (array_key_exists($theme, $updates)) { $result = $updates[$theme]; } else { } return $result; } public static function getThemeNextUpdate($theme, $template = null, $version = null, $build = null) { return Moto\Util::getValue(static::getThemeUpdates($theme, $template, $version, $build), 'next'); } public static function getThemeLastUpdate($theme, $template = null, $version = null, $build = null) { return Moto\Util::getValue(static::getThemeUpdates($theme, $template, $version, $build), 'last'); } public static function getAllUpdates() { if (!Moto\Config::get('externalModules.accounts.productUpdater.url')) { return null; } $theme = Moto\Website\Settings::get('theme'); $themeInfo = Moto\Util::arrayOnly(Moto\Website\Theme::getInfo($theme), array('name', 'template_id', 'version', 'build')); $themeInfo['theme'] = $themeInfo['name']; unset($themeInfo['name']); $plugins = null; if (Moto\Config::get('externalModules.accounts.productUpdater.checkPlugins')) { $plugins = Moto\System\PluginManager::getUpdateList(); } $response = static::_sendRequest(array($themeInfo), $plugins); if (!is_array($response)) { throw new Moto\Exception(static::ERROR_BAD_RESPONSE_MESSAGE, static::ERROR_BAD_RESPONSE_CODE); } $releaseInfoFilePath = Moto\System::getAbsolutePath('@updateTemp/' . static::$_releaseInfoFile); if ((file_exists($releaseInfoFilePath) && is_writable($releaseInfoFilePath)) || is_writable(Moto\System::getAbsolutePath('@updateTemp'))) { Moto\Util::filePutContents($releaseInfoFilePath, json_encode($response, JSON_PRETTY_PRINT)); } return Moto\Util::getValue($response, 'body'); } protected static function _sendRequest($themes = array(), $plugins = array()) { $options = Moto\Config::get('externalModules.accounts.productUpdater'); if (!is_array($options)) { return null; } $url = Moto\Util::getValue($options, 'url'); if (empty($url)) { return null; } $user = Moto\System::getUser(); $request = array( 'isDummy' => Moto\Util::getValue($options, 'isDummy', false), 'isBeta' => Moto\Util::getValue($options, 'isBeta', false), 'product_id' => Moto\System\ProductInformation::getProductId(), 'token' => Moto\System\ProductInformation::get('token'), 'engine' => array( 'version' => Moto\System\Settings::get('version'), 'build' => Moto\System\Settings::get('build'), ), 'user' => Moto\Util::arrayOnly(($user instanceof Moto\Database\Models\User) ? $user->toArray() : (array) $user, array('language_locale',)), 'themes' => is_array($themes) ? $themes : array(), ); if (is_array($plugins) && count($plugins)) { $request['plugins'] = $plugins; } if (Moto\System::isDevelopmentStage()) { } $request = Moto\System\ProductInformation::encryptMessage($request); $requestParams = array( 'product_id' => Moto\System\ProductInformation::getProductId(), 'request' => $request, ); $client = new Moto\Http\Client(); $httpMethod = Moto\Util::getValue($options, 'httpMethod', 'GET'); if ($httpMethod === 'POST') { $client->setMethod($httpMethod); $client->setParameterPost($requestParams); } else { $client->setParameterGet($requestParams); } $client->setUri($url); static::_updateHttpClient($client); $client->send(); if ($client->hasErrors()) { throw new Moto\Exception(Moto\System\Exception::ERROR_BAD_REQUEST_MESSAGE, Moto\System\Exception::ERROR_BAD_REQUEST_CODE, $client->getErrors()); } $client->getAdapter()->close(); $body = $client->getResponse()->getBody(); $response = json_decode($body, true); if (!is_array($response) || !Moto\Util::getValue($response, 'status', false) || !is_array(Moto\Util::getValue($response, 'body'))) { throw new Moto\Exception(static::ERROR_BAD_RESPONSE_MESSAGE, static::ERROR_BAD_RESPONSE_CODE); } return $response; } protected static function _updateHttpClient($client) { if (!$client) { return false; } try { $headers = $client->getRequest()->getHeaders(); } catch (\Exception $e) { } return true; } } 