<?php
namespace Moto\System\Widgets; use Moto; use Zend\Loader\SplAutoloader; use Zend\Filter\Word\CamelCaseToUnderscore; class Autoloader implements SplAutoloader { const VERSION = 1; protected $paths = array(); protected $_filter = null; protected static $_classPrefix = 'Website\Widgets\\'; protected static $_instance; protected static $_classMap = array(); public function __construct($options = null) { if (null !== $options) { $this->setOptions($options); } static::$_instance = $this; } public function setOptions($options) { if (!is_array($options) && !($options instanceof \Traversable)) { throw new \InvalidArgumentException(); } if (!empty($options['paths'])) { foreach ($options['paths'] as $path) { if (!in_array($path, $this->paths)) { $this->paths[] = $path; } } } return $this; } protected function _getFilter() { if (null === $this->_filter) { $this->_filter = new CamelCaseToUnderscore(); } return $this->_filter; } protected function _convertToFolder($name) { $name = $this->_getFilter()->filter($name); $name = strtolower($name); return $name; } public function autoload($class) { if (0 !== strpos($class, static::$_classPrefix)) { return false; } if (class_exists($class, false)) { return true; } $file = Moto\Util::getFrom(static::$_classMap, $class); if (!empty($file)) { $file = Moto\System::getAbsolutePath($file); if (file_exists($file)) { return include $file; } } Moto\Hook::trigger(Moto\Hook::WIDGET_AUTO_LOADER__LOAD_CLASS, $class, $this); if (class_exists($class, false)) { return true; } $widgetFolder = $widgetClass = null; $pos = strpos($class, static::$_classPrefix); if ($pos !== false) { $classParts = substr($class, strlen(static::$_classPrefix)); if (preg_match('/^([^\\\]+)\\\(.+)$/', $classParts, $match)) { $widgetFolder = $this->_convertToFolder($match[1]); $widgetClass = $match[2]; } } $filename = $widgetFolder . DIRECTORY_SEPARATOR . 'library' . DIRECTORY_SEPARATOR . str_replace('\\', DIRECTORY_SEPARATOR, $widgetClass) . '.php'; foreach ($this->paths as $path) { $filePath = $path . DIRECTORY_SEPARATOR . $filename; if (file_exists($filePath)) { return include($filePath); } } if (class_exists($class)) { return true; } return false; } public function register() { spl_autoload_register(array($this, 'autoload')); } public static function addToMap($class, $file) { if (!is_string($class) || !is_string($file)) { return false; } static::$_classMap[$class] = $file; return true; } public static function importMap($map) { if (!is_array($map)) { return false; } foreach ($map as $class => $path) { static::addToMap($class, $path); } return true; } public static function getClassPrefix() { return static::$_classPrefix; } public static function loadWidgetClass($class, $file = null) { if (!is_string($class)) { return false; } if (class_exists($class, false)) { return true; } if (!empty($file) && is_string($file)) { $file = Moto\System::getAbsolutePath($file); if (file_exists($file)) { include_once $file; if (class_exists($class, false)) { return true; } } } return static::getInstance()->autoload($class); } public static function getInstance() { if (static::$_instance === null) { static::$_instance = new self(); } return static::$_instance; } } 