<?php
 namespace Moto\System\Widgets; use Moto; use Moto\Facades\WebsitePackages; use Twig_Environment; use Website; use Zend\Stdlib\ArrayUtils; Factory::init(); class Factory { const VERSION = 1; protected static $_classMap = array( 'audio_player' => 'Website\Widgets\AudioPlayer\Widget', 'auth_form' => 'Website\Widgets\AuthForm\Widget', 'block' => 'Website\Widgets\Block\Widget', 'blog.post_author' => 'Website\Widgets\Blog\PostAuthorWidget', 'blog.post_comments' => 'Website\Widgets\Blog\PostCommentsWidget', 'blog.post_content' => 'Website\Widgets\Blog\PostContentWidget', 'blog.post_list' => 'Website\Widgets\Blog\PostListWidget', 'blog.post_name' => 'Website\Widgets\Blog\PostNameWidget', 'blog.post_published_on' => 'Website\Widgets\Blog\PostPublishedOnWidget', 'blog.recent_posts' => 'Website\Widgets\Blog\RecentPostsWidget', 'blog.post_tags' => 'Website\Widgets\Blog\PostTagsWidget', 'blog.tag_name' => 'Website\Widgets\Blog\TagNameWidget', 'blog.calendar' => 'Website\Widgets\Blog\CalendarWidget', 'button' => 'Website\Widgets\Button\Widget', 'carousel' => 'Website\Widgets\Carousel\Widget', 'contact_form' => 'Website\Widgets\ContactForm\Widget', 'container' => 'Website\Widgets\Container\Widget', 'countdown' => 'Website\Widgets\Countdown\Widget', 'disqus' => 'Website\Widgets\Disqus\Widget', 'divider_horizontal' => 'Website\Widgets\DividerHorizontal\Widget', 'embed' => 'Website\Widgets\Embed\Widget', 'facebook_page_plugin' => 'Website\Widgets\Facebook\PagePluginWidget', 'grid_gallery' => 'Website\Widgets\GridGallery\Widget', 'iframe' => 'Website\Widgets\Iframe\Widget', 'image' => 'Website\Widgets\Image\Widget', 'mail_chimp' => 'Website\Widgets\MailChimp\Widget', 'map' => 'Website\Widgets\Map\Widget', 'menu' => 'Website\Widgets\Menu\Widget', 'pinterest' => 'Website\Widgets\Pinterest\Widget', 'row' => 'Website\Widgets\Row\Widget', 'row.column' => 'Website\Widgets\Row\ColumnWidget', 'section' => 'Website\Widgets\Section\Widget', 'slider' => 'Website\Widgets\Slider\Widget', 'slideshare' => 'Website\Widgets\Slideshare\Widget', 'social_buttons' => 'Website\Widgets\SocialButtons\Widget', 'social_links' => 'Website\Widgets\SocialLinks\Widget', 'sound_cloud' => 'Website\Widgets\SoundCloud\Widget', 'spacer' => 'Website\Widgets\Spacer\Widget', 'text' => 'Website\Widgets\Text\Widget', 'twitter.time_line' => 'Website\Widgets\Twitter\TimeLineWidget', 'video' => 'Website\Widgets\Video\Widget', 'video_player' => 'Website\Widgets\VideoPlayer\Widget', ); protected static $_resolvedWidgets = array(); protected static $_widgetsInfo = array( 'audio_player' => array( 'preRender' => array( 'type' => 'template', ), ), 'auth_form' => array( 'preRender' => array(), ), 'block' => array( 'preRender' => array( 'type' => 'template', ), ), 'blog.applied_filters' => array( 'preRender' => array(), 'renderClass' => Website\Widgets\Blog\AppliedFiltersWidget::class, ), 'blog.category_description' => array( 'preRender' => array(), 'renderClass' => Website\Widgets\Blog\CategoryDescriptionWidget::class, ), 'blog.category_list' => array( 'preRender' => array(), 'renderClass' => Website\Widgets\Blog\CategoryListWidget::class, ), 'blog.category_name' => array( 'preRender' => array(), 'renderClass' => Website\Widgets\Blog\CategoryNameWidget::class, ), 'blog.post_author' => array( 'preRender' => array(), 'renderClass' => Website\Widgets\Blog\PostAuthorWidget::class, ), 'blog.post_category' => array( 'preRender' => array(), 'renderClass' => Website\Widgets\Blog\PostCategoryWidget::class, ), 'blog.post_comments' => array( 'preRender' => array(), 'renderClass' => Website\Widgets\Blog\PostCommentsWidget::class, ), 'blog.filters' => array( 'preRender' => array(), 'renderClass' => Website\Widgets\Blog\FiltersWidget::class, ), 'blog.post_content' => array( 'preRender' => array(), 'renderClass' => Website\Widgets\Blog\PostContentWidget::class, ), 'blog.post_list' => array( 'preRender' => array(), 'renderClass' => Website\Widgets\Blog\PostListWidget::class, ), 'blog.post_name' => array( 'preRender' => array(), 'renderClass' => Website\Widgets\Blog\PostNameWidget::class, ), 'blog.post_published_on' => array( 'preRender' => array(), 'renderClass' => Website\Widgets\Blog\PostPublishedOnWidget::class, ), 'blog.post_tags' => array( 'preRender' => array(), 'renderClass' => Website\Widgets\Blog\PostTagsWidget::class, ), 'blog.post_taxonomy' => array( 'preRender' => array(), 'renderClass' => Website\Widgets\Blog\PostTaxonomyWidget::class, ), 'blog.recent_posts' => array( 'preRender' => array(), 'renderClass' => Website\Widgets\Blog\RecentPostsWidget::class, ), 'blog.search' => array( 'preRender' => array(), 'renderClass' => Website\Widgets\Blog\SearchWidget::class, ), 'blog.tag_description' => array( 'preRender' => array(), 'renderClass' => Website\Widgets\Blog\TagDescriptionWidget::class, ), 'blog.tag_list' => array( 'preRender' => array(), 'renderClass' => Website\Widgets\Blog\TagListWidget::class, ), 'blog.tag_name' => array( 'preRender' => array(), 'renderClass' => Website\Widgets\Blog\TagNameWidget::class, ), 'blog.taxonomy_description' => array( 'preRender' => array(), 'renderClass' => Website\Widgets\Blog\TaxonomyDescriptionWidget::class, ), 'blog.taxonomy_list' => array( 'preRender' => array(), 'renderClass' => Website\Widgets\Blog\TaxonomyListWidget::class, ), 'blog.taxonomy_name' => array( 'preRender' => array(), 'renderClass' => Website\Widgets\Blog\TaxonomyNameWidget::class, ), 'blog.calendar' => array( 'preRender' => array(), 'renderClass' => Website\Widgets\Blog\CalendarWidget::class, ), 'breadcrumbs' => array( 'name' => 'breadcrumbs', 'folder' => '@websiteWidgets/breadcrumbs/', 'renderClass' => 'Website\Widgets\Breadcrumbs\Widget', 'renderFile' => '@websiteWidgets/breadcrumbs/library/Widget.php', 'preRender' => array(), ), 'button' => array( 'name' => 'button', 'folder' => '@websiteWidgets/button/', 'renderClass' => Website\Widgets\Button\Widget::class, 'renderFile' => '@websiteWidgets/button/library/Widget.php', 'preRender' => array( 'type' => 'template', ), 'validation' => array( 'enabled' => true, 'instance' => true, 'class' => Website\Widgets\Button\Validator::class, 'file' => '@websiteWidgets/button/library/Validator.php', ), ), 'carousel' => array( 'preRender' => array(), ), 'contact_form' => array( 'preRender' => array(), ), 'container' => array( 'preRender' => array( 'type' => 'template', ), ), 'content_slider' => array( 'name' => 'content_slider', 'folder' => '@websiteWidgets/content_slider/', 'renderClass' => 'Website\Widgets\ContentSlider\SliderWidget', 'renderFile' => '@websiteWidgets/content_slider/library/SliderWidget.php', 'preRender' => array(), ), 'content_slider.item' => array( 'name' => 'content_slider.item', 'folder' => '@websiteWidgets/content_slider/', 'renderClass' => 'Website\Widgets\ContentSlider\ItemWidget', 'renderFile' => '@websiteWidgets/content_slider/library/ItemWidget.php', 'preRender' => array(), ), 'countdown' => array( 'preRender' => array(), ), 'disqus' => array( 'preRender' => array(), ), 'divider_horizontal' => array( 'preRender' => array( 'type' => 'template', ), ), 'embed' => array( 'preRender' => array( 'type' => 'macros', ), ), 'facebook_page_plugin' => array( 'preRender' => array( 'type' => 'template', ), ), 'form_elements.attachment' => [ 'preRender' => [], 'renderClass' => Website\Widgets\FormElements\AttachmentWidget::class, ], 'form_elements.button_submit' => [ 'preRender' => [], 'renderClass' => Website\Widgets\FormElements\ButtonSubmitWidget::class, ], 'form_elements.checkbox' => [ 'preRender' => [], 'renderClass' => Website\Widgets\FormElements\CheckboxWidget::class, ], 'form_elements.hidden_input' => [ 'preRender' => [], 'renderClass' => Website\Widgets\FormElements\HiddenInputWidget::class, ], 'form_elements.input' => [ 'preRender' => [], 'renderClass' => Website\Widgets\FormElements\InputWidget::class, ], 'form_elements.label' => [ 'preRender' => [], 'renderClass' => Website\Widgets\FormElements\LabelWidget::class, ], 'form_elements.radio_buttons' => [ 'preRender' => [], 'renderClass' => Website\Widgets\FormElements\RadioButtonsWidget::class, ], 'form_elements.recaptcha' => [ 'preRender' => [], 'renderClass' => Website\Widgets\FormElements\RecaptchaWidget::class, ], 'form_elements.select' => [ 'preRender' => [], 'renderClass' => Website\Widgets\FormElements\SelectWidget::class, ], 'form_elements.status_message' => [ 'preRender' => [], 'renderClass' => Website\Widgets\FormElements\StatusMessageWidget::class, ], 'form_elements.textarea' => [ 'preRender' => [], 'renderClass' => Website\Widgets\FormElements\TextareaWidget::class, ], 'grid_gallery' => array( 'preRender' => array(), ), 'google_search.box' => array( 'name' => 'google_search.box', 'folder' => '@websiteWidgets/google_search/', 'renderClass' => 'Website\Widgets\GoogleSearch\BoxWidget', 'renderFile' => '@websiteWidgets/google_search/library/BoxWidget.php', ), 'google_search.results' => array( 'name' => 'google_search.results', 'folder' => '@websiteWidgets/google_search/', 'renderClass' => 'Website\Widgets\GoogleSearch\ResultsWidget', 'renderFile' => '@websiteWidgets/google_search/library/ResultsWidget.php', ), 'iframe' => array( 'preRender' => array( 'type' => 'template', ), ), 'image' => array( 'name' => 'image', 'folder' => '@websiteWidgets/image/', 'renderClass' => 'Website\Widgets\Image\Widget', 'renderFile' => '@websiteWidgets/image/library/Widget.php', 'preRender' => array(), ), 'instagram.post' => array( 'name' => 'instagram.post', 'folder' => '@websiteWidgets/instagram/', 'renderClass' => 'Website\Widgets\Instagram\PostWidget', 'renderFile' => '@websiteWidgets/instagram/library/PostWidget.php', ), 'integrations.airbnb' => array( 'name' => 'integrations.airbnb', 'folder' => '@websiteWidgets/integrations/', 'renderClass' => 'Website\Widgets\Integrations\Airbnb', 'renderFile' => '@websiteWidgets/integrations/library/AirbnbWidget.php', ), 'integrations.acuity_scheduling' => array( 'name' => 'integrations.acuity_scheduling', 'folder' => '@websiteWidgets/integrations/', 'renderClass' => 'Website\Widgets\Integrations\AcuityScheduling', 'renderFile' => '@websiteWidgets/integrations/library/AcuitySchedulingWidget.php', ), 'integrations.opentable' => array( 'name' => 'integrations.opentable', 'folder' => '@websiteWidgets/integrations/', 'renderClass' => 'Website\Widgets\Integrations\Opentable', 'renderFile' => '@websiteWidgets/integrations/library/OpentableWidget.php', ), 'mail_chimp' => array( 'preRender' => array( 'type' => 'template', ), ), 'map' => array( 'preRender' => array( 'type' => 'template', ), ), 'menu' => array( 'preRender' => array( 'type' => 'macros', ), ), 'pagination' => array( 'preRender' => array(), 'renderClass' => Website\Widgets\Pagination\PaginationWidget::class, ), 'pinterest' => array( 'preRender' => array( 'type' => 'template', ), ), 'row' => array( 'preRender' => array( 'type' => 'template', ), ), 'row.column' => array( 'preRender' => array( 'type' => 'template', ), ), 'section' => array( 'preRender' => array( 'type' => 'template', ), ), 'slider' => array( 'preRender' => array(), ), 'slideshare' => array( 'preRender' => array( 'type' => 'template', ), ), 'social_buttons' => array( 'preRender' => array(), ), 'social_links' => array( 'preRender' => array( 'type' => 'template', ), ), 'sound_cloud' => array( 'preRender' => array( 'type' => 'template', ), ), 'spacer' => array( 'preRender' => array( 'type' => 'template', ), ), 'text' => array( 'preRender' => array( 'type' => 'template', ), ), 'twitter.time_line' => array( 'preRender' => array( 'type' => 'template', ), ), 'video' => array( 'preRender' => array( 'type' => 'template', ), ), 'video_player' => array( 'preRender' => array(), ), ); protected static $_isPreRenderMode = false; protected static $_widgetValidatorInstances = array(); public static function init() { if (defined('Moto\Hook::WIDGET_FACTORY__BOOTED')) { Moto\Hook::trigger(Moto\Hook::WIDGET_FACTORY__BOOTED); } } public static function getWidgetInfo($name, $property = null, $default = null) { if ($property === null) { return (array_key_exists($name, static::$_widgetsInfo) ? static::$_widgetsInfo[$name] : null); } if (array_key_exists($name, static::$_widgetsInfo)) { return Moto\Util::getValue(static::$_widgetsInfo[$name], $property, $default); } return $default; } protected static function isValidWidgetInfo($widgetInfo) { if (!is_array($widgetInfo) || empty($widgetInfo['name']) || !is_string($widgetInfo['name'])) { return false; } if (array_key_exists('constructor', $widgetInfo)) { if (!is_callable($widgetInfo['constructor'])) { return false; } } elseif (empty($widgetInfo['renderClass']) || empty($widgetInfo['renderFile'])) { return false; } elseif (!is_string($widgetInfo['renderClass']) || !is_string($widgetInfo['renderFile'])) { return false; } return true; } public static function addWidget($widgetInfo) { if (!static::isValidWidgetInfo($widgetInfo)) { return false; } if (array_key_exists($widgetInfo['name'], static::$_widgetsInfo)) { if (!static::getWidgetInfo($widgetInfo['name'], 'allowOverwrite')) { return false; } } static::$_widgetsInfo[$widgetInfo['name']] = $widgetInfo; return true; } public static function render(Twig_Environment $twig, $widgetName, $options = array(), $context = array()) { $content = ''; $widget = null; try { if ($widgetName instanceof Moto\System\Widgets\AbstractWidget) { $widget = $widgetName; $context = $options; } else { $widget = Moto\System\Widgets\Factory::create($widgetName, $options); } if (!$widget) { Moto\System\Log::alert('WIDGET_NOT_FOUND', array('widget' => array('name' => is_string($widgetName) ? $widgetName : Moto\Util::getValue($widgetName, 'name', 'UNKNOWN')))); throw new Moto\Exception('WIDGET_NOT_FOUND'); } $widgetName = $widget->getName(); $widget->setRenderEngine($twig); if (static::isPreviewMode()) { static::_addToCache($widget); } if (static::isPreRenderMode()) { $content = static::_preRenderWidget($widget, $twig, $context); } else { if ($widget->shouldBeRendered()) { $content = static::_renderWidget($widget, $context, $twig); $content = Moto\Hook::trigger(Moto\Hook::RENDER_FILTER__PAGE_HTML_CONTENT, $content, $widget, '@widget:' . $widget->getName()); } } return $content; } catch (\Exception $e) { if (Moto\System::isDevelopmentStage()) { Moto\System\Log::debug(__CLASS__ . ':' . __FUNCTION__ . ' : Exception on rendering widget "' . is_string($widgetName) ? $widgetName : Moto\Util::getValue($widgetName, 'name', 'UNKNOWN') . '"', [ 'message' => $e->getMessage(), 'class' => get_class($e), 'line' => $e->getLine(), 'file' => basename($e->getFile()), 'code' => $e->getCode(), ]); } } if (static::isPreviewMode()) { return static::_renderBrokenWidget($twig, $widgetName, $options, $content); } return $content; } public static function createBrokenWidget($widgetName, $twig = null) { $widget = new Website\Widgets\Broken\Widget($widgetName); if ($twig) { $widget->setRenderEngine($twig); } if (static::isPreviewMode()) { static::_addToCache($widget); } return $widget; } protected static function _renderBrokenWidget(Twig_Environment $twig, $widgetName, $options = array(), $context = array()) { $content = ''; try { $widget = static::createBrokenWidget($widgetName, $twig); $content = static::_renderWidget($widget, $context, $twig); $content = Moto\Hook::trigger(Moto\Hook::RENDER_FILTER__PAGE_HTML_CONTENT, $content, $widget, '@widget:' . $widget->getName()); } catch (\Exception $e) { if (Moto\System::isDevelopmentStage()) { Moto\System\Log::debug(__CLASS__ . ':' . __FUNCTION__ . ' : Exception "' . $e->getMessage() . '"', array( 'code' => $e->getCode(), 'message' => $e->getMessage(), 'class' => get_class($e), )); } } return $content; } protected static function _renderWidget($widget, $context, $twig) { $template = static::_getTemplate($widget, $twig); if (!$template) { throw new \RuntimeException('TEMPLATE_NOT_FOUND'); } $widget->preRender(); if (is_object($context)) { $context = (array) $context; } elseif (!is_array($context)) { $context = array(); } $context['currentWidget'] = $widget; $context = ArrayUtils::merge($context, $widget->getRenderVariables()); $widget->beforeRendering(); $result = $template->render($context); $widget->afterRendering(); WebsitePackages::require($widget->getRequiredPackages()); return $result; } protected static function _preRenderWidget($widget, $twig, $context = array()) { $defaultType = 'macros'; if ($widget->isContainer()) { $defaultType = 'template'; } $type = static::getWidgetInfo($widget->getName(), 'preRender.type', $defaultType); $result = null; try { if ($type === 'template') { $result = static::_renderWidget($widget, $context, $twig); } } catch (\Exception $e) { } if (empty($result)) { $result = $widget->convertWidgetToMacros(); } return $result; } public static function preRender(Twig_Environment $twig, $widgetName, $options = array(), $context = array()) { $t0 = microtime(1); static::$_isPreRenderMode = true; $content = static::render($twig, $widgetName, $options, $context); static::$_isPreRenderMode = false; if (Moto\System::isDevelopmentStage()) { Moto\System\Log::debug('Factory:preRender done by ' . (microtime(1) - $t0)); } return $content; } public static function createNewWidget($widgetName, $options) { static::_resolveWidgetByName($widgetName); $widgetInfo = static::getWidgetInfo($widgetName); if (is_array($widgetInfo) && array_key_exists('constructor', $widgetInfo)) { $widget = call_user_func_array($widgetInfo['constructor'], [$widgetName, $options]); if ($widget instanceof AbstractWidget) { return $widget; } } $renderClass = static::_getWidgetClassByName($widgetName); $renderFile = static::getWidgetInfo($widgetName, 'renderFile'); if (empty($renderClass) || !Moto\System\Widgets\Autoloader::loadWidgetClass($renderClass, $renderFile)) { Moto\System\Log::alert('WIDGET_CLASS_NOT_FOUND', array( 'widgetName' => $widgetName, 'renderClass' => $renderClass, 'renderFile' => $renderFile, ) ); throw new Moto\Exception('WIDGET_CLASS_NOT_FOUND'); } $widget = new $renderClass($options); return $widget; } public static function create($widgetName, $options = array()) { $widget = null; try { if (is_array($widgetName)) { $options = $widgetName; $widgetName = $options['name']; } if ($widgetName instanceof Moto\System\Widgets\AbstractWidget) { $widget = $widgetName; $widgetName = $widget->getName(); } else { $widget = static::createNewWidget($widgetName, $options); } } catch (\Exception $e) { if (Moto\System::isDevelopmentStage()) { Moto\System\Log::debug(__CLASS__ . ':' . __FUNCTION__ . ' : Exception "' . $e->getMessage() . '"', array( 'code' => $e->getCode(), 'message' => $e->getMessage(), 'class' => get_class($e), )); } } if (!$widget && Moto\System::isDevelopmentStage()) { Moto\System\Log::debug(__CLASS__ . ':' . __FUNCTION__ . ' : Cant Create widget "' . $widgetName); } return $widget; } public static function isPreviewMode() { return Moto\System\Request::isPreviewMode(); } public static function isPreRenderMode() { return static::$_isPreRenderMode; } protected static function _addToCache(AbstractWidget $widget) { $widgetId = $widget->getWidgetId(); if (!is_string($widgetId)) { return false; } $storage = static::getCacheOptions(); if (!$storage) { return false; } if ($storage->exists($widgetId)) { if (Moto\System::isDevelopmentStage()) { Moto\System\Log::debug('DETECT MULTI WIDGET ID', array('id' => $widgetId, 'widget' => $widget)); } return false; } return $storage->addWidget($widget); } public static function getCacheOptions() { return Moto\System::app('Widgets.OptionsStorage'); } public static function addToCache($widgetsData) { if (!is_array($widgetsData)) { return false; } return static::getCacheOptions()->fill($widgetsData); } protected static function _getTemplate($widget, $twig = null) { if (!$twig) { $twig = Moto\Render::getInstance(); } return $widget->getRenderTemplate($twig); } protected static function _nameToClass($widgetName) { $parts = explode('_', $widgetName); $parts = array_map('ucfirst', $parts); $widgetClass = implode('', $parts); $parts = explode('.', $widgetClass); $parts = array_map('ucfirst', $parts); $widgetClass = implode('\\', $parts); if (count(($parts)) > 1) { $widgetClass = Moto\System\Widgets\Autoloader::getClassPrefix() . $widgetClass . 'Widget'; } else { $widgetClass = Moto\System\Widgets\Autoloader::getClassPrefix() . $widgetClass . '\\Widget'; } return $widgetClass; } protected static function _getWidgetClassByName($widgetName) { $widgetName = trim($widgetName); $widgetName = strtolower($widgetName); if (!empty(static::$_classMap[$widgetName])) { return static::$_classMap[$widgetName]; } $widgetClass = static::getWidgetInfo($widgetName, 'renderClass'); if (empty($widgetClass)) { if (defined('Moto\Hook::WIDGET_FACTORY__NAME_TO_CLASS')) { $widgetClass = Moto\Hook::trigger(Moto\Hook::WIDGET_FACTORY__NAME_TO_CLASS, $widgetName); } if (empty($widgetClass) || $widgetClass === $widgetName || !is_string($widgetClass)) { $widgetClass = static::_nameToClass($widgetName); } } static::$_classMap[$widgetName] = $widgetClass; return $widgetClass; } public static function convertToSting($widgetName, $options = array()) { $result = ''; $result .= '{{ '; $result .= 'widget("' . $widgetName . '", ' . json_encode($options) . ')'; $result .= ' }}'; return $result; } public static function convertWidgetToMacros($widget) { if ($widget instanceof Moto\System\Widgets\AbstractWidget) { return $widget->convertWidgetToMacros(); } return '{{ widget( ' . Moto\Util::toJson($widget, '@content') . ' ) }}'; } public static function addToClassMap($name, $class) { if (!is_string($class) || !is_string($name)) { return false; } static::$_classMap[$name] = $class; return true; } public static function importClassMap($map) { if (!is_array($map)) { return false; } foreach ($map as $name => $class) { static::addToClassMap($name, $class); } return true; } protected static function _resolveWidgetByName($widgetName) { if (array_key_exists($widgetName, static::$_resolvedWidgets)) { return static::$_resolvedWidgets[$widgetName]; } try { $widgetInfo = static::getWidgetInfo($widgetName); $unknownWidget = (empty($widgetInfo)); if ($unknownWidget) { $widgetInfo = Moto\Hook::trigger(Moto\Hook::WIDGET_FACTORY__NEED_RESOLVE_WIDGET, array(), $widgetName); } if (!static::isValidWidgetInfo($widgetInfo) || $widgetInfo['name'] !== $widgetName) { static::$_resolvedWidgets[$widgetName] = false; return false; } if ($unknownWidget) { static::$_widgetsInfo[$widgetName] = $widgetInfo; } $allowOverwrite = Moto\Util::getFrom($widgetInfo, 'allowOverwrite', true); if (defined('Moto\Hook::WIDGET_FACTORY__WIDGET_BOOTSTRAP')) { $_widgetInfo = Moto\Hook::trigger(Moto\Hook::WIDGET_FACTORY__WIDGET_BOOTSTRAP, $widgetInfo, $widgetName); } if (empty($_widgetInfo['name']) || $_widgetInfo['name'] !== $widgetName) { $allowOverwrite = false; } if ($allowOverwrite) { } static::$_resolvedWidgets[$widgetName] = true; } catch (\Exception $e) { Moto\System\Log::error('WIDGET_NOT_RESOLVED', array( 'widgetName' => $widgetName, 'exception' => array( 'code' => $e->getCode(), 'message' => $e->getMessage(), ) )); static::$_resolvedWidgets[$widgetName] = false; } return true; } public static function getWidgetValidator($widgetName) { static::_resolveWidgetByName($widgetName); if (!static::getWidgetInfo($widgetName, 'validation') || !static::getWidgetInfo($widgetName, 'validation.enabled', true)) { return null; } if (array_key_exists($widgetName, static::$_widgetValidatorInstances)) { return static::$_widgetValidatorInstances[$widgetName]; } $validationClass = static::getWidgetInfo($widgetName, 'validation.class'); $validationFile = static::getWidgetInfo($widgetName, 'validation.file'); if (empty($validationClass) || !Moto\System\Widgets\Autoloader::loadWidgetClass($validationClass, $validationFile)) { Moto\System\Log::alert('WIDGET_CLASS_VALIDATION_NOT_FOUND', array( 'widgetName' => $widgetName, 'renderClass' => $validationClass, 'renderFile' => $validationFile, ) ); throw new Moto\Exception('WIDGET_CLASS_VALIDATION_NOT_FOUND'); } $validator = new $validationClass(); if (static::getWidgetInfo($widgetName, 'validation.instance', true)) { static::$_widgetValidatorInstances[$widgetName] = $validator; } return $validator; } public static function createById($widgetId) { $storage = static::getCacheOptions(); if ($storage->exists($widgetId)) { return static::create($storage->get($widgetId)); } return null; } } 