<?php
 namespace Moto; class SystemEnv { protected $data = []; protected $prefix; protected $casts = [ 'MOTO_ENV_SERVER_CONFIG_FILE' => 'string', 'MOTO_ENV_INCLUDE_PATH_FOR_CONFIG' => 'string|array', 'MOTO_ENV_INCLUDE_PATH_FOR_LIBRARY' => 'string|array', 'MOTO_ENV_PLATFORM_ENABLED' => 'boolean', 'MOTO_ENV_PLATFORM_BASE_URL' => 'string', 'MOTO_ENV_PLATFORM_BACKEND_URL' => 'string', 'MOTO_ENV_PLATFORM_FRONTEND_URL' => 'string', 'MOTO_ENV_PLATFORM_SIGNATURE' => 'string', ]; public function __construct(string $prefix = '') { $this->prefix = $prefix; } public function get($name, $default = null) { if (array_key_exists($name, $this->data)) { return $this->data[$name]; } $this->data[$name] = $this->resolve($name, $default); return $this->data[$name]; } public function set($name, $value) { $this->data[$name] = $value; return $this; } protected function resolve($name, $default) { $key = $this->prefix . $name; if (array_key_exists($key, $_SERVER)) { $value = $_SERVER[$key]; } elseif (array_key_exists($key, $_ENV)) { $value = $_ENV[$key]; } else { return $default; } return $this->sanitizeValue($value, $key); } protected function sanitizeValue($value, $key) { if (!is_string($value)) { return $value; } switch (strtolower($value)) { case 'true': case '(true)': return true; case 'false': case '(false)': return false; case 'empty': case '(empty)': return ''; case 'null': case '(null)': return null; } if (strlen($value) > 1 && $value[0] === '"' && substr($value, -1) === '"') { $value = substr($value, 1, -1); } if (!array_key_exists($key, $this->casts)) { return $value; } switch ($this->casts[$key]) { case 'string|array': if ($value === '') { return []; } if (in_array($value[0], ['{', '['])) { return json_decode($value, true); } return $value; case 'json': case 'array': if ($value === '') { return []; } return json_decode($value, true); case 'object': if ($value === '') { return (object) []; } return json_decode($value); case 'int': case 'integer': return (int) $value; case 'real': case 'float': case 'double': return (float) $value; case 'bool': case 'boolean': return (bool) $value; } return $value; } } 