<?php
namespace Moto\Twig\Extension; use Moto; class AssetExtension extends AbstractExtension { protected $_name = 'motoAsset'; protected $_options = array( 'basePath' => '', 'antiCache' => false, 'antiCacheKey' => '_build=', 'fileHashMethod' => 'filemtime', 'autoAddPath' => true, ); protected $_paths = array(); public function setBaseUrl($url) { $url = rtrim($url, '/') . '/'; $this->_options['baseUrl'] = $url; return $this; } public function getFunctions() { return array( 'asset' => new \Twig_Function_Method($this, 'asset'), 'getFileUrl' => new \Twig_Function_Method($this, 'getFileUrl'), 'assetJavaScript' => new \Twig_Function_Method($this, 'assetJavaScript', array('is_safe' => array('html'))), 'assetStyleSheet' => new \Twig_Function_Method($this, 'assetStyleSheet', array('is_safe' => array('html'))), 'renderHook' => new \Twig_Function_Method($this, 'renderHook', array('is_safe' => array('html'))), 'pageFavicon' => new \Twig_Function_Method($this, 'pageFavicon', array('is_safe' => array('html'))), 'getFileContent' => new \Twig_Function_Method($this, 'getFileContent', array('is_safe' => array('html'))), ); } public function addPath($path, $namespace) { if (!isset($this->_paths[$namespace])) { $this->_paths[$namespace] = array(); } if (is_array($path)) { for ($i = 0, $count = count($path); $i < $count; $i++) { $this->addPath($path[$i], $namespace); } } elseif (!in_array($path, $this->_paths[$namespace])) { $this->_paths[$namespace][] = $path; if ($this->getOption('autoAddPath') && $this->_loader instanceof \Twig_Loader_Filesystem) { $dir = Moto\System::getAbsolutePath($namespace); if (is_dir($dir)) { $this->_loader->addPath($dir, $namespace); } } } return $this; } public function getPath($file, $namespace = null) { if (null == $namespace) { if ($file[0] == '@') { $pos = strpos($file, '/'); if ($pos) { $namespace = substr($file, 1, $pos - 1); $file = substr($file, $pos + 1); } else { $namespace = substr($file, 1); $file = ''; } } else { return $file; } } $filePath = $file; $basePath = $this->getOption('basePath'); $paths = isset($this->_paths[$namespace]) ? $this->_paths[$namespace] : array(); if (empty($paths)) { $paths = array( Moto\System::getRelativePath($namespace) ); } foreach ($paths as $path) { $filePath = $path . (empty($file) ? '': '/' . $file); if (file_exists($basePath . '/' . $filePath)) { break; } } $filePath = preg_replace('/[\/\\\]+/', '/', $filePath); return $filePath; } public function asset($url) { if (empty($url) || !is_string($url)) { return $url; } $url = $this->getPath($url); if ($url[0] !== '/') { $info = parse_url($url); if (empty($info['scheme']) && empty($info['host'])) { $fileHash = (empty($info['path']) ? null : $this->getFileHash($info['path'])); $url = $this->getOption('baseUrl') . $url; if ($fileHash) { $url .= (empty($info['query']) ? '?' : '&') . $this->getOption('antiCacheKey') . $fileHash; } } } return $url; } public function getFileHash($file, $method = null) { if (empty($method) && !$this->getOption('antiCache', false)) { return null; } $file = $this->getOption('basePath') . '/' . $file; $result = null; if (is_file($file)) { if (!$method) { $method = $this->getOption('fileHashMethod'); } switch ($method) { case 'sha1': $result = sha1_file($file); break; case 'md5': $result = md5_file($file); break; default: $result = filemtime($file); break; } } return $result; } public function getFileHash2($file, $method = null) { if (empty($method) && !$this->getOption('antiCache', false)) { return null; } $result = null; if (is_file($file)) { if (!$method) { $method = $this->getOption('fileHashMethod'); } switch ($method) { case 'sha1': $result = sha1_file($file); break; case 'md5': $result = md5_file($file); break; default: $result = filemtime($file); break; } } return $result; } public function isExists($file) { $file = $this->getOption('basePath') . '/' . $file; return (file_exists($file)); } public function getFileUrl($file, $force = false) { $fileUrl = ''; if ($file[0] === '@') { $filePath = Moto\System::getAbsolutePath($file); if (file_exists($filePath)) { $fileHash = $this->getFileHash2($filePath); $urls = array(); if ($this->issetOption('baseUrl')) { $urls['website'] = $this->getOption('baseUrl'); } $fileUrl = Moto\System::getAbsoluteUrl($file, $urls, true); $info = parse_url($file); $fileUrl .= (empty($info['query']) ? '?' : '&') . $this->getOption('antiCacheKey') . $fileHash; } elseif($force) { $fileUrl = Moto\System::getAbsoluteUrl($file, null, true); } } elseif ($file[0] !== '/') { $info = parse_url($file); if (empty($info['scheme']) && empty($info['host'])) { $fileUrl = $this->getOption('baseUrl') . $file; } else { $fileUrl = $file; } } else { $fileUrl = $file; } return $fileUrl; } public function assetJavaScript($file, $force = false) { $code = ''; $url = $this->getFileUrl($file, $force); if (!empty($url)) { $code = '<script src="' . $url . '" type="text/javascript" data-cfasync="false"></script>'; } return $code; } public function assetStyleSheet($file, $force = false) { $code = ''; $url = $this->getFileUrl($file, $force); if (!empty($url)) { $code = '<link rel="stylesheet" href="' . $url . '" />'; } return $code; } public function renderHook($filterName, $value = '') { $filterName = str_replace('render.', '', $filterName); return Moto\Hook::trigger(Moto\Hook::RENDER_NAMESPACE . $filterName, $value); } public function pageFavicon($faviconFile = null) { $code = ''; if (empty($faviconFile)) { $faviconFile = Moto\Website\Settings::get('favicon'); } if (empty($faviconFile)) { return $code; } $favicon = array( 'href' => $faviconFile, 'rel' => 'icon' ); $info = pathinfo($faviconFile); if (!empty($info['extension'])) { switch ($info['extension']) { case 'ico': $favicon['type'] = 'image/vnd.microsoft.icon'; $favicon['rel'] = 'SHORTCUT ICON'; break; case 'jpeg'; case 'jpg': $favicon['type'] = 'image/jpeg'; break; case 'webp': $favicon['type'] = 'image/webp'; break; case 'png': $favicon['type'] = 'image/png'; break; } } if ($favicon['href'][0] !== '@') { $favicon['href'] = Moto\Util::updateResourcePath($favicon['href'], '@userUploads'); } $favicon['href'] = $this->getFileUrl($favicon['href'], true); $code = '<link' . (isset($favicon['rel']) && $favicon['rel'] != '' ? ' rel="' . $favicon['rel'] . '"' : '') . (isset($favicon['href']) && $favicon['href'] != '' ? ' href="' . $favicon['href'] . '"' : '') . (isset($favicon['type']) && $favicon['type'] != '' ? ' type="' . $favicon['type'] . '"' : '') . " />\n"; return $code; } function getFileContent($file) { $whiteList = array( '@userFontsFile', ); $content = ''; if (!in_array($file, $whiteList)) { if (Moto\System::isDevelopmentStage()) { $content = "\n\n<!-- Function 'getFileContent' blocked $file -->\n\n"; } return $content; } $filePath = Moto\System::getAbsolutePath($file); if (file_exists($filePath)) { $content = file_get_contents($filePath); } return $content; } } 