<?php
 namespace Moto\Twig\Resolver; use Illuminate\Support\Collection; use Moto; use Twig; class Manager { protected $engine; protected $extensions = []; protected $extensionsByClass = []; protected $functions = []; protected $resolvers; public function __construct(Moto\Twig\Environment $engine) { $this->setEngine($engine); } public function setEngine(Moto\Twig\Environment $engine) { $this->engine = $engine; return $this; } public function setExtension(ExtensionInterface $extension, $class = null, $name = null) { if (empty($class)) { $class = $extension->getResolvedClass(); } $this->extensionsByClass[$class] = $extension; if (empty($name)) { $name = $extension->getName(); } $this->extensions[$name] = $extension; return $this; } public function hasExtension($class) { $class = ltrim($class, '\\'); if (array_key_exists($class, $this->extensionsByClass)) { return true; } if (array_key_exists($class, $this->extensions)) { return true; } return $this->findTarget('hasExtension', $class); } public function getExtension($class) { $class = ltrim($class, '\\'); if (array_key_exists($class, $this->extensionsByClass)) { return $this->extensionsByClass[$class]; } if (array_key_exists($class, $this->extensions)) { return $this->extensions[$class]; } return $this->findTarget('getExtension', $class); } public function getResolvers() { if (!$this->resolvers) { $this->resolvers = new Collection(); } return $this->resolvers; } public function addResolver($resolver) { if (!is_object($resolver)) { throw new \InvalidArgumentException('Resolver must be a object'); } $resolvers = $this->getResolvers(); $resolvers->push($resolver); return $this; } public function getFunction($name, $existed) { return $this->findTarget('getFunction', $name, $existed); } protected function findTarget($method, $target, $extra = null) { $result = null; $resolvers = $this->getResolvers(); foreach ($resolvers as $resolver) { if (!method_exists($resolver, $method)) { continue; } $result = $resolver->{$method}($target, $extra); if ($result) { return $result; } } return $result; } } 