<?php
namespace Moto\Validator; use Moto; use ReCaptcha\ReCaptcha as ReCaptchaSDK; use ReCaptcha\RequestMethod\CurlPost as RequestMethod; class ReCaptcha extends AbstractValidator { protected $messageTemplates = array( 'timeout-or-duplicate' => 'timeout-or-duplicate', 'missing-input-secret' => 'The secret parameter is missing.', 'invalid-input-secret' => 'The secret parameter is invalid or malformed.', 'missing-input-response' => 'The response parameter is missing.', 'invalid-input-response' => 'The response parameter is invalid or malformed.', 'bad-request' => 'The request is invalid or malformed.', ); public function isValid($value, array $context = array()) { $data = Moto\Website\Integration::first('recaptcha'); $secret = Moto\Util::getValue($data, 'v2.secret_key'); if (empty($secret)) { return false; } $recaptcha = new ReCaptchaSDK($secret, new RequestMethod()); $resp = $recaptcha->verify($value); if ($resp->isSuccess()) { return true; } $errors = $resp->getErrorCodes(); foreach ($errors as $error) { if (!array_key_exists($error, $this->abstractOptions['messageTemplates'])) { $this->abstractOptions['messageTemplates'][$error] = $error; } $this->error($error); } return false; } } 