<?php
 namespace Moto\Website\Application; use Moto; class Manager { protected $defaultApplicationClass = Moto\Website\Application::class; protected $_applicationsMap = [ ]; protected $currentRequest; protected $app; protected $router; protected $instances = []; public function __construct(Moto\System\Application $app) { $this->app = $app; } protected function app($resource = null, array $params = []) { if ($resource === null) { return $this->app; } return $this->app->makeWith($resource, $params); } public function getCurrentRequest() { return $this->currentRequest; } protected $verbose = false; protected function verbose($message) { if (!$this->verbose) { return; } Moto\System\Log::debug($message); } public function resolveApplicationByRequest($request) { $this->currentRequest = $request; $instance = null; $this->verbose('Request uri : ' . $request->url()); try { $router = $this->getRouter(); $response = $router->dispatch($request); if (is_string($response)) { $this->verbose('resolved application name : ' . $response); $instance = $this->getApplication($response); } elseif ($response instanceof Moto\Website\Application) { $this->verbose("application resolved by response instance"); $instance = $response; } } catch (\Exception $e) { echo '[router] Exception : ' . get_class($e) . " => "; echo $e->getCode() . ' ' . $e->getMessage() . "\n"; echo $e->getTraceAsString(); exit; } if (!$instance) { $this->verbose("not resolved application : use fallback"); $instance = $this->getDefaultApplication(); } $this->verbose('application instance : ' . get_class($instance)); return $instance; } protected function getRouter() { if ($this->router) { return $this->router; } $router = $this->app(Moto\Website\Application\Router::class); $this->router = $router; $router->any('/', function () { return $this->getHomePageApplication(); }); $router->any("{fallback}", function () { return $this->getDefaultApplication(); })->where('fallback', '.*')->fallback(); return $router; } protected function hasInstance($class) { return array_key_exists($class, $this->instances); } protected function getInstance($class) { if (array_key_exists($class, $this->instances)) { return $this->instances[$class]; } return null; } protected function setInstance($app) { if (!is_object($app)) { return false; } $class = get_class($app); if (!array_key_exists($class, $this->instances)) { $this->app()->instance($class, $app); $this->instances[$class] = $app; } return $app; } public function getApplication($app) { $instance = $this->getApplicationByName($app); if (!$instance) { $instance = $this->getApplicationByClass($app); } return $instance; } public function definedApplicationName($name) { return array_key_exists($name, $this->_applicationsMap); } protected function getApplicationByName($name) { $class = Moto\Util::getValue($this->_applicationsMap, $name); if (!$class || !class_exists($class)) { return false; } $this->verbose('getApplicationByName : ' . $name); return $this->getApplicationByClass($class); } protected function getApplicationByClass($class) { if (!class_exists($class)) { $this->verbose('getApplicationByClass : not existed class ' . $class); return false; } $instance = $this->getInstance($class); if (!$instance) { $this->verbose('getApplicationByClass : create new instance '); $instance = $this->setInstance($this->app($class)); } $this->verbose('getApplicationByClass : return app ' . get_class($instance)); return $instance; } protected function getDefaultApplication() { $this->verbose('return default application'); return $this->getApplicationByClass($this->defaultApplicationClass); } protected function getHomePageApplication() { $this->verbose('return HomePage application'); return $this->app('HomePageProvider')->getBootedApplication(); } protected function addToApplicationMap($namespace, $class) { $this->verbose(var_export([ '__FUNCTION__' => __FUNCTION__, '$namespace' => (is_object($namespace) ? 'object : ' . get_class($namespace) : $namespace), '$class' => (is_object($class) ? 'object : ' . get_class($class) : $class), ], true)); $this->_applicationsMap[$namespace] = $class; } public function addSection($name, $target, $routes = null) { if (is_array($name)) { $names = $name; foreach ($names as $name) { $this->addSection($name, $target, $routes); } return true; } $router = $this->getRouter(); if ($target instanceof Moto\Website\Application) { $routes = $target->getRouteUri(); $this->instances[$name] = $target; $this->addToApplicationMap($name, get_class($target)); } else { $this->addToApplicationMap($name, $target); } if ($routes === null) { $routes = $name; } $routes = (array) $routes; $this->verbose(var_export([ '__FUNCTION__' => __FUNCTION__, '$name' => (is_object($name) ? 'object : ' . get_class($name) : $name), '$target' => (is_object($target) ? 'object : ' . get_class($target) : $target), '$routes' => (is_object($routes) ? 'object : ' . get_class($routes) : $routes), ], true)); foreach ($routes as $route) { $router->any($route, function () use ($target) { return $target; }); $router->any($route . '/{any}', function () use ($target) { return $target; })->where('any', '.*'); } return true; } } 