<?php
namespace Moto\Website; use Moto; class Integration { CONST WEBSITE_NAMESPACE = 'integrations'; protected static $_initialized = false; protected static $_collections = array(); public static function init() { if (static::$_initialized) { return; } static::$_initialized = true; static::_loadList(); } public static function getCollections() { static::init(); return static::$_collections; } protected static function all($type = '', $default = array()) { static::init(); $type = static::sanitize('type', $type); if (empty($type)) { return static::$_collections; } return (array_key_exists($type, static::$_collections) ? static::$_collections[$type]->items() : $default); } public static function first($type) { static::init(); $collection = static::get($type); return $collection->first(); } protected static function sanitize($name, $value) { if ($name === 'type') { $value = (string) $value; $value = strtolower($value); $value = trim($value); } return $value; } public static function get($type) { static::init(); $type = static::sanitize('type', $type); $collection = null; if (static::exists($type)) { $collection = static::$_collections[$type]; } else { $collection = new Collection(array('type' => $type)); static::$_collections[$collection->getType()] = $collection; } return $collection; } public static function exists($type) { static::init(); $type = static::sanitize('type', $type); return array_key_exists($type, static::$_collections); } public static function delete($type) { static::init(); $type = static::sanitize('type', $type); if (static::exists($type)) { static::get($type)->delete(); } return true; } protected static function _loadList() { $items = Moto\Website\Settings::get(static::WEBSITE_NAMESPACE); if (is_string($items)) { $items = json_decode($items); } if (is_array($items) || is_object($items)) { foreach($items as $item) { $collection = new Collection($item); static::$_collections[$collection->getType()] = $collection; } } } protected static function _saveList() { if (!Moto\Website\Settings::isExists(static::WEBSITE_NAMESPACE)) { Moto\Website\Settings::add(static::WEBSITE_NAMESPACE, static::toArray(), 'array'); } else { Moto\Website\Settings::set(static::WEBSITE_NAMESPACE, static::toArray()); } } public static function save() { static::init(); static::_saveList(); } public static function toArray() { $data = array(); foreach(static::$_collections as $collection) { if (!$collection->trashed()) { $data[] = $collection->toArray(); } } return $data; } } class Collection extends Item { protected $_items = array(); protected function setType($type) { $type = strtolower($type); $type = trim($type); $this->_data['type'] = $type; } public function getType() { return $this->_data['type']; } public function setItems($items) { foreach($items as $data) { $item = new Item(); $item->fromArray($data); $this->_items[] = $item; } } public function items() { return $this->_items; } public function count() { return count($this->_items); } public function getItems() { return $this->items(); } public function first() { if (count($this->_items) > 0) { $item = $this->_items[0]; } else { $item = new Item(); $this->_items[] = $item; } return $item; } public function toArray() { $data = array( 'type' => $this->type, 'items' => array(), ); foreach($this->_items as $item) { if (!$item->trashed()) { $data['items'][] = $item->toArray(); } } return $data; } } class Item { protected $_data = array(); public function __construct(array $data = array()) { if (is_array($data)) { $this->fromArray($data); } } public function fromArray($data) { $data = (array) $data; foreach($data as $name => $value) { $this->__set($name, $value); } return $this; } public function toArray() { return $this->_data; } public function __get($name) { $method = 'get' . str_replace(' ', '', ucwords(str_replace('_', ' ', $name))); if (method_exists($this, $method)) { return $this->{$method}(); } return (array_key_exists($name, $this->_data) ? $this->_data[$name] : null); } public function __isset($name) { return array_key_exists($name, $this->_data); } public function __set($name, $value) { $method = 'set' . str_replace(' ', '', ucwords(str_replace('_', ' ', $name))); if (method_exists($this, $method)) { return $this->{$method}($value); } else { $this->_data[$name] = $value; } } public function save() { Integration::save(); } public function trashed() { return (array_key_exists('deleted', $this->_data)); } public function delete() { if (!$this->trashed()) { $this->_data['deleted'] = true; Integration::save(); } } } 