<?php
 namespace Moto\Website\Packages; use ArrayAccess; use Illuminate\Contracts\Support\Arrayable; use JsonSerializable; use Moto; use Moto\Twig\Extension\AssetExtension; use RuntimeException; class PackageAsset implements ArrayAccess, JsonSerializable, Arrayable { const TYPE__STYLE = 'style'; const TYPE__SCRIPT = 'script'; const DEFAULT_STYLE_SLOT = 'website.head'; const DEFAULT_SCRIPT_SLOT = 'website.footer'; protected $attributes = [ 'slot' => null, 'type' => null, 'src' => null, ]; public function __construct(array $attributes) { $this->attributes = array_merge($this->attributes, $attributes); } protected function detectRuntimeError($message) { if (Moto\System::isDevelopmentStage()) { Moto\System\Log::emergency($message . ' => ' . var_export($this->attributes, true)); } throw new RuntimeException($message); } public function getSource() { return $this->attributes['src']; } protected function resolveType() { $src = $this->getSource(); if (!$src) { return false; } $extension = strtolower(pathinfo($src, PATHINFO_EXTENSION)); if ($extension === 'css') { return self::TYPE__STYLE; } if ($extension === 'js') { return self::TYPE__SCRIPT; } return $this->detectRuntimeError('Cant resolve type for extension : ' . var_export($extension, true)); } public function getType() { if ($this->attributes['type'] === null) { $this->attributes['type'] = $this->resolveType(); } return $this->attributes['type']; } protected function resolveSlot() { $type = $this->getType(); if ($type === static::TYPE__STYLE) { return static::DEFAULT_STYLE_SLOT; } if ($type === static::TYPE__SCRIPT) { return static::DEFAULT_SCRIPT_SLOT; } return $this->detectRuntimeError('Cant resolve slot for type : ' . var_export($type, true)); } public function getSlot() { if ($this->attributes['slot'] === null) { $this->attributes['slot'] = $this->resolveSlot(); } return $this->attributes['slot']; } protected function isStyle() { return $this->getType() === static::TYPE__STYLE; } protected function isScript() { return $this->getType() === static::TYPE__SCRIPT; } protected function getAssetExtension() { return Moto\Render::getInstance()->getExtension('motoAsset'); } protected function generateStyleSourceCode() { $source = $this->getSource(); if (empty($source)) { return false; } return $this->getAssetExtension() ->assetStyleSheet($this->getSource(), true); } protected function generateScriptSourceCode() { $source = $this->getSource(); if (empty($source)) { return false; } return $this->getAssetExtension() ->assetJavaScript($this->getSource(), true); } public function generateSourceCode() { if ($this->isStyle()) { return $this->generateStyleSourceCode(); } if ($this->isScript()) { return $this->generateScriptSourceCode(); } return false; } public function toArray() { return $this->attributes; } public function hasAttribute(string $attribute) { return array_key_exists($attribute, $this->attributes); } public function getAttribute(string $attribute, $default = null) { if (array_key_exists($attribute, $this->attributes)) { return $this->attributes[$attribute]; } return $default; } public function offsetExists($attribute) { return $this->hasAttribute($attribute); } public function offsetGet($attribute) { return $this->getAttribute($attribute); } public function offsetSet($attribute, $value) { return; } public function offsetUnset($offset) { return; } public function __get($name) { return $this->getAttribute($name); } public function __isset($name) { return $this->offsetExists($name); } public function jsonSerialize() { return $this->toArray(); } } 