<?php
 namespace Moto\Website\Packages; use Illuminate\Support\Collection; class PackageManager { protected $registered; protected $required = []; protected function getRegistered() { if (!$this->registered) { $this->registered = new Collection(); } return $this->registered; } protected function sanitizeName($package) { if ($package instanceof Package) { return $package->getName(); } if (!is_string($package)) { throw new \InvalidArgumentException('Invalid package'); } return $package; } public function isRegistered($package) { return $this->getRegistered()->has($this->sanitizeName($package)); } public function getPackage(string $name) { return $this->getRegistered()->get($name); } public function register($package, array $assets = []) { if ($this->isRegistered($package)) { return false; } if (is_string($package)) { $package = Package::create($package, $assets); } if ($package instanceof Package) { $this->getRegistered()->put($package->getName(), $package); return true; } return false; } public function require($packages) { $packages = (array) $packages; foreach ($packages as $package) { if (!$this->isRegistered($package)) { continue; } $this->required[] = $this->sanitizeName($package); } return $this; } public function getRequiredAssets(string $slot) { $this->required = array_unique($this->required); $required = []; foreach ($this->required as $name) { if (empty($name) || !($package = $this->getPackage($name))) { continue; } $assets = $package->getAssetsForSlot($slot); if (is_array($assets)) { array_push($required, ...$assets); } elseif ($assets) { $required[] = $assets; } } return $required; } } 